/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.jira.core.ITaskAttributeMapper2;
import org.eclipse.mylyn.internal.jira.core.TaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComplexAttributeConverter<T> {
    private final List<? extends TaskSchema.TaskField<?>> fields;

    public AbstractComplexAttributeConverter(List<? extends TaskSchema.TaskField<?>> fields) {
        this.fields = fields;
    }

    protected abstract T newInstance();

    public T createFrom(TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        T instance = this.newInstance();
        for (TaskSchema.TaskField<?> field : this.fields) {
            TaskAttribute child = taskAttribute.getAttribute(field.key());
            if (child == null) continue;
            this.setJavaField(instance, field, child);
        }
        return instance;
    }

    public void applyTo(T instance, TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        for (TaskSchema.TaskField<?> field : this.fields) {
            TaskAttribute child = this.addAttribute(taskAttribute, field);
            this.setAttributeValue(instance, field, child);
        }
    }

    private boolean setJavaField(T instance, TaskSchema.TaskField<?> taskField, TaskAttribute attribute) {
        if (taskField.javaKey() != null) {
            try {
                Object value;
                Field field = instance.getClass().getDeclaredField(taskField.javaKey());
                field.setAccessible(true);
                TaskAttributeMapper mapper = attribute.getTaskData().getAttributeMapper();
                if ("date".equals(taskField.getType())) {
                    value = mapper.getDateValue(attribute);
                } else if ("dateTime".equals(taskField.getType())) {
                    value = mapper.getDateValue(attribute);
                } else if ("integer".equals(taskField.getType())) {
                    value = mapper.getIntegerValue(attribute);
                    if (value == null) {
                        value = 0;
                    }
                } else if ("long".equals(taskField.getType())) {
                    value = mapper.getLongValue(attribute);
                    if (value == null) {
                        value = 0;
                    }
                } else {
                    value = attribute.getValue();
                }
                field.set(instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean setAttributeValue(T instance, TaskSchema.TaskField<?> taskField, TaskAttribute attribute) {
        try {
            Field field = instance.getClass().getDeclaredField(taskField.javaKey());
            field.setAccessible(true);
            Object value = field.get(instance);
            TaskAttributeMapper mapper = attribute.getTaskData().getAttributeMapper();
            if (value == null) {
                attribute.clearValues();
            } else if ("date".equals(taskField.getType())) {
                mapper.setDateValue(attribute, (Date)value);
            } else if ("dateTime".equals(taskField.getType())) {
                mapper.setDateValue(attribute, (Date)value);
            } else if ("integer".equals(taskField.getType())) {
                mapper.setIntegerValue(attribute, (Integer)value);
            } else if ("long".equals(taskField.getType())) {
                mapper.setLongValue(attribute, (Long)value);
            } else {
                attribute.setValue(value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public TaskAttribute addAttribute(TaskAttribute parent, TaskSchema.TaskField<?> field) {
        TaskAttribute attribute = parent.createAttribute(field.key());
        TaskAttributeMetaData metaData = attribute.getMetaData();
        metaData.setLabel(field.getLabel());
        metaData.setType(field.getType());
        metaData.setReadOnly(field.isReadOnly());
        metaData.setKind(field.getKind());
        Map<String, String> options = ((ITaskAttributeMapper2)parent.getTaskData().getAttributeMapper()).getRepositoryOptions(attribute);
        if (options != null) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                attribute.putOption(option.getKey(), option.getValue());
            }
        }
        return attribute;
    }
}

