/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientData;
import org.eclipse.mylyn.internal.jira.core.service.JiraConfiguration;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;

public class JiraClientManager {
    public static final String CONFIGURATION_DATA_FILENAME = "repositoryConfigurations";
    public static final int CONFIGURATION_DATA_VERSION = 1;
    private final File cacheLocation;
    private final Map<String, JiraClient> clientByUrl = new HashMap<String, JiraClient>();
    private final Map<String, JiraClientData> clientDataByUrl = new HashMap<String, JiraClientData>();

    public JiraClientManager(File cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    protected void start() {
        block19: {
            this.cacheLocation.mkdirs();
            File file = new File(this.cacheLocation, CONFIGURATION_DATA_FILENAME);
            if (!file.exists()) {
                File[] clients;
                File[] fileArray = clients = this.cacheLocation.listFiles();
                int n = clients.length;
                int n2 = 0;
                while (n2 < n) {
                    File directory = fileArray[n2];
                    File oldData = new File(directory, "server.ser");
                    if (oldData.exists()) {
                        oldData.delete();
                        directory.delete();
                    }
                    ++n2;
                }
            } else {
                ObjectInputStream in = null;
                try {
                    try {
                        in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                        in.readInt();
                        int count = in.readInt();
                        int i = 0;
                        while (i < count) {
                            String url = (String)in.readObject();
                            JiraClientData data = (JiraClientData)in.readObject();
                            this.clientDataByUrl.put(url, data);
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.internal.jira.core", "Reset JIRA repository configuration cache due to format change"));
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void stop() {
        block16: {
            File file = new File(this.cacheLocation, CONFIGURATION_DATA_FILENAME);
            for (String url : this.clientByUrl.keySet()) {
                this.clientDataByUrl.put(url, this.clientByUrl.get(url).getCache().getData());
            }
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    out.writeInt(1);
                    out.writeInt(this.clientDataByUrl.size());
                    for (String url : this.clientDataByUrl.keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.clientDataByUrl.get(url));
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", "Error writing JIRA repository configuration cache", e));
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ServerInfo validateConnection(AbstractWebLocation location, JiraConfiguration configuration, IProgressMonitor monitor) throws JiraException {
        JiraClient client = this.createClient(location, configuration);
        return client.getServerInfo(monitor);
    }

    public JiraClient getClient(String url) {
        return this.clientByUrl.get(url);
    }

    public JiraClient[] getAllClients() {
        return this.clientByUrl.values().toArray(new JiraClient[this.clientByUrl.size()]);
    }

    private JiraClient createClient(AbstractWebLocation location, JiraConfiguration configuration) {
        return new JiraClient(location, configuration);
    }

    public JiraClient addClient(AbstractWebLocation location, JiraConfiguration configuration) {
        if (this.clientByUrl.containsKey(location.getUrl())) {
            throw new RuntimeException("A client with that name already exists");
        }
        JiraClient client = this.createClient(location, configuration);
        JiraClientData data = this.clientDataByUrl.get(location.getUrl());
        if (data != null) {
            client.getCache().setData(data);
        }
        this.clientByUrl.put(location.getUrl(), client);
        return client;
    }

    public void refreshClient() {
    }

    public void removeClient(JiraClient client, boolean clearData) {
        if (clearData) {
            this.clientDataByUrl.remove(client.getBaseUrl());
        } else {
            this.clientDataByUrl.put(client.getBaseUrl(), client.getCache().getData());
        }
        this.clientByUrl.remove(client.getBaseUrl());
    }

    public void removeAllClients(boolean clearData) {
        if (clearData) {
            this.clientDataByUrl.clear();
        }
        this.clientByUrl.clear();
    }
}

