/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.util.EnumSet;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class TaskSchema {
    public static final EnumSet<Flag> NO_FLAGS = EnumSet.noneOf(Flag.class);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtTaskAttribute<T> {
        private final TaskAttribute attribute;

        public ExtTaskAttribute(TaskAttribute attribute) {
            this.attribute = attribute;
        }

        public T getValue() {
            return (T)this.attribute.getValue();
        }

        public void setValue(T value) {
            this.attribute.setValue(value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        ATTRIBUTE,
        EXISTING_ONLY,
        PEOPLE,
        READ_ONLY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskField<T> {
        private EnumSet<Flag> flags;
        private final String key;
        private final String label;
        private final String type;
        private final String javaKey;
        private final Class<T> clazz;

        public TaskField(Class<T> clazz, String key, String javaKey, String label, String type) {
            this(clazz, key, javaKey, label, type, null, new Flag[0]);
        }

        public TaskField(Class<T> clazz, String key, String javaKey, String label, String type, Flag firstFlag, Flag ... moreFlags) {
            this.clazz = clazz;
            this.key = key;
            this.javaKey = javaKey;
            this.label = label;
            this.type = type;
            this.flags = firstFlag == null ? NO_FLAGS : EnumSet.of(firstFlag, moreFlags);
        }

        public Class<T> getJavaClass() {
            return this.clazz;
        }

        String javaKey() {
            return this.javaKey;
        }

        public String key() {
            return this.key;
        }

        public String getKind() {
            if (this.flags.contains((Object)Flag.ATTRIBUTE)) {
                return "task.common.kind.default";
            }
            if (this.flags.contains((Object)Flag.PEOPLE)) {
                return "task.common.kind.people";
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.flags.contains((Object)Flag.READ_ONLY);
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

