/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraVersion
implements Comparable<JiraVersion> {
    public static final JiraVersion MIN_VERSION = new JiraVersion("3.3.3");
    public static final JiraVersion JIRA_3_3 = new JiraVersion("3.3");
    public static final JiraVersion JIRA_3_4 = new JiraVersion("3.4");
    public static final JiraVersion JIRA_3_7 = new JiraVersion("3.7");
    public static final JiraVersion JIRA_3_10 = new JiraVersion("3.10");
    public static final JiraVersion JIRA_3_11 = new JiraVersion("3.11");
    public static final JiraVersion JIRA_3_12 = new JiraVersion("3.12");
    public static final JiraVersion JIRA_3_13 = new JiraVersion("3.13");
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public JiraVersion(String version) {
        String[] segments = version == null ? new String[]{} : version.split("\\.");
        this.major = segments.length > 0 ? this.parse(segments[0]) : 0;
        this.minor = segments.length > 1 ? this.parse(segments[1]) : 0;
        this.micro = segments.length > 2 ? this.parse(segments[2]) : 0;
        this.qualifier = segments.length == 0 ? "" : this.getQualifier(segments[segments.length - 1]);
    }

    private int parse(String segment) {
        try {
            return segment.length() == 0 ? 0 : Integer.parseInt(this.getVersion(segment));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getVersion(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? segment : segment.substring(0, n);
    }

    private String getQualifier(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? "" : segment.substring(n + 1);
    }

    public boolean isSmallerOrEquals(JiraVersion v) {
        return this.compareTo(v) <= 0;
    }

    @Override
    public int compareTo(JiraVersion v) {
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        if (this.micro < v.micro) {
            return -1;
        }
        if (this.micro > v.micro) {
            return 1;
        }
        return this.qualifier.compareTo(v.qualifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.major));
        sb.append(".").append(Integer.toString(this.minor));
        if (this.micro > 0) {
            sb.append(".").append(Integer.toString(this.micro));
        }
        if (this.qualifier.length() > 0) {
            sb.append("-").append(this.qualifier);
        }
        return sb.toString();
    }
}

