/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model.filter;

import java.io.Serializable;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.filter.Filter;

public class VersionFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Version[] versions;
    private final boolean unreleasedVersions;
    private final boolean releasedVersions;

    public VersionFilter(Version[] versions) {
        if (versions == null) {
            throw new IllegalArgumentException();
        }
        this.versions = versions;
        this.unreleasedVersions = false;
        this.releasedVersions = false;
    }

    public VersionFilter(boolean released, boolean unreleased) {
        this.versions = null;
        this.releasedVersions = released;
        this.unreleasedVersions = unreleased;
    }

    public boolean isReleasedVersions() {
        return this.releasedVersions;
    }

    public boolean isUnreleasedVersions() {
        return this.unreleasedVersions;
    }

    public boolean hasNoVersion() {
        return this.versions != null && this.versions.length == 0;
    }

    public Version[] getVersions() {
        return this.versions;
    }

    VersionFilter copy() {
        if (this.versions != null) {
            return new VersionFilter(this.versions);
        }
        return new VersionFilter(this.releasedVersions, this.unreleasedVersions);
    }

    public String toString() {
        if (this.versions == null) {
            if (this.isReleasedVersions()) {
                return "<released versions>";
            }
            if (this.isUnreleasedVersions()) {
                return "<unreleased versions>";
            }
        }
        if (this.hasNoVersion()) {
            return "<no version>";
        }
        return "<specified versions>";
    }
}

