/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientData;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.service.Messages;

public class JiraClientCache {
    private volatile JiraClientData data;
    private final JiraClient jiraClient;

    public JiraClientCache(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.data = new JiraClientData();
    }

    public JiraStatus getStatusById(String id) {
        return this.data.statusesById.get(id);
    }

    public JiraStatus[] getStatuses() {
        return this.data.statuses;
    }

    public IssueType getIssueTypeById(String id) {
        return this.data.issueTypesById.get(id);
    }

    public IssueType[] getIssueTypes() {
        return this.data.issueTypes;
    }

    public boolean hasDetails() {
        return this.data.lastUpdate != 0L;
    }

    private void initializeProjects(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        String version = data.serverInfo.getVersion();
        data.projects = this.jiraClient.getProjects(monitor);
        data.projectsById = new HashMap<String, Project>(data.projects.length);
        data.projectsByKey = new HashMap<String, Project>(data.projects.length);
        Project[] projectArray = data.projects;
        int n = data.projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            project.setComponents(this.jiraClient.getComponents(project.getKey(), monitor));
            project.setVersions(this.jiraClient.getVersions(project.getKey(), monitor));
            if (this.supportsPerProjectIssueTypes(version) >= 0) {
                IssueType[] subTaskIssueTypes;
                IssueType[] issueTypes = this.jiraClient.getIssueTypes(project.getId(), monitor);
                IssueType[] issueTypeArray = subTaskIssueTypes = this.jiraClient.getSubTaskIssueTypes(project.getId(), monitor);
                int n3 = subTaskIssueTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IssueType issueType = issueTypeArray[n4];
                    issueType.setSubTaskType(true);
                    ++n4;
                }
                IssueType[] projectIssueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
                System.arraycopy(issueTypes, 0, projectIssueTypes, 0, issueTypes.length);
                System.arraycopy(subTaskIssueTypes, 0, projectIssueTypes, issueTypes.length, subTaskIssueTypes.length);
                project.setIssueTypes(projectIssueTypes);
            }
            if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_13) >= 0) {
                try {
                    SecurityLevel[] securityLevels = this.jiraClient.getAvailableSecurityLevels(project.getKey(), monitor);
                    if (securityLevels.length > 0) {
                        SecurityLevel[] projectSecurityLevels = new SecurityLevel[securityLevels.length + 1];
                        projectSecurityLevels[0] = SecurityLevel.NONE;
                        System.arraycopy(securityLevels, 0, projectSecurityLevels, 1, securityLevels.length);
                        project.setSecurityLevels(projectSecurityLevels);
                    }
                }
                catch (JiraInsufficientPermissionException jiraInsufficientPermissionException) {
                    project.setSecurityLevels(null);
                }
            }
            data.projectsById.put(project.getId(), project);
            data.projectsByKey.put(project.getKey(), project);
            ++n2;
        }
    }

    public Project getProjectById(String id) {
        return this.data.projectsById.get(id);
    }

    public Project getProjectByKey(String key) {
        return this.data.projectsByKey.get(key);
    }

    public Project[] getProjects() {
        return this.data.projects;
    }

    private void initializePriorities(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.priorities = this.jiraClient.getPriorities(monitor);
        data.prioritiesById = new HashMap<String, Priority>(data.priorities.length);
        Priority[] priorityArray = data.priorities;
        int n = data.priorities.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            data.prioritiesById.put(priority.getId(), priority);
            ++n2;
        }
    }

    public Priority getPriorityById(String id) {
        return this.data.prioritiesById.get(id);
    }

    public Priority[] getPriorities() {
        return this.data.priorities;
    }

    private void initializeIssueTypes(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        String version = data.serverInfo.getVersion();
        if (this.supportsPerProjectIssueTypes(version) >= 0) {
            HashSet<IssueType> issueTypes = new HashSet<IssueType>();
            Serializable[] serializableArray = data.projects;
            int n = data.projects.length;
            int n2 = 0;
            while (n2 < n) {
                Project project = serializableArray[n2];
                IssueType[] projectIssueTypes = project.getIssueTypes();
                if (projectIssueTypes != null) {
                    issueTypes.addAll(Arrays.asList(projectIssueTypes));
                }
                ++n2;
            }
            data.issueTypes = issueTypes.toArray(new IssueType[0]);
            data.issueTypesById = new HashMap<String, IssueType>(data.issueTypes.length);
            serializableArray = data.issueTypes;
            n = data.issueTypes.length;
            n2 = 0;
            while (n2 < n) {
                Serializable issueType = serializableArray[n2];
                data.issueTypesById.put(((IssueType)issueType).getId(), (IssueType)issueType);
                ++n2;
            }
        } else {
            IssueType issueType;
            IssueType[] issueTypes = this.jiraClient.getIssueTypes(monitor);
            IssueType[] subTaskIssueTypes = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_3) >= 0 ? this.jiraClient.getSubTaskIssueTypes(monitor) : new IssueType[]{};
            data.issueTypesById = new HashMap<String, IssueType>(issueTypes.length + subTaskIssueTypes.length);
            IssueType[] issueTypeArray = issueTypes;
            int n = issueTypes.length;
            int n3 = 0;
            while (n3 < n) {
                issueType = issueTypeArray[n3];
                data.issueTypesById.put(issueType.getId(), issueType);
                ++n3;
            }
            issueTypeArray = subTaskIssueTypes;
            n = subTaskIssueTypes.length;
            n3 = 0;
            while (n3 < n) {
                issueType = issueTypeArray[n3];
                issueType.setSubTaskType(true);
                data.issueTypesById.put(issueType.getId(), issueType);
                ++n3;
            }
            data.issueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
            System.arraycopy(issueTypes, 0, data.issueTypes, 0, issueTypes.length);
            System.arraycopy(subTaskIssueTypes, 0, data.issueTypes, issueTypes.length, subTaskIssueTypes.length);
        }
    }

    private void initializeStatuses(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.statuses = this.jiraClient.getStatuses(monitor);
        data.statusesById = new HashMap<String, JiraStatus>(data.statuses.length);
        JiraStatus[] jiraStatusArray = data.statuses;
        int n = data.statuses.length;
        int n2 = 0;
        while (n2 < n) {
            JiraStatus status = jiraStatusArray[n2];
            data.statusesById.put(status.getId(), status);
            ++n2;
        }
    }

    private void initializeResolutions(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        data.resolutions = this.jiraClient.getResolutions(monitor);
        data.resolutionsById = new HashMap<String, Resolution>(data.resolutions.length);
        Resolution[] resolutionArray = data.resolutions;
        int n = data.resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution resolution = resolutionArray[n2];
            data.resolutionsById.put(resolution.getId(), resolution);
            ++n2;
        }
    }

    public Resolution getResolutionById(String id) {
        return this.data.resolutionsById.get(id);
    }

    public Resolution[] getResolutions() {
        return this.data.resolutions;
    }

    public void setData(JiraClientData data) {
        this.data = data;
    }

    public JiraClientData getData() {
        return this.data;
    }

    public synchronized void refreshDetails(IProgressMonitor monitor) throws JiraException {
        try {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            monitor.beginTask(Messages.JiraClientCache_Updating_repository_configuration, -1);
            JiraClientData newData = new JiraClientData();
            this.data.serverInfo = newData.serverInfo = this.jiraClient.getServerInfo(monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeProjects(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializePriorities(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeIssueTypes(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeResolutions(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            this.initializeStatuses(newData, monitor);
            Policy.advance((IProgressMonitor)monitor, (int)1);
            newData.lastUpdate = System.currentTimeMillis();
            this.data = newData;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void refreshServerInfo(IProgressMonitor monitor) throws JiraException {
        try {
            monitor.beginTask(Messages.JiraClientCache_Getting_server_information, -1);
            this.data.serverInfo = this.jiraClient.getServerInfo(monitor);
        }
        finally {
            monitor.done();
        }
    }

    public ServerInfo getServerInfo() {
        return this.data.serverInfo;
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo info = this.data.serverInfo;
        if (info == null) {
            info = this.jiraClient.getServerInfo(monitor);
        }
        this.data.serverInfo = info;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String name) {
        Map<String, User> map = this.data.usersByName;
        synchronized (map) {
            return this.data.usersByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User putUser(String name, String fullName) {
        User user = new User();
        user.setName(name);
        user.setFullName(fullName);
        Map<String, User> map = this.data.usersByName;
        synchronized (map) {
            this.data.usersByName.put(name, user);
        }
        return user;
    }

    private int supportsPerProjectIssueTypes(String version) {
        return new JiraVersion(version).compareTo(JiraVersion.JIRA_3_12);
    }
}

