/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.transport.http.HTTPConstants;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapServiceServiceLocator;

public class JiraSoapServiceLocator
extends JiraSoapServiceServiceLocator {
    private AbstractWebLocation location;
    private boolean compression;

    public JiraSoapServiceLocator() {
    }

    public JiraSoapServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public JiraSoapServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public Call createCall() throws ServiceException {
        Call call = super.createCall();
        if (this.compression) {
            call.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
        }
        call.setProperty("org.eclipse.mylyn.commons.soap.location", (Object)this.location);
        call.setProperty("org.eclipse.mylyn.commons.soap.userAgent", (Object)"JiraConnector Apache Axis/1.4");
        Hashtable<String, Boolean> headers = new Hashtable<String, Boolean>();
        headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, Boolean.FALSE);
        call.setProperty("HTTP-Request-Headers", headers);
        return call;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public void setLocation(AbstractWebLocation location) {
        this.location = location;
    }
}

