/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.JiraImages;
import org.eclipse.mylyn.internal.jira.ui.JiraSearchHandler;
import org.eclipse.mylyn.internal.jira.ui.Messages;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraFilterDefinitionPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraNamedFilterPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraRepositorySettingsPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.NewJiraTaskWizard;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraConnectorUi
extends AbstractRepositoryConnectorUi {
    private static Pattern TASK_PATTERN = Pattern.compile("([A-Z]+)-\\d+");

    public JiraConnectorUi() {
        TasksUiPlugin.getDefault().addSearchHandler((AbstractSearchHandler)new JiraSearchHandler());
    }

    public String getTaskKindLabel(ITask repositoryTask) {
        return Messages.JiraConnectorUi_Issue;
    }

    public List<LegendElement> getLegendElements() {
        ArrayList<LegendElement> legendItems = new ArrayList<LegendElement>();
        legendItems.add(LegendElement.createTask((String)Messages.JiraConnectorUi_Bug, (ImageDescriptor)JiraImages.OVERLAY_BUG));
        legendItems.add(LegendElement.createTask((String)Messages.JiraConnectorUi_Feature, (ImageDescriptor)JiraImages.OVERLAY_FEATURE));
        legendItems.add(LegendElement.createTask((String)Messages.JiraConnectorUi_Improvement, (ImageDescriptor)JiraImages.OVERLAY_IMPROVEMENT));
        legendItems.add(LegendElement.createTask((String)Messages.JiraConnectorUi_Task, (ImageDescriptor)JiraImages.OVERLAY_TASK));
        legendItems.add(LegendElement.createTask((String)Messages.JiraConnectorUi_Subtask, (ImageDescriptor)JiraImages.OVERLAY_SUB_TASK));
        return legendItems;
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        if ("jira".equals(task.getConnectorKind())) {
            if (JiraTaskKind.BUG.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_BUG;
            }
            if (JiraTaskKind.FEATURE.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_FEATURE;
            }
            if (JiraTaskKind.IMPROVEMENT.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_IMPROVEMENT;
            }
            if (JiraTaskKind.TASK.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_TASK;
            }
            if (JiraTaskKind.SUB_TASK.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_SUB_TASK;
            }
        }
        return null;
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new JiraFilterDefinitionPage(repository);
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new JiraRepositorySettingsPage(taskRepository);
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        if (query != null) {
            if (JiraUtil.isFilterDefinition((IRepositoryQuery)query)) {
                wizard.addPage((IWizardPage)new JiraFilterDefinitionPage(repository, query));
            } else {
                wizard.addPage((IWizardPage)new JiraNamedFilterPage(repository, query));
            }
        } else {
            wizard.addPage((IWizardPage)new JiraNamedFilterPage(repository));
        }
        return wizard;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        return new NewJiraTaskWizard(taskRepository, taskSelection);
    }

    public String getConnectorKind() {
        return "jira";
    }

    public boolean hasSearchPage() {
        return true;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
        if (client.getCache().hasDetails()) {
            ArrayList<TaskHyperlink> links = null;
            Matcher m = TASK_PATTERN.matcher(text);
            while (m.find()) {
                String projectKey = m.group(1);
                if (client.getCache().getProjectByKey(projectKey) == null) continue;
                if (links == null) {
                    links = new ArrayList<TaskHyperlink>();
                }
                Region region = new Region(textOffset + m.start(), m.end() - m.start());
                links.add(new TaskHyperlink((IRegion)region, repository, m.group()));
            }
            return links == null ? null : links.toArray(new IHyperlink[0]);
        }
        return null;
    }

    public String getTaskHistoryUrl(TaskRepository taskRepository, ITask task) {
        return String.valueOf(taskRepository.getRepositoryUrl()) + "/browse/" + task.getTaskKey() + "?page=history";
    }

    public static String getTaskWorkLogUrl(TaskRepository taskRepository, ITask task) {
        return String.valueOf(taskRepository.getRepositoryUrl()) + "/browse/" + task.getTaskKey() + "?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel";
    }

    public String getReplyText(TaskRepository taskRepository, ITask task, ITaskComment taskComment, boolean includeTask) {
        if (taskComment == null) {
            return String.valueOf(MessageFormat.format(Messages.JiraConnectorUi_In_reply_to_X, task.getTaskKey())) + ":";
        }
        if (includeTask) {
            return String.valueOf(MessageFormat.format(Messages.JiraConnectorUi_In_reply_to_X_comment_X, task.getTaskKey(), taskComment.getNumber())) + ":";
        }
        return String.valueOf(MessageFormat.format(Messages.JiraConnectorUi_In_reply_to_comment_X, taskComment.getNumber())) + ":";
    }

    public IWizardPage getTaskAttachmentPage(TaskAttachmentModel model) {
        TaskAttachmentPage page = new TaskAttachmentPage(model);
        page.setNeedsDescription(false);
        return page;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JiraTaskKind {
        BUG,
        FEATURE,
        TASK,
        IMPROVEMENT,
        CUSTOM_ISSUE,
        SUB_TASK;


        public String toString() {
            switch (this) {
                case BUG: {
                    return "Bug";
                }
                case FEATURE: {
                    return "New Feature";
                }
                case TASK: {
                    return "Task";
                }
                case IMPROVEMENT: {
                    return "Improvement";
                }
                case CUSTOM_ISSUE: {
                    return "Custom Issue";
                }
                case SUB_TASK: {
                    return "Sub-task";
                }
            }
            return "";
        }
    }
}

