/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.util.StringTokenizer;
import org.eclipse.mylyn.internal.jira.core.model.JiraFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ContentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class JiraSearchHandler
extends AbstractSearchHandler {
    private static final int MAX_LENGTH = 950;

    public String getConnectorKind() {
        return "jira";
    }

    public boolean queryForText(TaskRepository taskRepository, IRepositoryQuery query, TaskData taskData, String searchString) {
        StringBuilder sb = new StringBuilder(950);
        if (searchString.length() > 950) {
            StringTokenizer t = new StringTokenizer(searchString, " \n\t()");
            while (t.hasMoreTokens() && sb.length() < 930) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                int remaining = 950 - sb.length();
                String token = t.nextToken();
                if (token.length() > remaining) {
                    sb.append(token.substring(0, remaining));
                    sb.append("*");
                    continue;
                }
                sb.append(token);
            }
        } else {
            sb.append("\"");
            sb.append(searchString);
            sb.append("\"");
        }
        FilterDefinition filter = new FilterDefinition();
        filter.setContentFilter(new ContentFilter(sb.toString(), false, true, false, true));
        JiraUtil.setQuery((TaskRepository)taskRepository, (IRepositoryQuery)query, (JiraFilter)filter);
        return true;
    }
}

