/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.jira.core.WorkLogConverter;
import org.eclipse.mylyn.internal.jira.core.model.JiraWorkLog;
import org.eclipse.mylyn.internal.jira.ui.JiraConnectorUi;
import org.eclipse.mylyn.internal.jira.ui.editor.Messages;
import org.eclipse.mylyn.internal.jira.ui.editor.WorkLogTableLabelProvider;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkLogPart
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.jira.ui.editor.menu.worklog";
    private final String[] columns = new String[]{Messages.WorkLogPart_Creator, Messages.WorkLogPart_Date, Messages.WorkLogPart_Worked, Messages.WorkLogPart_Description};
    private final int[] columnWidths = new int[]{130, 70, 100, 150};
    private List<TaskAttribute> logEntries;
    private boolean hasIncoming;
    private MenuManager menuManager;
    private Composite composite;

    public WorkLogPart() {
        this.setPartName(Messages.WorkLogPart_Work_Log);
    }

    private void createTable(FormToolkit toolkit, Composite composite) {
        Table table = toolkit.createTable(composite, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)table);
        int i = 0;
        while (i < this.columns.length) {
            TableColumn column = new TableColumn(table, 16384, i);
            column.setText(this.columns[i]);
            column.setWidth(this.columnWidths[i]);
            ++i;
        }
        table.getColumn(2).setAlignment(131072);
        TableViewer attachmentsViewer = new TableViewer(table);
        attachmentsViewer.setUseHashlookup(true);
        attachmentsViewer.setColumnProperties(this.columns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)attachmentsViewer, (int)2);
        attachmentsViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                JiraWorkLog item1 = (JiraWorkLog)e1;
                JiraWorkLog item2 = (JiraWorkLog)e2;
                Date created1 = item1.getCreated();
                Date created2 = item2.getCreated();
                if (created1 != null && created2 != null) {
                    return created1.compareTo(created2);
                }
                if (created1 == null && created2 != null) {
                    return -1;
                }
                if (created1 != null && created2 == null) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<JiraWorkLog> workLogList = new ArrayList<JiraWorkLog>(this.logEntries.size());
        for (TaskAttribute attribute : this.logEntries) {
            JiraWorkLog log = (JiraWorkLog)new WorkLogConverter().createFrom(attribute);
            workLogList.add(log);
        }
        attachmentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        attachmentsViewer.setLabelProvider((IBaseLabelProvider)new WorkLogTableLabelProvider());
        attachmentsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TasksUiUtil.openUrl((String)JiraConnectorUi.getTaskWorkLogUrl(WorkLogPart.this.getModel().getTaskRepository(), WorkLogPart.this.getModel().getTask()));
            }
        });
        attachmentsViewer.addSelectionChangedListener((ISelectionChangedListener)this.getTaskEditorPage());
        attachmentsViewer.setInput(workLogList);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)attachmentsViewer, false);
        Menu menu = this.menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        final Section section = this.createSection(parent, toolkit, this.hasIncoming);
        section.setText(String.valueOf(this.getPartName()) + " (" + this.logEntries.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (WorkLogPart.this.composite == null) {
                        WorkLogPart.this.expandSection(toolkit, section);
                        WorkLogPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.composite = toolkit.createComposite((Composite)section);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setLayoutData((Object)new GridData(1808));
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.logEntries.size() > 0) {
            this.createTable(toolkit, this.composite);
        } else {
            Label label = toolkit.createLabel(this.composite, Messages.WorkLogPart_No_work_logged);
            this.getTaskEditorPage().registerDefaultDropListener((Control)label);
        }
        section.setClient((Control)this.composite);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.dispose();
    }

    private void initialize() {
        this.logEntries = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "jira.worklog");
        for (TaskAttribute attachmentAttribute : this.logEntries) {
            if (!this.getModel().hasIncomingChanges(attachmentAttribute)) continue;
            this.hasIncoming = true;
            break;
        }
    }
}

