/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.client.TracClientData;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ITracClient {
    public static final String CHARSET = "UTF-8";
    public static final String TIME_ZONE = "UTC";
    public static final String LOGIN_URL = "/login";
    public static final String QUERY_URL = "/query?format=tab";
    public static final String TICKET_URL = "/ticket/";
    public static final String NEW_TICKET_URL = "/newticket";
    public static final String CUSTOM_QUERY_URL = "/query";
    public static final String TICKET_ATTACHMENT_URL = "/attachment/ticket/";
    public static final String DEFAULT_USERNAME = "anonymous";
    public static final String WIKI_URL = "/wiki/";
    public static final String REPORT_URL = "/report/";
    public static final String CHANGESET_URL = "/changeset/";
    public static final String REVISION_LOG_URL = "/log/";
    public static final String MILESTONE_URL = "/milestone/";
    public static final String BROWSER_URL = "/browser/";
    public static final String ATTACHMENT_URL = "/attachment/ticket/";

    public TracTicket getTicket(int var1, IProgressMonitor var2) throws TracException;

    public Version getVersion();

    public void search(TracSearch var1, List<TracTicket> var2, IProgressMonitor var3) throws TracException;

    public void validate(IProgressMonitor var1) throws TracException;

    public boolean hasAttributes();

    public void updateAttributes(IProgressMonitor var1, boolean var2) throws TracException;

    public TracComponent[] getComponents();

    public TracTicketField[] getTicketFields();

    public TracMilestone[] getMilestones();

    public TracPriority[] getPriorities();

    public TracSeverity[] getSeverities();

    public TracTicketResolution[] getTicketResolutions();

    public TracTicketStatus[] getTicketStatus();

    public TracTicketType[] getTicketTypes();

    public TracVersion[] getVersions();

    public InputStream getAttachmentData(int var1, String var2, IProgressMonitor var3) throws TracException;

    public void putAttachmentData(int var1, String var2, String var3, InputStream var4, IProgressMonitor var5) throws TracException;

    public void deleteAttachment(int var1, String var2, IProgressMonitor var3) throws TracException;

    public int createTicket(TracTicket var1, IProgressMonitor var2) throws TracException;

    public void updateTicket(TracTicket var1, String var2, IProgressMonitor var3) throws TracException;

    public void setData(TracClientData var1);

    public Set<Integer> getChangedTickets(Date var1, IProgressMonitor var2) throws TracException;

    public Date getTicketLastChanged(Integer var1, IProgressMonitor var2) throws TracException;

    public void deleteTicket(int var1, IProgressMonitor var2) throws TracException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Version {
        XML_RPC,
        TRAC_0_9;


        public static Version fromVersion(String version) {
            try {
                return Version.valueOf(version);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public String toString() {
            switch (this) {
                case TRAC_0_9: {
                    return "Web (Trac 0.9 or 0.10)";
                }
                case XML_RPC: {
                    return "XML-RPC Plugin (Rev. 1950)";
                }
            }
            return null;
        }
    }
}

