/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.trac.core.client.AbstractTracClient;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.ITracWikiClient;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.client.InvalidWikiPageException;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracNoSuchMethodException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.client.TracProxyAuthenticationException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.model.TracAttachment;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPageInfo;
import org.eclipse.mylyn.internal.trac.core.util.HttpMethodInterceptor;
import org.eclipse.mylyn.internal.trac.core.util.TracHttpClientTransportFactory;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.internal.trac.core.util.TracXmlRpcClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracXmlRpcClient
extends AbstractTracClient
implements ITracWikiClient {
    public static final String XMLRPC_URL = "/xmlrpc";
    public static final String REQUIRED_REVISION = "1950";
    public static final int REQUIRED_EPOCH = 0;
    public static final int REQUIRED_MAJOR = 0;
    public static final int REQUIRED_MINOR = 1;
    private static final int NO_SUCH_METHOD_ERROR = 1;
    private static final int LATEST_VERSION = -1;
    public static final int REQUIRED_WIKI_RPC_VERSION = 2;
    private XmlRpcClient xmlrpc;
    private TracHttpClientTransportFactory factory;
    private int majorAPIVersion = -1;
    private int minorAPIVersion = -1;
    private int epochAPIVersion = -1;
    private boolean accountMangerAuthenticationFailed;
    private XmlRpcClientConfigImpl config;
    private final HttpClient httpClient = this.createHttpClient();
    private boolean probed;
    private volatile DigestScheme digestScheme;
    private final AuthScope authScope = new AuthScope(WebUtil.getHost((String)this.repositoryUrl), WebUtil.getPort((String)this.repositoryUrl), null, AuthScope.ANY_SCHEME);
    private boolean isTracd;

    public TracXmlRpcClient(AbstractWebLocation location, ITracClient.Version version) {
        super(location, version);
    }

    public synchronized XmlRpcClient getClient() throws TracException {
        if (this.xmlrpc == null) {
            this.config = new XmlRpcClientConfigImpl();
            this.config.setEncoding("UTF-8");
            this.config.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.config.setContentLengthOptional(false);
            this.config.setConnectionTimeout(WebUtil.getConnectionTimeout());
            this.config.setReplyTimeout(WebUtil.getSocketTimeout());
            this.xmlrpc = new XmlRpcClient();
            this.xmlrpc.setConfig((XmlRpcClientConfig)this.config);
            this.factory = new TracHttpClientTransportFactory(this.xmlrpc, this.httpClient);
            this.factory.setLocation(this.location);
            this.factory.setInterceptor(new HttpMethodInterceptor(){

                public void processRequest(HttpMethod method) {
                    Credentials creds;
                    DigestScheme scheme = TracXmlRpcClient.this.digestScheme;
                    if (scheme != null && (creds = TracXmlRpcClient.this.httpClient.getState().getCredentials(TracXmlRpcClient.this.authScope)) != null) {
                        method.getHostAuthState().setAuthScheme((AuthScheme)TracXmlRpcClient.this.digestScheme);
                        method.getHostAuthState().setAuthRequested(true);
                    }
                }

                public void processResponse(HttpMethod method) {
                    AuthScheme authScheme = method.getHostAuthState().getAuthScheme();
                    if (authScheme instanceof DigestScheme) {
                        TracXmlRpcClient.this.digestScheme = (DigestScheme)authScheme;
                    }
                }
            });
            this.xmlrpc.setTransportFactory((XmlRpcTransportFactory)this.factory);
        }
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        this.config.setServerURL(this.getXmlRpcUrl(credentials));
        if (this.credentialsValid(credentials)) {
            Credentials creds = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)this.location.getUrl()));
            this.httpClient.getState().setCredentials(this.authScope, creds);
        } else {
            this.httpClient.getState().clearCredentials();
        }
        return this.xmlrpc;
    }

    private URL getXmlRpcUrl(AuthenticationCredentials credentials) throws TracException {
        try {
            String location = this.repositoryUrl.toString();
            if (this.credentialsValid(credentials)) {
                location = String.valueOf(location) + "/login";
            }
            location = String.valueOf(location) + XMLRPC_URL;
            return new URL(location);
        }
        catch (Exception e) {
            throw new TracException(e);
        }
    }

    private void probeAuthenticationScheme(IProgressMonitor monitor) throws TracException {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        if (!this.credentialsValid(credentials)) {
            return;
        }
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        HeadMethod method = new HeadMethod(this.getXmlRpcUrl(credentials).toString());
        try {
            try {
                int result = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)method, (HttpState)new HttpState(), (IProgressMonitor)monitor);
                if (result == 401 || result == 403) {
                    AuthScheme authScheme = method.getHostAuthState().getAuthScheme();
                    if (authScheme instanceof DigestScheme) {
                        this.digestScheme = (DigestScheme)authScheme;
                    } else if (authScheme instanceof BasicScheme) {
                        this.httpClient.getParams().setAuthenticationPreemptive(true);
                    }
                    Header header = method.getResponseHeader("Server");
                    this.isTracd = header != null && header.getValue().startsWith("tracd");
                }
            }
            catch (IOException iOException) {
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private Object call(IProgressMonitor monitor, String method, Object ... parameters) throws TracException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        while (true) {
            if (!this.probed) {
                try {
                    this.probeAuthenticationScheme(monitor);
                }
                finally {
                    this.probed = true;
                }
            }
            this.getClient();
            try {
                XmlRpcRequest request = new XmlRpcRequest(method, parameters);
                return request.execute(monitor);
            }
            catch (TracLoginException e) {
                try {
                    this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {
                    throw e;
                }
            }
            catch (TracPermissionDeniedException e) {
                try {
                    this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {
                    throw e;
                }
            }
            catch (TracProxyAuthenticationException e) {
                try {
                    this.location.requestCredentials(AuthenticationType.PROXY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {
                    throw e;
                }
            }
        }
    }

    private Object[] multicall(IProgressMonitor monitor, Map<String, Object> ... calls) throws TracException {
        Object[] result;
        Object[] objectArray = result = (Object[])this.call(monitor, "system.multicall", new Object[]{calls});
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            try {
                this.checkForException(item);
            }
            catch (XmlRpcException e) {
                throw new TracRemoteException(e);
            }
            catch (Exception e) {
                throw new TracException(e);
            }
            ++n2;
        }
        return result;
    }

    private void checkForException(Object result) throws NumberFormatException, XmlRpcException {
        Map exceptionData;
        if (result instanceof Map && (exceptionData = (Map)result).containsKey("faultCode") && exceptionData.containsKey("faultString")) {
            throw new XmlRpcException(Integer.parseInt(exceptionData.get("faultCode").toString()), (String)exceptionData.get("faultString"));
        }
    }

    private Map<String, Object> createMultiCall(String methodName, Object ... parameters) throws TracException {
        HashMap<String, Object> table = new HashMap<String, Object>();
        table.put("methodName", methodName);
        table.put("params", parameters);
        return table;
    }

    private Object getMultiCallResult(Object item) {
        return ((Object[])item)[0];
    }

    @Override
    public void validate(IProgressMonitor monitor) throws TracException {
        block5: {
            try {
                Object[] result = (Object[])this.call(monitor, "system.getAPIVersion", new Object[0]);
                if (result.length >= 3) {
                    this.epochAPIVersion = (Integer)result[0];
                    this.majorAPIVersion = (Integer)result[1];
                    this.minorAPIVersion = (Integer)result[2];
                    break block5;
                }
                if (result.length >= 2) {
                    this.epochAPIVersion = 0;
                    this.majorAPIVersion = (Integer)result[0];
                    this.minorAPIVersion = (Integer)result[1];
                    break block5;
                }
                throw new TracException("The API version is unsupported, please update your Trac XML-RPC Plugin to revision 1950 or later");
            }
            catch (TracNoSuchMethodException tracNoSuchMethodException) {
                throw new TracException("Required API calls are missing, please update your Trac XML-RPC Plugin to revision 1950 or later");
            }
        }
        if (!this.isAPIVersionOrHigher(0, 0, 1, monitor)) {
            throw new TracException("The API version " + this.majorAPIVersion + "." + this.minorAPIVersion + " is unsupported, please update your Trac XML-RPC Plugin to revision " + REQUIRED_REVISION + " or later");
        }
    }

    private void updateAPIVersion(IProgressMonitor monitor) throws TracException {
        if (this.epochAPIVersion == -1 || this.majorAPIVersion == -1 || this.minorAPIVersion == -1) {
            this.validate(monitor);
        }
    }

    private boolean isAPIVersionOrHigher(int epoch, int major, int minor, IProgressMonitor monitor) throws TracException {
        this.updateAPIVersion(monitor);
        return this.epochAPIVersion > epoch || this.epochAPIVersion == epoch && this.majorAPIVersion > major || this.majorAPIVersion == major && this.minorAPIVersion >= minor;
    }

    @Override
    public TracTicket getTicket(int id, IProgressMonitor monitor) throws TracException {
        Object item;
        Object[] result = (Object[])this.call(monitor, "ticket.get", id);
        TracTicket ticket = this.parseTicket(result);
        Object[] objectArray = result = (Object[])this.call(monitor, "ticket.changeLog", id, 0);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            ticket.addComment(this.parseChangeLogEntry((Object[])item));
            ++n2;
        }
        objectArray = result = (Object[])this.call(monitor, "ticket.listAttachments", id);
        n = result.length;
        n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            ticket.addAttachment(this.parseAttachment((Object[])item));
            ++n2;
        }
        String[] actions = this.getActions(id, monitor);
        ticket.setActions(actions);
        this.updateAttributes((IProgressMonitor)new NullProgressMonitor(), false);
        TracTicketResolution[] resolutions = this.getTicketResolutions();
        if (resolutions != null) {
            String[] resolutionStrings = new String[resolutions.length];
            int i = 0;
            while (i < resolutions.length) {
                resolutionStrings[i] = resolutions[i].getName();
                ++i;
            }
            ticket.setResolutions(resolutionStrings);
        } else {
            ticket.setResolutions(this.getDefaultTicketResolutions());
        }
        return ticket;
    }

    private TracAttachment parseAttachment(Object[] entry) {
        TracAttachment attachment = new TracAttachment((String)entry[0]);
        attachment.setDescription((String)entry[1]);
        attachment.setSize((Integer)entry[2]);
        attachment.setCreated(this.parseDate(entry[3]));
        attachment.setAuthor((String)entry[4]);
        return attachment;
    }

    private TracComment parseChangeLogEntry(Object[] entry) {
        TracComment comment = new TracComment();
        comment.setCreated(this.parseDate(entry[0]));
        comment.setAuthor((String)entry[1]);
        comment.setField((String)entry[2]);
        comment.setOldValue((String)entry[3]);
        comment.setNewValue((String)entry[4]);
        return comment;
    }

    public List<TracTicket> getTickets(int[] ids, IProgressMonitor monitor) throws TracException {
        Map[] calls = new Map[ids.length];
        int i = 0;
        while (i < calls.length) {
            calls[i] = this.createMultiCall("ticket.get", ids[i]);
            ++i;
        }
        Object[] result = this.multicall(monitor, calls);
        assert (result.length == ids.length);
        ArrayList<TracTicket> tickets = new ArrayList<TracTicket>(result.length);
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Object[] ticketResult = (Object[])this.getMultiCallResult(item);
            tickets.add(this.parseTicket(ticketResult));
            ++n2;
        }
        return tickets;
    }

    @Override
    public void search(TracSearch query, List<TracTicket> tickets, IProgressMonitor monitor) throws TracException {
        Object[] result = (Object[])this.call(monitor, "ticket.query", "order=id" + query.toQuery());
        Map[] calls = new Map[result.length];
        int i = 0;
        while (i < calls.length) {
            calls[i] = this.createMultiCall("ticket.get", result[i]);
            ++i;
        }
        Object[] objectArray = result = this.multicall(monitor, calls);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Object[] ticketResult = (Object[])this.getMultiCallResult(item);
            tickets.add(this.parseTicket(ticketResult));
            ++n2;
        }
    }

    private TracTicket parseTicket(Object[] ticketResult) throws InvalidTicketException {
        TracTicket ticket = new TracTicket((Integer)ticketResult[0]);
        ticket.setCreated(this.parseDate(ticketResult[1]));
        ticket.setLastChanged(this.parseDate(ticketResult[2]));
        Map attributes = (Map)ticketResult[3];
        for (Object key : attributes.keySet()) {
            ticket.putValue(key.toString(), attributes.get(key).toString());
        }
        return ticket;
    }

    private Date parseDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Integer) {
            return TracUtil.parseDate(((Integer)object).intValue());
        }
        throw new ClassCastException("Unexpected object type for date: " + object.getClass());
    }

    @Override
    public synchronized void updateAttributes(IProgressMonitor monitor) throws TracException {
        Object item;
        Object item2;
        monitor.beginTask("Updating attributes", 9);
        Object[] result = this.getAttributes("ticket.component", monitor);
        this.data.components = new ArrayList<TracComponent>(result.length);
        Object object = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            item2 = object[n2];
            this.data.components.add(this.parseComponent((Map)this.getMultiCallResult(item2)));
            ++n2;
        }
        this.advance(monitor, 1);
        result = this.getAttributes("ticket.milestone", monitor);
        this.data.milestones = new ArrayList<TracMilestone>(result.length);
        object = result;
        n = result.length;
        n2 = 0;
        while (n2 < n) {
            item2 = object[n2];
            this.data.milestones.add(this.parseMilestone((Map)this.getMultiCallResult(item2)));
            ++n2;
        }
        this.advance(monitor, 1);
        List<TicketAttributeResult> attributes = this.getTicketAttributes("ticket.priority", monitor);
        this.data.priorities = new ArrayList<TracPriority>(result.length);
        for (TicketAttributeResult attribute : attributes) {
            this.data.priorities.add(new TracPriority(attribute.name, attribute.value));
        }
        Collections.sort(this.data.priorities);
        this.advance(monitor, 1);
        attributes = this.getTicketAttributes("ticket.resolution", monitor);
        this.data.ticketResolutions = new ArrayList<TracTicketResolution>(result.length);
        for (TicketAttributeResult attribute : attributes) {
            this.data.ticketResolutions.add(new TracTicketResolution(attribute.name, attribute.value));
        }
        Collections.sort(this.data.ticketResolutions);
        this.advance(monitor, 1);
        attributes = this.getTicketAttributes("ticket.severity", monitor);
        this.data.severities = new ArrayList<TracSeverity>(result.length);
        for (TicketAttributeResult attribute : attributes) {
            this.data.severities.add(new TracSeverity(attribute.name, attribute.value));
        }
        Collections.sort(this.data.severities);
        this.advance(monitor, 1);
        boolean trac011 = this.isAPIVersionOrHigher(1, 0, 0, monitor);
        attributes = this.getTicketAttributes("ticket.status", trac011, monitor);
        this.data.ticketStatus = new ArrayList<TracTicketStatus>(result.length);
        for (TicketAttributeResult attribute : attributes) {
            this.data.ticketStatus.add(new TracTicketStatus(attribute.name, attribute.value));
        }
        Collections.sort(this.data.ticketStatus);
        this.advance(monitor, 1);
        attributes = this.getTicketAttributes("ticket.type", monitor);
        this.data.ticketTypes = new ArrayList<TracTicketType>(result.length);
        for (TicketAttributeResult attribute : attributes) {
            this.data.ticketTypes.add(new TracTicketType(attribute.name, attribute.value));
        }
        Collections.sort(this.data.ticketTypes);
        this.advance(monitor, 1);
        result = this.getAttributes("ticket.version", monitor);
        this.data.versions = new ArrayList<TracVersion>(result.length);
        Object[] objectArray = result;
        int n3 = result.length;
        int n4 = 0;
        while (n4 < n3) {
            item = objectArray[n4];
            this.data.versions.add(this.parseVersion((Map)this.getMultiCallResult(item)));
            ++n4;
        }
        this.advance(monitor, 1);
        result = (Object[])this.call(monitor, "ticket.getTicketFields", new Object[0]);
        this.data.ticketFields = new ArrayList<TracTicketField>(result.length);
        objectArray = result;
        n3 = result.length;
        n4 = 0;
        while (n4 < n3) {
            item = objectArray[n4];
            this.data.ticketFields.add(this.parseTicketField((Map)item));
            ++n4;
        }
        this.advance(monitor, 1);
    }

    private void advance(IProgressMonitor monitor, int worked) {
        monitor.worked(worked);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private TracComponent parseComponent(Map<?, ?> result) {
        TracComponent component = new TracComponent((String)result.get("name"));
        component.setOwner((String)result.get("owner"));
        component.setDescription((String)result.get("description"));
        return component;
    }

    private TracMilestone parseMilestone(Map<?, ?> result) {
        TracMilestone milestone = new TracMilestone((String)result.get("name"));
        milestone.setCompleted(this.parseDate(result.get("completed")));
        milestone.setDue(this.parseDate(result.get("due")));
        milestone.setDescription((String)result.get("description"));
        return milestone;
    }

    private TracVersion parseVersion(Map<?, ?> result) {
        TracVersion version = new TracVersion((String)result.get("name"));
        version.setTime(this.parseDate(result.get("time")));
        version.setDescription((String)result.get("description"));
        return version;
    }

    private TracTicketField parseTicketField(Map<?, ?> result) {
        TracTicketField field = new TracTicketField((String)result.get("name"));
        field.setType(TracTicketField.Type.fromString((String)result.get("type")));
        field.setLabel((String)result.get("label"));
        field.setDefaultValue((String)result.get("value"));
        Object[] items = (Object[])result.get("options");
        if (items != null) {
            String[] options = new String[items.length];
            int i = 0;
            while (i < items.length) {
                options[i] = (String)items[i];
                ++i;
            }
            field.setOptions(options);
        }
        if (result.get("custom") != null) {
            field.setCustom((Boolean)result.get("custom"));
        }
        if (result.get("order") != null) {
            field.setOrder((Integer)result.get("order"));
        }
        if (result.get("optional") != null) {
            field.setOptional((Boolean)result.get("optional"));
        }
        if (result.get("width") != null) {
            field.setWidth((Integer)result.get("width"));
        }
        if (result.get("height") != null) {
            field.setHeight((Integer)result.get("height"));
        }
        return field;
    }

    private Object[] getAttributes(String attributeType, IProgressMonitor monitor) throws TracException {
        Object[] ids = (Object[])this.call(monitor, String.valueOf(attributeType) + ".getAll", new Object[0]);
        Map[] calls = new Map[ids.length];
        int i = 0;
        while (i < calls.length) {
            calls[i] = this.createMultiCall(String.valueOf(attributeType) + ".get", ids[i]);
            ++i;
        }
        Object[] result = this.multicall(monitor, calls);
        assert (result.length == ids.length);
        return result;
    }

    private List<TicketAttributeResult> getTicketAttributes(String attributeType, IProgressMonitor monitor) throws TracException {
        return this.getTicketAttributes(attributeType, false, monitor);
    }

    private List<TicketAttributeResult> getTicketAttributes(String attributeType, boolean assignValues, IProgressMonitor monitor) throws TracException {
        Object[] ids = (Object[])this.call(monitor, String.valueOf(attributeType) + ".getAll", new Object[0]);
        Map[] calls = new Map[ids.length];
        int i = 0;
        while (i < calls.length) {
            calls[i] = this.createMultiCall(String.valueOf(attributeType) + ".get", ids[i]);
            ++i;
        }
        Object[] result = this.multicall(monitor, calls);
        assert (result.length == ids.length);
        ArrayList<TicketAttributeResult> attributes = new ArrayList<TicketAttributeResult>(result.length);
        int i2 = 0;
        while (i2 < calls.length) {
            try {
                TicketAttributeResult attribute = new TicketAttributeResult();
                attribute.name = (String)ids[i2];
                Object value = this.getMultiCallResult(result[i2]);
                attribute.value = assignValues ? i2 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
                attributes.add(attribute);
            }
            catch (ClassCastException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "Invalid response from Trac repository for attribute type: '" + attributeType + "'", (Throwable)e));
            }
            catch (NumberFormatException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "Invalid response from Trac repository for attribute type: '" + attributeType + "'", (Throwable)e));
            }
            ++i2;
        }
        return attributes;
    }

    @Override
    public InputStream getAttachmentData(int ticketId, String filename, IProgressMonitor monitor) throws TracException {
        byte[] data = (byte[])this.call(monitor, "ticket.getAttachment", ticketId, filename);
        return new ByteArrayInputStream(data);
    }

    @Override
    public void putAttachmentData(int ticketId, String filename, String description, InputStream in, IProgressMonitor monitor) throws TracException {
        byte[] data;
        try {
            data = this.readData(in, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            throw new TracException(e);
        }
        this.call(monitor, "ticket.putAttachment", ticketId, filename, description, data, false);
    }

    private byte[] readData(InputStream in, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[512];
            do {
                int count;
                if ((count = in.read(buffer)) == -1) {
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                out.write(buffer, 0, count);
            } while (!monitor.isCanceled());
            throw new OperationCanceledException();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.trac.core", "Error closing attachment stream", (Throwable)e));
            }
        }
    }

    @Override
    public void deleteAttachment(int ticketId, String filename, IProgressMonitor monitor) throws TracException {
        this.call(monitor, "ticket.deleteAttachment", ticketId, filename);
    }

    @Override
    public int createTicket(TracTicket ticket, IProgressMonitor monitor) throws TracException {
        Map<String, String> attributes = ticket.getValues();
        String summary = attributes.remove(TracTicket.Key.SUMMARY.getKey());
        String description = attributes.remove(TracTicket.Key.DESCRIPTION.getKey());
        if (summary == null || description == null) {
            throw new InvalidTicketException();
        }
        if (this.isAPIVersionOrHigher(0, 0, 2, monitor)) {
            return (Integer)this.call(monitor, "ticket.create", summary, description, attributes, true);
        }
        return (Integer)this.call(monitor, "ticket.create", summary, description, attributes);
    }

    @Override
    public void updateTicket(TracTicket ticket, String comment, IProgressMonitor monitor) throws TracException {
        this.updateAPIVersion(monitor);
        Map<String, String> attributes = ticket.getValues();
        if (this.isAPIVersionOrHigher(0, 0, 2, monitor)) {
            this.call(monitor, "ticket.update", ticket.getId(), comment, attributes, true);
        } else {
            this.call(monitor, "ticket.update", ticket.getId(), comment, attributes);
        }
    }

    @Override
    public Set<Integer> getChangedTickets(Date since, IProgressMonitor monitor) throws TracException {
        Object[] ids = (Object[])this.call(monitor, "ticket.getRecentChanges", since);
        HashSet<Integer> result = new HashSet<Integer>();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            result.add((Integer)id);
            ++n2;
        }
        return result;
    }

    public String[] getActions(int id, IProgressMonitor monitor) throws TracException {
        Object[] actions = (Object[])this.call(monitor, "ticket.getAvailableActions", id);
        String[] result = new String[actions.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)actions[i];
            ++i;
        }
        return result;
    }

    @Override
    public Date getTicketLastChanged(Integer id, IProgressMonitor monitor) throws TracException {
        Object[] result = (Object[])this.call(monitor, "ticket.get", id);
        return this.parseDate(result[2]);
    }

    @Override
    public void validateWikiRpcApi(IProgressMonitor monitor) throws TracException {
        if ((Integer)this.call(monitor, "wiki.getRPCVersionSupported", new Object[0]) < 2) {
            this.validate(monitor);
        }
    }

    @Override
    public String wikiToHtml(String sourceText, IProgressMonitor monitor) throws TracException {
        return (String)this.call(monitor, "wiki.wikiToHtml", sourceText);
    }

    @Override
    public String[] getAllWikiPageNames(IProgressMonitor monitor) throws TracException {
        Object[] result = (Object[])this.call(monitor, "wiki.getAllPages", new Object[0]);
        String[] wikiPageNames = new String[result.length];
        int i = 0;
        while (i < wikiPageNames.length) {
            wikiPageNames[i] = (String)result[i];
            ++i;
        }
        return wikiPageNames;
    }

    @Override
    public TracWikiPageInfo getWikiPageInfo(String pageName, IProgressMonitor monitor) throws TracException {
        return this.getWikiPageInfo(pageName, -1, null);
    }

    @Override
    public TracWikiPageInfo getWikiPageInfo(String pageName, int version, IProgressMonitor monitor) throws TracException {
        if (pageName == null) {
            throw new IllegalArgumentException("Wiki page name cannot be null");
        }
        Object result = version == -1 ? this.call(monitor, "wiki.getPageInfo", pageName) : this.call(monitor, "wiki.getPageInfoVersion", pageName, version);
        return this.parseWikiPageInfo(result);
    }

    @Override
    public TracWikiPageInfo[] getWikiPageInfoAllVersions(String pageName, IProgressMonitor monitor) throws TracException {
        TracWikiPageInfo latestVersion = this.getWikiPageInfo(pageName, null);
        Map[] calls = new Map[latestVersion.getVersion() - 1];
        int i = 0;
        while (i < calls.length) {
            calls[i] = this.createMultiCall("wiki.getPageInfoVersion", pageName, i + 1);
            ++i;
        }
        Object[] result = this.multicall(monitor, calls);
        TracWikiPageInfo[] versions = new TracWikiPageInfo[result.length + 1];
        int i2 = 0;
        while (i2 < result.length) {
            Object pageInfoResult = this.getMultiCallResult(result[i2]);
            versions[i2] = this.parseWikiPageInfo(pageInfoResult);
            ++i2;
        }
        versions[result.length] = latestVersion;
        return versions;
    }

    private TracWikiPageInfo parseWikiPageInfo(Object pageInfoResult) throws InvalidWikiPageException {
        if (pageInfoResult instanceof Map) {
            TracWikiPageInfo pageInfo = new TracWikiPageInfo();
            Map infoMap = (Map)pageInfoResult;
            pageInfo.setPageName((String)infoMap.get("name"));
            pageInfo.setAuthor((String)infoMap.get("author"));
            pageInfo.setLastModified(this.parseDate(infoMap.get("lastModified")));
            pageInfo.setVersion((Integer)infoMap.get("version"));
            return pageInfo;
        }
        throw new InvalidWikiPageException("Wiki page name or version does not exist");
    }

    @Override
    public String getWikiPageContent(String pageName, IProgressMonitor monitor) throws TracException {
        return this.getWikiPageContent(pageName, -1, null);
    }

    @Override
    public String getWikiPageContent(String pageName, int version, IProgressMonitor monitor) throws TracException {
        if (pageName == null) {
            throw new IllegalArgumentException("Wiki page name cannot be null");
        }
        if (version == -1) {
            return (String)this.call(monitor, "wiki.getPage", pageName);
        }
        return (String)this.call(monitor, "wiki.getPageVersion", pageName, version);
    }

    @Override
    public String getWikiPageHtml(String pageName, IProgressMonitor monitor) throws TracException {
        return this.getWikiPageHtml(pageName, -1, null);
    }

    @Override
    public String getWikiPageHtml(String pageName, int version, IProgressMonitor monitor) throws TracException {
        if (pageName == null) {
            throw new IllegalArgumentException("Wiki page name cannot be null");
        }
        if (version == -1) {
            return (String)this.call(monitor, "wiki.getPageHTML", pageName);
        }
        return (String)this.call(monitor, "wiki.getPageHTMLVersion", pageName, version);
    }

    @Override
    public TracWikiPageInfo[] getRecentWikiChanges(Date since, IProgressMonitor monitor) throws TracException {
        if (since == null) {
            throw new IllegalArgumentException("Date parameter cannot be null");
        }
        Object[] result = (Object[])this.call(monitor, "wiki.getRecentChanges", since);
        TracWikiPageInfo[] changes = new TracWikiPageInfo[result.length];
        int i = 0;
        while (i < result.length) {
            changes[i] = this.parseWikiPageInfo(result[i]);
            ++i;
        }
        return changes;
    }

    @Override
    public TracWikiPage getWikiPage(String pageName, IProgressMonitor monitor) throws TracException {
        return this.getWikiPage(pageName, -1, null);
    }

    @Override
    public TracWikiPage getWikiPage(String pageName, int version, IProgressMonitor monitor) throws TracException {
        TracWikiPage page = new TracWikiPage();
        page.setPageInfo(this.getWikiPageInfo(pageName, version, null));
        page.setContent(this.getWikiPageContent(pageName, version, null));
        page.setPageHTML(this.getWikiPageHtml(pageName, version, null));
        return page;
    }

    @Override
    public boolean putWikipage(String pageName, String content, Map<String, Object> attributes, IProgressMonitor monitor) throws TracException {
        Boolean result = (Boolean)this.call(monitor, "wiki.putPage", pageName, content, attributes);
        return result;
    }

    @Override
    public String[] listWikiPageAttachments(String pageName, IProgressMonitor monitor) throws TracException {
        Object[] result = (Object[])this.call(monitor, "wiki.listAttachments", pageName);
        String[] attachments = new String[result.length];
        int i = 0;
        while (i < attachments.length) {
            attachments[i] = (String)result[i];
            ++i;
        }
        return attachments;
    }

    @Override
    public InputStream getWikiPageAttachmentData(String pageName, String fileName, IProgressMonitor monitor) throws TracException {
        String attachmentName = String.valueOf(pageName) + "/" + fileName;
        byte[] data = (byte[])this.call(monitor, "wiki.getAttachment", attachmentName);
        return new ByteArrayInputStream(data);
    }

    @Override
    public String putWikiPageAttachmentData(String pageName, String fileName, String description, InputStream in, boolean replace, IProgressMonitor monitor) throws TracException {
        byte[] data;
        try {
            data = this.readData(in, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            throw new TracException(e);
        }
        return (String)this.call(monitor, "wiki.putAttachmentEx", pageName, fileName, description, data, replace);
    }

    @Override
    public void deleteTicket(int ticketId, IProgressMonitor monitor) throws TracException {
        this.call(monitor, "ticket.delete", ticketId);
    }

    private class TicketAttributeResult {
        String name;
        int value;

        private TicketAttributeResult() {
        }
    }

    private class XmlRpcRequest {
        private final String method;
        private final Object[] parameters;

        public XmlRpcRequest(String method, Object[] parameters) {
            this.method = method;
            this.parameters = parameters;
        }

        public Object execute(IProgressMonitor monitor) throws TracException {
            try {
                return this.executeCallInternal(monitor);
            }
            catch (TracPermissionDeniedException e) {
                if (TracXmlRpcClient.this.accountMangerAuthenticationFailed) {
                    throw e;
                }
                AuthenticationCredentials credentials = TracXmlRpcClient.this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (!TracXmlRpcClient.this.credentialsValid(credentials)) {
                    throw e;
                }
                HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)TracXmlRpcClient.this.httpClient, (AbstractWebLocation)TracXmlRpcClient.this.location, (IProgressMonitor)monitor);
                try {
                    TracXmlRpcClient.this.authenticateAccountManager(TracXmlRpcClient.this.httpClient, hostConfiguration, credentials, monitor);
                }
                catch (TracLoginException loginException) {
                    throw loginException;
                }
                catch (IOException iOException) {
                    TracXmlRpcClient.this.accountMangerAuthenticationFailed = true;
                    throw e;
                }
                try {
                    TracXmlRpcClient.this.validateAuthenticationState(TracXmlRpcClient.this.httpClient);
                }
                catch (TracLoginException tracLoginException) {
                    TracXmlRpcClient.this.accountMangerAuthenticationFailed = true;
                    throw e;
                }
                return this.executeCallInternal(monitor);
            }
        }

        private Object executeCallInternal(IProgressMonitor monitor) throws TracException {
            try {
                if (TracXmlRpcClient.this.isTracd && TracXmlRpcClient.this.digestScheme != null) {
                    TracXmlRpcClient.this.probeAuthenticationScheme(monitor);
                }
                TracXmlRpcClientRequest request = new TracXmlRpcClientRequest((XmlRpcRequestConfig)TracXmlRpcClient.this.xmlrpc.getClientConfig(), this.method, this.parameters, monitor);
                return TracXmlRpcClient.this.xmlrpc.execute((org.apache.xmlrpc.XmlRpcRequest)request);
            }
            catch (TracHttpClientTransportFactory.TracHttpException e) {
                if (e.code == 401) {
                    TracXmlRpcClient.this.digestScheme = null;
                    throw new TracLoginException();
                }
                if (e.code == 403) {
                    TracXmlRpcClient.this.digestScheme = null;
                    throw new TracPermissionDeniedException();
                }
                if (e.code == 407) {
                    throw new TracProxyAuthenticationException();
                }
                throw new TracException((Throwable)((Object)e));
            }
            catch (XmlRpcException e) {
                if (e.code == 1) {
                    throw new TracNoSuchMethodException(e);
                }
                throw new TracRemoteException(e);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TracException(e);
            }
        }
    }
}

