/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.internal.trac.ui.TracUiPlugin;
import org.eclipse.mylyn.internal.trac.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TracQueryPage
extends AbstractRepositoryQueryPage {
    private Text titleText;
    private static final int PRODUCT_HEIGHT = 60;
    private static final int STATUS_HEIGHT = 40;
    protected static final String PAGE_NAME = "TracSearchPage";
    private static final String SEARCH_URL_ID = "TracSearchPage.SEARCHURL";
    protected Combo summaryText = null;
    protected Combo repositoryCombo = null;
    private TextSearchField summaryField;
    private TextSearchField descriptionField;
    private ListSearchField componentField;
    private ListSearchField versionField;
    private ListSearchField milestoneField;
    private ListSearchField priorityField;
    private ListSearchField typeField;
    private ListSearchField resolutionField;
    private ListSearchField statusField;
    private Button updateButton;
    private TextSearchField keywordsField;
    private final Map<String, SearchField> searchFieldByName = new HashMap<String, SearchField>();
    private boolean firstTime = true;

    public TracQueryPage(TaskRepository repository, IRepositoryQuery query) {
        super(Messages.TracQueryPage_Enter_query_parameters, repository, query);
        this.setTitle(Messages.TracQueryPage_Enter_query_parameters);
        this.setDescription(Messages.TracQueryPage_If_attributes_are_blank_or_stale_press_the_Update_button);
    }

    public TracQueryPage(TaskRepository repository) {
        this(repository, null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(4, false);
        if (this.inSearchContainer()) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        control.setLayout((Layout)layout);
        this.createTitleGroup(control);
        this.summaryField = new TextSearchField("summary");
        this.summaryField.createControls(control, Messages.TracQueryPage_Summary);
        this.descriptionField = new TextSearchField("description");
        this.descriptionField.createControls(control, Messages.TracQueryPage_Description);
        this.keywordsField = new TextSearchField("keywords");
        this.keywordsField.createControls(control, Messages.TracQueryPage_Keywords);
        this.createOptionsGroup(control);
        this.createUserGroup(control);
        if (this.getQuery() != null) {
            this.titleText.setText(this.getQuery().getSummary());
            TracSearch search = TracUtil.toTracSearch((IRepositoryQuery)this.getQuery());
            if (search != null) {
                this.restoreWidgetValues(search);
            }
        }
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private void restoreWidgetValues(TracSearch search) {
        List filters = search.getFilters();
        for (TracSearchFilter filter : filters) {
            SearchField field = this.searchFieldByName.get(filter.getFieldName());
            if (field != null) {
                field.setFilter(filter);
                continue;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.ui", "Ignoring invalid search filter: " + filter));
        }
    }

    private void createTitleGroup(Composite control) {
        if (this.inSearchContainer()) {
            return;
        }
        Label titleLabel = new Label(control, 0);
        titleLabel.setText(Messages.TracQueryPage_Query_Title);
        this.titleText = new Text(control, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.titleText.setLayoutData((Object)gd);
        this.titleText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TracQueryPage.this.getContainer().updateButtons();
            }
        });
    }

    protected Control createOptionsGroup(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 4;
        group.setLayoutData((Object)gd);
        this.createProductAttributes((Composite)group);
        this.createTicketAttributes((Composite)group);
        this.createUpdateButton((Composite)group);
        return group;
    }

    protected void createUserGroup(Composite control) {
        UserSearchField userField = new UserSearchField();
        userField.createControls(control);
    }

    protected Control createProductAttributes(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Component);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Version);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Milestone);
        this.componentField = new ListSearchField("component");
        this.componentField.createControls(group, 60);
        this.versionField = new ListSearchField("version");
        this.versionField.createControls(group, 60);
        this.milestoneField = new ListSearchField("milestone");
        this.milestoneField.createControls(group, 60);
        return group;
    }

    protected Control createTicketAttributes(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Status);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Resolution);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Type);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Priority);
        this.statusField = new ListSearchField("status");
        this.statusField.createControls(group, 40);
        this.resolutionField = new ListSearchField("resolution");
        this.resolutionField.createControls(group, 40);
        this.typeField = new ListSearchField("type");
        this.typeField.createControls(group, 40);
        this.priorityField = new ListSearchField("priority");
        this.priorityField.createControls(group, 40);
        return group;
    }

    protected Control createUpdateButton(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.updateButton = new Button(group, 8);
        this.updateButton.setText(Messages.TracQueryPage_Update_Attributes_from_Repository);
        this.updateButton.setLayoutData((Object)new GridData());
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TracQueryPage.this.getTaskRepository() != null) {
                    TracQueryPage.this.updateAttributesFromRepository(true);
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TracQueryPage_Update_Attributes_Failed, (String)Messages.TracQueryPage_No_repository_available);
                }
            }
        });
        return group;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(true);
        }
        if (visible && this.firstTime) {
            this.firstTime = false;
            if (!this.hasAttributes()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (TracQueryPage.this.getControl() != null && !TracQueryPage.this.getControl().isDisposed()) {
                            TracQueryPage.this.initializePage();
                        }
                    }
                });
            } else {
                this.initializePage();
            }
        }
    }

    private void initializePage() {
        boolean restored;
        this.updateAttributesFromRepository(false);
        boolean bl = restored = this.getQuery() != null;
        if (this.inSearchContainer()) {
            restored |= this.restoreWidgetValues();
        }
    }

    private boolean hasAttributes() {
        TracRepositoryConnector connector = (TracRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("trac");
        ITracClient client = connector.getClientManager().getTracClient(this.getTaskRepository());
        return client.hasAttributes();
    }

    private void updateAttributesFromRepository(final boolean force) {
        TracRepositoryConnector connector = (TracRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("trac");
        final ITracClient client = connector.getClientManager().getTracClient(this.getTaskRepository());
        if (!client.hasAttributes() || force) {
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            client.updateAttributes(monitor, force);
                        }
                        catch (TracException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                if (this.getContainer() != null) {
                    this.getContainer().run(true, true, runnable);
                } else if (this.getSearchContainer() != null) {
                    this.getSearchContainer().getRunnableContext().run(true, true, runnable);
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.busyCursorWhile(runnable);
                }
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(TracCorePlugin.toStatus((Throwable)e.getCause(), (TaskRepository)this.getTaskRepository()).getMessage());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.statusField.setValues(client.getTicketStatus());
        this.resolutionField.setValues(client.getTicketResolutions());
        this.typeField.setValues(client.getTicketTypes());
        this.priorityField.setValues(client.getPriorities());
        this.componentField.setValues(client.getComponents());
        this.versionField.setValues(client.getVersions());
        this.milestoneField.setValues(client.getMilestones());
    }

    public boolean isPageComplete() {
        return this.titleText != null && this.titleText.getText().length() > 0;
    }

    public String getQueryUrl(String repsitoryUrl) {
        TracSearch search = this.getTracSearch();
        StringBuilder sb = new StringBuilder();
        sb.append(repsitoryUrl);
        sb.append("/query?format=tab");
        sb.append(search.toUrl());
        return sb.toString();
    }

    private TracSearch getTracSearch() {
        TracSearch search = new TracSearch();
        for (SearchField field : this.searchFieldByName.values()) {
            TracSearchFilter filter = field.getFilter();
            if (filter == null) continue;
            search.addFilter(filter);
        }
        return search;
    }

    public boolean performSearch() {
        if (this.inSearchContainer()) {
            this.saveState();
        }
        return super.performSearch();
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = TracUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(PAGE_NAME);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return dialogSettings;
    }

    private boolean restoreWidgetValues() {
        String repoId;
        IDialogSettings settings = this.getDialogSettings();
        String searchUrl = settings.get(SEARCH_URL_ID + (repoId = "." + this.getTaskRepository().getRepositoryUrl()));
        if (searchUrl == null) {
            return false;
        }
        this.restoreWidgetValues(new TracSearch(searchUrl));
        return true;
    }

    public void saveState() {
        String repoId = "." + this.getTaskRepository().getRepositoryUrl();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SEARCH_URL_ID + repoId, this.getTracSearch().toUrl());
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getQueryUrl(this.getTaskRepository().getRepositoryUrl()));
        query.setSummary(this.getQueryTitle());
    }

    private class ListSearchField
    extends SearchField {
        private org.eclipse.swt.widgets.List list;

        public ListSearchField(String fieldName) {
            super(fieldName);
        }

        public void setValues(Object[] items) {
            TracSearchFilter filter = this.getFilter();
            this.list.removeAll();
            if (items != null) {
                this.list.setEnabled(true);
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    this.list.add(item.toString());
                    ++n2;
                }
                if (filter != null) {
                    this.setFilter(filter);
                }
            } else {
                this.list.setEnabled(false);
            }
        }

        public void createControls(Composite parent, int height) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2562);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = height;
            this.list.setLayoutData((Object)gd);
        }

        public TracSearchFilter getFilter() {
            int[] indicies = this.list.getSelectionIndices();
            if (indicies.length == 0) {
                return null;
            }
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(TracSearchFilter.CompareOperator.IS);
            int[] nArray = indicies;
            int n = indicies.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                newFilter.addValue(this.list.getItem(i));
                ++n2;
            }
            return newFilter;
        }

        public void setFilter(TracSearchFilter filter) {
            this.list.deselectAll();
            List values = filter.getValues();
            for (String item : values) {
                int i = this.list.indexOf(item);
                if (i != -1) {
                    this.list.select(i);
                    continue;
                }
                this.list.add(item, 0);
                this.list.select(0);
            }
        }

        public void selectItems(String[] items) {
            this.list.deselectAll();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                int i = this.list.indexOf(item);
                if (i != -1) {
                    this.list.select(i);
                }
                ++n2;
            }
        }
    }

    private abstract class SearchField {
        protected String fieldName;

        public SearchField(String fieldName) {
            this.fieldName = fieldName;
            if (fieldName != null) {
                assert (!TracQueryPage.this.searchFieldByName.containsKey(fieldName));
                TracQueryPage.this.searchFieldByName.put(fieldName, this);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public abstract TracSearchFilter getFilter();

        public abstract void setFilter(TracSearchFilter var1);
    }

    private class TextSearchField
    extends SearchField {
        private Combo conditionCombo;
        protected Text searchText;
        private Label label;
        private final TracSearchFilter.CompareOperator[] compareOperators;

        public TextSearchField(String fieldName) {
            super(fieldName);
            this.compareOperators = new TracSearchFilter.CompareOperator[]{TracSearchFilter.CompareOperator.CONTAINS, TracSearchFilter.CompareOperator.CONTAINS_NOT, TracSearchFilter.CompareOperator.BEGINS_WITH, TracSearchFilter.CompareOperator.ENDS_WITH, TracSearchFilter.CompareOperator.IS, TracSearchFilter.CompareOperator.IS_NOT};
        }

        public void createControls(Composite parent, String labelText) {
            if (labelText != null) {
                this.label = new Label(parent, 16384);
                this.label.setText(labelText);
            }
            this.conditionCombo = new Combo(parent, 2060);
            TracSearchFilter.CompareOperator[] compareOperatorArray = this.compareOperators;
            int n = this.compareOperators.length;
            int n2 = 0;
            while (n2 < n) {
                TracSearchFilter.CompareOperator op = compareOperatorArray[n2];
                this.conditionCombo.add(op.toString());
                ++n2;
            }
            this.conditionCombo.setText(this.compareOperators[0].toString());
            this.searchText = new Text(parent, 2048);
            GridData gd = new GridData(4, 0x1000000, true, false);
            if (this.fieldName != null) {
                gd.horizontalSpan = 2;
            }
            this.searchText.setLayoutData((Object)gd);
        }

        public TracSearchFilter.CompareOperator getCondition() {
            return this.compareOperators[this.conditionCombo.getSelectionIndex()];
        }

        public String getSearchText() {
            return this.searchText.getText();
        }

        public boolean setCondition(TracSearchFilter.CompareOperator operator) {
            int i;
            if (this.conditionCombo != null && (i = this.conditionCombo.indexOf(operator.toString())) != -1) {
                this.conditionCombo.select(i);
                return true;
            }
            return false;
        }

        public void setSearchText(String text) {
            this.searchText.setText(text);
        }

        public TracSearchFilter getFilter() {
            String text = this.getSearchText();
            if (text.length() == 0) {
                return null;
            }
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(this.getCondition());
            newFilter.addValue(this.getSearchText());
            return newFilter;
        }

        public void setFilter(TracSearchFilter filter) {
            this.setCondition(filter.getOperator());
            List values = filter.getValues();
            this.setSearchText((String)values.get(0));
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }

    private class UserSearchField
    extends SearchField {
        private final TextSearchField textField;
        private Combo userCombo;

        public UserSearchField() {
            super(null);
            this.textField = new TextSearchField(null);
            new UserSelectionSearchField("owner", 0);
            new UserSelectionSearchField("reporter", 1);
            new UserSelectionSearchField("cc", 2);
        }

        public void createControls(Composite parent) {
            this.userCombo = new Combo(parent, 2060);
            this.userCombo.add(Messages.TracQueryPage_Owner);
            this.userCombo.add(Messages.TracQueryPage_Reporter);
            this.userCombo.add(Messages.TracQueryPage_CC);
            this.userCombo.select(0);
            this.textField.createControls(parent, null);
        }

        public TracSearchFilter getFilter() {
            return null;
        }

        public void setFilter(TracSearchFilter filter) {
        }

        private void setSelection(int index) {
            this.userCombo.select(index);
        }

        private int getSelection() {
            return this.userCombo.getSelectionIndex();
        }

        class UserSelectionSearchField
        extends SearchField {
            private final int index;

            public UserSelectionSearchField(String fieldName, int index) {
                super(fieldName);
                this.index = index;
            }

            public TracSearchFilter getFilter() {
                if (this.index == UserSearchField.this.getSelection()) {
                    UserSearchField.this.textField.setFieldName(this.fieldName);
                    return UserSearchField.this.textField.getFilter();
                }
                return null;
            }

            public void setFilter(TracSearchFilter filter) {
                UserSearchField.this.textField.setFieldName(this.fieldName);
                UserSearchField.this.textField.setFilter(filter);
                UserSearchField.this.setSelection(this.index);
            }
        }
    }
}

