/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.ActionExecutionMonitor;
import org.eclipse.mylyn.internal.monitor.ui.ActivityChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.KeybindingCommandMonitor;
import org.eclipse.mylyn.internal.monitor.ui.MenuCommandMonitor;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.monitor.ui.PerspectiveChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.PreferenceChangeMonitor;
import org.eclipse.mylyn.internal.monitor.ui.WindowChangeMonitor;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.wizards.NewUsageSummaryEditorWizard;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.ui.AbstractCommandMonitor;
import org.eclipse.mylyn.monitor.ui.IActionExecutionListener;
import org.eclipse.mylyn.monitor.ui.IMonitorLifecycleListener;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.monitor.usage.AbstractStudyBackgroundPage;
import org.eclipse.mylyn.monitor.usage.AbstractStudyQuestionnairePage;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.ui.security.Authentication;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiUsageMonitorPlugin
extends AbstractUIPlugin {
    public static final String PREF_USER_ID = "org.eclipse.mylyn.user.id";
    public static String VERSION = "1.0";
    public static String UPLOAD_FILE_LABEL = "USAGE";
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long DELAY_ON_USER_REQUEST = 432000000L;
    public static final String DEFAULT_TITLE = "Mylyn Feedback";
    public static final String DEFAULT_DESCRIPTION = "Fill out the following form to help us improve Mylyn based on your input.\n";
    public static final long DEFAULT_DELAY_BETWEEN_TRANSMITS = 1814400000L;
    public static final String DEFAULT_ETHICS_FORM = "doc/study-ethics.html";
    public static final String DEFAULT_VERSION = "";
    public static final String DEFAULT_UPLOAD_SERVER = "http://mylyn.eclipse.org/monitor/upload";
    public static final String DEFAULT_UPLOAD_SERVLET_ID = "/GetUserIDServlet";
    public static final String DEFAULT_UPLOAD_SERVLET = "/MylarUsageUploadServlet";
    public static final String DEFAULT_ACCEPTED_URL_LIST = "";
    public static final String DEFAULT_CONTACT_CONSENT_FIELD = "false";
    public static final String ID_UI_PLUGIN = "org.eclipse.mylyn.ui";
    public static final String MONITOR_LOG_NAME = "monitor-log";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.monitor.usage";
    private InteractionEventLogger interactionLogger;
    private String customizingPlugin = null;
    private PreferenceChangeMonitor preferenceMonitor;
    private PerspectiveChangeMonitor perspectiveMonitor;
    private ActivityChangeMonitor activityMonitor;
    private MenuCommandMonitor menuMonitor;
    private WindowChangeMonitor windowMonitor;
    private KeybindingCommandMonitor keybindingCommandMonitor;
    private static UiUsageMonitorPlugin plugin;
    private final List<IActionExecutionListener> actionExecutionListeners = new ArrayList<IActionExecutionListener>();
    private final List<AbstractCommandMonitor> commandMonitors = new ArrayList<AbstractCommandMonitor>();
    private ResourceBundle resourceBundle;
    private static Date lastTransmit;
    private final Authentication uploadAuthentication = null;
    private static boolean performingUpload;
    private boolean questionnaireEnabled = true;
    private boolean backgroundEnabled = false;
    private final StudyParameters studyParameters = new StudyParameters();
    private final ListenerList lifecycleListeners = new ListenerList();
    private final IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (window.getShell() != null) {
                window.getShell().removeShellListener(UiUsageMonitorPlugin.this.SHELL_LISTENER);
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
            if (window.getShell() != null && !PlatformUI.getWorkbench().isClosing()) {
                window.getShell().addShellListener(UiUsageMonitorPlugin.this.SHELL_LISTENER);
            }
        }
    };
    private final ShellListener SHELL_LISTENER = new ShellListener(){

        public void shellDeactivated(ShellEvent arg0) {
            if (!UiUsageMonitorPlugin.isPerformingUpload() && ContextCorePlugin.getDefault() != null) {
                for (IInteractionEventListener listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.stopMonitoring();
                }
            }
        }

        public void shellActivated(ShellEvent arg0) {
            if (!UiUsageMonitorPlugin.isPerformingUpload() && ContextCorePlugin.getDefault() != null) {
                for (IInteractionEventListener listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
                    listener.startMonitoring();
                }
            }
        }

        public void shellDeiconified(ShellEvent arg0) {
        }

        public void shellIconified(ShellEvent arg0) {
        }

        public void shellClosed(ShellEvent arg0) {
        }
    };
    private LogMoveUtility logMoveUtility;

    static {
        lastTransmit = null;
        performingUpload = false;
    }

    public UiUsageMonitorPlugin() {
        plugin = this;
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.obfuscate", true);
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.enabled", true);
        }
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.submission.initially.enabled")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.submission.initially.enabled", true);
            this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.enable.submission", true);
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    new MonitorUsageExtensionPointReader().initExtensions();
                    if (UiUsageMonitorPlugin.this.preferenceMonitor == null) {
                        UiUsageMonitorPlugin.this.preferenceMonitor = new PreferenceChangeMonitor();
                    }
                    UiUsageMonitorPlugin.this.interactionLogger = new InteractionEventLogger(UiUsageMonitorPlugin.this.getMonitorLogFile());
                    UiUsageMonitorPlugin.this.perspectiveMonitor = new PerspectiveChangeMonitor();
                    UiUsageMonitorPlugin.this.activityMonitor = new ActivityChangeMonitor();
                    UiUsageMonitorPlugin.this.windowMonitor = new WindowChangeMonitor();
                    UiUsageMonitorPlugin.this.menuMonitor = new MenuCommandMonitor();
                    UiUsageMonitorPlugin.this.keybindingCommandMonitor = new KeybindingCommandMonitor();
                    UiUsageMonitorPlugin.this.studyParameters.setServletUrl("http://mylyn.eclipse.org/monitor/upload/MylarUsageUploadServlet");
                    if (UiUsageMonitorPlugin.this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled")) {
                        UiUsageMonitorPlugin.this.startMonitoring();
                    }
                    if (plugin.getPreferenceStore().contains("org.eclipse.mylyn.monitor.ui.upload.previousTransmit")) {
                        lastTransmit = new Date(plugin.getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.upload.previousTransmit"));
                    } else {
                        lastTransmit = new Date();
                        plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, UiUsageMonitorPlugin.ID_PLUGIN, "Monitor failed to start", t));
                }
            }
        });
    }

    public void startMonitoring() {
        if (this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.monitoring.started")) {
            return;
        }
        this.interactionLogger.startMonitoring();
        for (IInteractionEventListener listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.startMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MonitorUi.addInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().add((AbstractCommandMonitor)this.keybindingCommandMonitor);
        this.getActionExecutionListeners().add((IActionExecutionListener)new ActionExecutionMonitor());
        workbench.addWindowListener(this.WINDOW_LISTENER);
        for (IWorkbenchWindow w : MonitorUiPlugin.getDefault().getMonitoredWindows()) {
            if (w.getShell() == null) continue;
            w.getShell().addShellListener(this.SHELL_LISTENER);
        }
        if (this.logMoveUtility == null) {
            this.logMoveUtility = new LogMoveUtility();
        }
        this.logMoveUtility.start();
        MonitorUiPlugin.getDefault().addWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        workbench.getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this.activityMonitor);
        workbench.getDisplay().addFilter(13, (Listener)this.menuMonitor);
        workbench.addWindowListener((IWindowListener)this.windowMonitor);
        Object[] objectArray = this.lifecycleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMonitorLifecycleListener)listener).startMonitoring();
            ++n2;
        }
        if (!MonitorUiPlugin.getDefault().suppressConfigurationWizards()) {
            this.checkForFirstMonitorUse();
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", true);
    }

    public void addMonitoredPreferences(Preferences preferences) {
        if (this.preferenceMonitor == null) {
            this.preferenceMonitor = new PreferenceChangeMonitor();
        }
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.preferenceMonitor);
    }

    public void removeMonitoredPreferences(Preferences preferences) {
        if (this.preferenceMonitor != null) {
            preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.preferenceMonitor);
        } else {
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "UI Usage Monitor not started", (Throwable)new Exception()));
        }
    }

    public boolean isObfuscationEnabled() {
        return UiUsageMonitorPlugin.getPrefs().getBoolean("org.eclipse.mylyn.monitor.ui.obfuscate");
    }

    public void stopMonitoring() {
        if (!this.getPreferenceStore().contains("org.eclipse.mylyn.monitor.monitoring.started")) {
            return;
        }
        Object[] objectArray = this.lifecycleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMonitorLifecycleListener)listener).stopMonitoring();
            ++n2;
        }
        for (Object listener : MonitorUiPlugin.getDefault().getInteractionListeners()) {
            listener.stopMonitoring();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        MonitorUi.removeInteractionListener((IInteractionEventListener)this.interactionLogger);
        this.getCommandMonitors().remove(this.keybindingCommandMonitor);
        this.getActionExecutionListeners().remove(new ActionExecutionMonitor());
        workbench.removeWindowListener(this.WINDOW_LISTENER);
        for (IWorkbenchWindow w : MonitorUiPlugin.getDefault().getMonitoredWindows()) {
            if (w.getShell() == null) continue;
            w.getShell().removeShellListener(this.SHELL_LISTENER);
        }
        this.logMoveUtility.stop();
        MonitorUiPlugin.getDefault().removeWindowPerspectiveListener((IPerspectiveListener)this.perspectiveMonitor);
        workbench.getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this.activityMonitor);
        workbench.getDisplay().removeFilter(13, (Listener)this.menuMonitor);
        workbench.removeWindowListener((IWindowListener)this.windowMonitor);
        this.interactionLogger.stopMonitoring();
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.monitoring.started", false);
    }

    public void addMonitoringLifecycleListener(IMonitorLifecycleListener listener) {
        this.lifecycleListeners.add((Object)listener);
        if (this.isMonitoringEnabled()) {
            listener.startMonitoring();
        }
    }

    public void removeMonitoringLifecycleListener(IMonitorLifecycleListener listener) {
        this.lifecycleListeners.remove((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public void actionObserved(IAction action, String info) {
        for (IActionExecutionListener listener : this.actionExecutionListeners) {
            listener.actionObserved(action);
        }
    }

    public List<IActionExecutionListener> getActionExecutionListeners() {
        return this.actionExecutionListeners;
    }

    public List<AbstractCommandMonitor> getCommandMonitors() {
        return this.commandMonitors;
    }

    public File getMonitorLogFile() {
        File rootDir = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/.metadata/.mylyn");
        File file = new File(rootDir, "monitor-log.xml");
        if (!file.exists() || !file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not create monitor file", (Throwable)e));
            }
        }
        return file;
    }

    private long getUserPromptDelay() {
        return 5L;
    }

    public void userCancelSubmitFeedback(Date currentTime, boolean wait3Hours) {
        if (wait3Hours) {
            lastTransmit.setTime(currentTime.getTime() + 432000000L - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        } else {
            long day = 86400000L;
            lastTransmit.setTime(currentTime.getTime() + day - this.studyParameters.getTransmitPromptPeriod());
            plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
    }

    public static UiUsageMonitorPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = UiUsageMonitorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.monitor.ui.MonitorPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    private void checkForFirstMonitorUse() {
    }

    synchronized void checkForStatisticsUpload() {
        if (!this.isMonitoringEnabled()) {
            return;
        }
        if (plugin == null || plugin.getPreferenceStore() == null) {
            return;
        }
        if (plugin.getPreferenceStore().contains("org.eclipse.mylyn.monitor.ui.upload.previousTransmit")) {
            lastTransmit = new Date(plugin.getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.upload.previousTransmit"));
        } else {
            lastTransmit = new Date();
            plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", lastTransmit.getTime());
        }
        Date currentTime = new Date();
        if (currentTime.getTime() > lastTransmit.getTime() + this.studyParameters.getTransmitPromptPeriod() && this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.enable.submission")) {
            String ending = this.getUserPromptDelay() == 1L ? "" : "s";
            MessageDialog message = new MessageDialog(Display.getDefault().getActiveShell(), "Send Usage Feedback", null, "To help improve the Eclipse and Mylyn user experience please consider uploading your UI usage statistics.", 3, new String[]{"Open UI Usage Report", "Remind me in " + this.getUserPromptDelay() + " day" + ending, "Don't ask again"}, 0);
            int result = 0;
            result = message.open();
            if (result == 0) {
                lastTransmit.setTime(new Date().getTime());
                plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", currentTime.getTime());
                if (!plugin.getPreferenceStore().contains("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed") || !plugin.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed")) {
                    MessageDialog consentMessage = new MessageDialog(Display.getDefault().getActiveShell(), "Consent", null, "All data that is submitted to mylyn.eclipse.org will be publicly available under the Eclipse Public License (EPL).  By submitting your data, you are agreeing that it can be publicly available. Please press cancel on the submission dialog box if you do not wish to share your data.", 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    consentMessage.open();
                    plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed", true);
                }
                NewUsageSummaryEditorWizard wizard = new NewUsageSummaryEditorWizard();
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            } else if (result == 1) {
                this.userCancelSubmitFeedback(currentTime, true);
            } else {
                plugin.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.enable.submission", false);
            }
            message.close();
        }
    }

    public void incrementObservedEvents(int increment) {
        int numEvents = this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed");
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.events.observed", numEvents += increment);
    }

    public void configureProxy(HttpClient httpClient, String uploadScript) {
        WebUtil.configureHttpClient((HttpClient)httpClient, null);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)httpClient, (AbstractWebLocation)new WebLocation(uploadScript, this.uploadAuthentication.getUser(), this.uploadAuthentication.getPassword()), null);
        httpClient.setHostConfiguration(hostConfiguration);
    }

    public static IPreferenceStore getPrefs() {
        return UiUsageMonitorPlugin.getDefault().getPreferenceStore();
    }

    public static boolean isPerformingUpload() {
        return performingUpload;
    }

    public static void setPerformingUpload(boolean performingUpload) {
        UiUsageMonitorPlugin.performingUpload = performingUpload;
    }

    public InteractionEventLogger getInteractionLogger() {
        return this.interactionLogger;
    }

    public boolean isQuestionnaireEnabled() {
        return this.questionnaireEnabled;
    }

    public void setQuestionnaireEnabled(boolean questionnaireEnabled) {
        this.questionnaireEnabled = questionnaireEnabled;
    }

    public StudyParameters getStudyParameters() {
        return this.studyParameters;
    }

    public String getCustomizingPlugin() {
        return this.customizingPlugin;
    }

    public boolean isMonitoringEnabled() {
        return this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled");
    }

    public String getCustomizedByMessage() {
        String customizedBy = UiUsageMonitorPlugin.getDefault().getCustomizingPlugin();
        String message = "NOTE: You have previously downloaded the Mylyn monitor and a user study plug-in with id: " + customizedBy + "\n" + "If you are not familiar with this plug-in do not upload data.";
        return message;
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.backgroundEnabled = backgroundEnabled;
    }

    public String getExtensionVersion() {
        return this.studyParameters.getVersion();
    }

    public boolean usingContactField() {
        return this.studyParameters.getUseContactField().equals("true");
    }

    private class LogMoveUtility {
        private LogMoveUtility() {
        }

        void start() {
        }

        void stop() {
        }
    }

    class MonitorUsageExtensionPointReader {
        public static final String EXTENSION_ID_STUDY = "org.eclipse.mylyn.monitor.ui.study";
        public static final String ELEMENT_SCRIPTS = "scripts";
        public static final String ELEMENT_SCRIPTS_VERSION = "version";
        public static final String ELEMENT_SCRIPTS_SERVER_URL = "url";
        public static final String ELEMENT_SCRIPTS_UPLOAD_USAGE = "upload";
        public static final String ELEMENT_SCRIPTS_GET_USER_ID = "userId";
        public static final String ELEMENT_SCRIPTS_UPLOAD_QUESTIONNAIRE = "questionnaire";
        public static final String ELEMENT_UI = "ui";
        public static final String ELEMENT_UI_TITLE = "title";
        public static final String ELEMENT_UI_DESCRIPTION = "description";
        public static final String ELEMENT_UI_UPLOAD_PROMPT = "daysBetweenUpload";
        public static final String ELEMENT_UI_QUESTIONNAIRE_PAGE = "questionnairePage";
        public static final String ELEMENT_UI_BACKGROUND_PAGE = "backgroundPage";
        public static final String ELEMENT_UI_CONSENT_FORM = "consentForm";
        public static final String ELEMENT_UI_CONTACT_CONSENT_FIELD = "useContactField";
        public static final String ELEMENT_MONITORS = "monitors";
        public static final String ELEMENT_MONITORS_BROWSER_URL = "browserUrlFilter";
        private boolean extensionsRead = false;

        MonitorUsageExtensionPointReader() {
        }

        public void initExtensions() {
            try {
                IExtensionRegistry registry;
                IExtensionPoint extensionPoint;
                if (!this.extensionsRead && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(EXTENSION_ID_STUDY)) != null) {
                    IExtension[] extensions;
                    IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if (element.getName().compareTo(ELEMENT_SCRIPTS) == 0) {
                                this.readScripts(element);
                            } else if (element.getName().compareTo(ELEMENT_UI) == 0) {
                                this.readForms(element);
                            } else if (element.getName().compareTo(ELEMENT_MONITORS) == 0) {
                                this.readMonitors(element);
                            }
                            ++n4;
                        }
                        UiUsageMonitorPlugin.this.customizingPlugin = extension.getContributor().getName();
                        ++n2;
                    }
                    this.extensionsRead = true;
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, UiUsageMonitorPlugin.ID_PLUGIN, "Could not read monitor extension", t));
            }
        }

        private void readScripts(IConfigurationElement element) {
            UiUsageMonitorPlugin.this.studyParameters.setVersion(element.getAttribute(ELEMENT_SCRIPTS_VERSION));
        }

        private void readForms(IConfigurationElement element) throws CoreException {
            Object page;
            UiUsageMonitorPlugin.this.studyParameters.setTitle(element.getAttribute(ELEMENT_UI_TITLE));
            UiUsageMonitorPlugin.this.studyParameters.setDescription(element.getAttribute(ELEMENT_UI_DESCRIPTION));
            if (element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT) != null) {
                Integer uploadInt = new Integer(element.getAttribute(ELEMENT_UI_UPLOAD_PROMPT));
                UiUsageMonitorPlugin.this.studyParameters.setTransmitPromptPeriod(86400000L * (long)uploadInt.intValue());
            }
            UiUsageMonitorPlugin.this.studyParameters.setUseContactField(element.getAttribute(ELEMENT_UI_CONTACT_CONSENT_FIELD));
            try {
                if (element.getAttribute(ELEMENT_UI_QUESTIONNAIRE_PAGE) != null) {
                    Object questionnaireObject = element.createExecutableExtension(ELEMENT_UI_QUESTIONNAIRE_PAGE);
                    if (questionnaireObject instanceof AbstractStudyQuestionnairePage) {
                        page = (AbstractStudyQuestionnairePage)((Object)questionnaireObject);
                        UiUsageMonitorPlugin.this.studyParameters.setQuestionnairePage((AbstractStudyQuestionnairePage)((Object)page));
                    }
                } else {
                    UiUsageMonitorPlugin.getDefault().setQuestionnaireEnabled(false);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, UiUsageMonitorPlugin.ID_PLUGIN, "Could not load questionaire", (Throwable)e));
                UiUsageMonitorPlugin.getDefault().setQuestionnaireEnabled(false);
            }
            try {
                if (element.getAttribute(ELEMENT_UI_BACKGROUND_PAGE) != null) {
                    Object backgroundObject = element.createExecutableExtension(ELEMENT_UI_BACKGROUND_PAGE);
                    if (backgroundObject instanceof AbstractStudyBackgroundPage) {
                        page = (AbstractStudyBackgroundPage)backgroundObject;
                        UiUsageMonitorPlugin.this.studyParameters.setBackgroundPage((AbstractStudyBackgroundPage)page);
                        UiUsageMonitorPlugin.getDefault().setBackgroundEnabled(true);
                    }
                } else {
                    UiUsageMonitorPlugin.getDefault().setBackgroundEnabled(false);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, UiUsageMonitorPlugin.ID_PLUGIN, "Could not load background page", (Throwable)e));
                UiUsageMonitorPlugin.getDefault().setBackgroundEnabled(false);
            }
            UiUsageMonitorPlugin.this.studyParameters.setFormsConsent("/" + element.getAttribute(ELEMENT_UI_CONSENT_FORM));
        }

        private void readMonitors(IConfigurationElement element) throws CoreException {
            String urlList = element.getAttribute(ELEMENT_MONITORS_BROWSER_URL);
            UiUsageMonitorPlugin.this.studyParameters.setAcceptedUrlList(urlList);
        }
    }

    public static class UiUsageMonitorStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

