/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorPage;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.sandbox.ui.editors.ExtensibleTaskEditorNewCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleBugzillaTaskEditorPage
extends BugzillaTaskEditorPage {
    private Action toggleFindAction;
    private static final Color HIGHLIGHTER_YELLOW = new Color((Device)Display.getDefault(), 255, 238, 99);
    private static final StyleRange HIGHLIGHT_STYLE_RANGE = new StyleRange(0, 0, null, HIGHLIGHTER_YELLOW);

    public ExtensibleBugzillaTaskEditorPage(TaskEditor editor) {
        super(editor);
    }

    private void addFindAction(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("find"));
        if (this.toggleFindAction != null && this.toggleFindAction.isChecked()) {
            ControlContribution findTextboxControl = new ControlContribution("Find"){

                protected Control createControl(Composite parent) {
                    FormToolkit toolkit = ExtensibleBugzillaTaskEditorPage.this.getTaskEditor().getHeaderForm().getToolkit();
                    Composite findComposite = toolkit.createComposite(parent);
                    findComposite.setLayout((Layout)new RowLayout());
                    findComposite.setBackground(null);
                    final Text findText = toolkit.createText(findComposite, "", 0x800000);
                    findText.setLayoutData((Object)new RowData(100, -1));
                    findText.setFocus();
                    toolkit.adapt((Control)findText, false, false);
                    findText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetDefaultSelected(SelectionEvent event) {
                            try {
                                ExtensibleBugzillaTaskEditorPage.this.setReflow(false);
                                ExtensibleBugzillaTaskEditorPage.findAndHighlight((IFormPage)ExtensibleBugzillaTaskEditorPage.this, findText.getText());
                                AbstractTaskEditorPart attachmentsPart = ExtensibleBugzillaTaskEditorPage.this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.attachments");
                                EditorUtil.toggleExpandableComposite((boolean)false, (ExpandableComposite)((ExpandableComposite)attachmentsPart.getControl()));
                            }
                            finally {
                                ExtensibleBugzillaTaskEditorPage.this.setReflow(true);
                            }
                            ExtensibleBugzillaTaskEditorPage.this.reflow();
                        }
                    });
                    return findComposite;
                }
            };
            toolBarManager.add((IContributionItem)findTextboxControl);
        }
        if (this.toggleFindAction == null) {
            this.toggleFindAction = new Action("", 2){

                public void run() {
                    ExtensibleBugzillaTaskEditorPage.this.getTaskEditor().updateHeaderToolBar();
                }
            };
            this.toggleFindAction.setImageDescriptor(CommonImages.FIND);
            this.toggleFindAction.setToolTipText("Find");
        }
        toolBarManager.add((IAction)this.toggleFindAction);
    }

    public boolean canPerformAction(String actionId) {
        if (actionId.equals(ActionFactory.FIND.getId())) {
            return true;
        }
        return super.canPerformAction(actionId);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.newComment")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            break;
        }
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.newComment"){

            public AbstractTaskEditorPart createPart() {
                return new ExtensibleTaskEditorNewCommentPart();
            }
        }.setPath("comments"));
        return descriptors;
    }

    public void doAction(String actionId) {
        if (actionId.equals(ActionFactory.FIND.getId()) && this.toggleFindAction != null) {
            this.toggleFindAction.setChecked(!this.toggleFindAction.isChecked());
            this.toggleFindAction.run();
        }
        super.doAction(actionId);
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        super.fillToolBar(toolBarManager);
        this.addFindAction(toolBarManager);
    }

    private static void findTextViewerControl(Composite composite, List<TextViewer> found) {
        if (!composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                TextViewer viewer = CommonTextSupport.getTextViewer((Widget)child);
                if (viewer != null && viewer.getDocument().get().length() > 0) {
                    found.add(viewer);
                }
                if (child instanceof ExpandableComposite) {
                    EditorUtil.toggleExpandableComposite((boolean)true, (ExpandableComposite)((ExpandableComposite)child));
                }
                if (child instanceof Composite) {
                    ExtensibleBugzillaTaskEditorPage.findTextViewerControl((Composite)child, found);
                }
                ++n2;
            }
        }
    }

    private static boolean findAndHighlightTextViewer(TextViewer viewer, FindReplaceDocumentAdapter adapter, String findString, int startOffset) throws BadLocationException {
        IRegion matchRegion = adapter.find(startOffset, findString, true, false, false, false);
        if (matchRegion != null) {
            int widgetOffset = matchRegion.getOffset();
            int length = matchRegion.getLength();
            ExtensibleBugzillaTaskEditorPage.HIGHLIGHT_STYLE_RANGE.start = widgetOffset;
            ExtensibleBugzillaTaskEditorPage.HIGHLIGHT_STYLE_RANGE.length = length;
            viewer.getTextWidget().setStyleRange(HIGHLIGHT_STYLE_RANGE);
            ExtensibleBugzillaTaskEditorPage.findAndHighlightTextViewer(viewer, adapter, findString, widgetOffset + length);
            return true;
        }
        return false;
    }

    public static void findAndHighlight(IFormPage page, String findString) {
        IManagedForm form = page.getManagedForm();
        if (form == null) {
            return;
        }
        ScrolledForm scrolledForm = form.getForm();
        if (scrolledForm == null) {
            return;
        }
        ArrayList<TextViewer> found = new ArrayList<TextViewer>();
        ExtensibleBugzillaTaskEditorPage.findTextViewerControl(scrolledForm.getBody(), found);
        block2: for (TextViewer viewer : found) {
            try {
                viewer.setRedraw(false);
                viewer.refresh();
                viewer.setRedraw(true);
                FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(viewer.getDocument());
                if (ExtensibleBugzillaTaskEditorPage.findAndHighlightTextViewer(viewer, adapter, findString, -1)) continue;
                Composite comp = viewer.getControl().getParent();
                while (comp != null) {
                    if (comp instanceof ExpandableComposite) {
                        ExpandableComposite ex = (ExpandableComposite)comp;
                        EditorUtil.toggleExpandableComposite((boolean)false, (ExpandableComposite)ex);
                        continue block2;
                    }
                    comp = comp.getParent();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

