/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.IResourceHyperlinkExtension;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.ResourceHyperlinkExtensionReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHyperlinkExtensions {
    private static Map<String, RegisteredResourceHyperlinkExtension> extensionByFileType = new HashMap<String, RegisteredResourceHyperlinkExtension>();
    private static boolean initialized = false;

    public static void addResourceHyperlinkExtension(String fileType, String generatedPrefix, IResourceHyperlinkExtension extension) {
        Assert.isNotNull((Object)fileType);
        RegisteredResourceHyperlinkExtension previous = extensionByFileType.put(fileType, new RegisteredResourceHyperlinkExtension(extension, fileType, generatedPrefix));
        if (previous != null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Duplicate resourceHyperlinkExtension fileType=" + fileType, null));
        }
    }

    public static IResourceHyperlinkExtension getResourceHyperlinkExtension(String fileType) {
        ResourceHyperlinkExtensions.init();
        RegisteredResourceHyperlinkExtension resourceHyperlinkExtension = extensionByFileType.get(fileType);
        return resourceHyperlinkExtension == null ? null : resourceHyperlinkExtension.getExtension();
    }

    public static String getGeneratedPrefix(String fileType) {
        ResourceHyperlinkExtensions.init();
        RegisteredResourceHyperlinkExtension resourceHyperlinkExtension = extensionByFileType.get(fileType);
        return resourceHyperlinkExtension == null ? null : resourceHyperlinkExtension.getGeneratedPrefix();
    }

    public static String getDefaultPrefix() {
        return ResourceHyperlinkExtensions.getGeneratedPrefix("default");
    }

    public static List<IResourceHyperlinkExtension> getResourceHyperlinkExtensions() {
        ResourceHyperlinkExtensions.init();
        ArrayList<IResourceHyperlinkExtension> resourceHyperlinkExtensions = new ArrayList<IResourceHyperlinkExtension>(extensionByFileType.size());
        for (RegisteredResourceHyperlinkExtension resourceHyperlinkExtension : extensionByFileType.values()) {
            resourceHyperlinkExtensions.add(resourceHyperlinkExtension.getExtension());
        }
        return resourceHyperlinkExtensions;
    }

    private static void init() {
        if (!initialized) {
            initialized = true;
            ResourceHyperlinkExtensionReader.initExtensions();
        }
    }

    public static class RegisteredResourceHyperlinkExtension {
        private final IResourceHyperlinkExtension extension;
        private final String fileType;
        private final String generatedPrefix;

        private RegisteredResourceHyperlinkExtension(IResourceHyperlinkExtension extension, String fileType, String generatedPrefix) {
            this.extension = extension;
            this.fileType = fileType;
            this.generatedPrefix = generatedPrefix;
        }

        public IResourceHyperlinkExtension getExtension() {
            return this.extension;
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getGeneratedPrefix() {
            return this.generatedPrefix;
        }
    }
}

