/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.xplanner.wsdl.soap.domain.DomainData;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.UserStoryData;

public class XPlannerAttributeMapper
extends TaskAttributeMapper {
    private static final long serialVersionUID = -4685044081450189855L;
    public static final String DEFAULT_REPOSITORY_TASK_KIND = "task";
    public static final String TIME_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    public static final int DATE_FORMAT_STYLE = 2;
    public static final int INVALID_ID = -1;
    public static final String INVALID_ID_STRING = String.valueOf(-1);
    public static final String ATTRIBUTE_EST_HOURS_NAME = "estimatedHours";
    public static final String ATTRIBUTE_ACT_HOURS_NAME = "actualHours";
    public static final String ATTRIBUTE_REMAINING_HOURS_NAME = "remainingHours";
    public static final String ATTRIBUTE_ADJUSTED_ESTIMATED_HOURS_NAME = "adjustedEstimatedHours";
    public static final String ATTRIBUTE_ESTIMATED_ORIGINAL_HOURS_NAME = "estimatedOriginalHours";
    public static final String ATTRIBUTE_PROJECT_NAME = "projectName";
    public static final String ATTRIBUTE_ITERATION_NAME = "iterationName";
    public static final String ATTRIBUTE_USER_STORY_NAME = "userStoryName";
    public static final String ATTRIBUTE_TASK_COMPLETED = "completed";
    public static final String ATTRIBUTE_ASSIGNED_ID = "assignedId";
    public static final String ATTRIBUTE_PROJECT_ID = "projectId";
    public static final String ATTRIBUTE_ITERATION_ID = "iterationId";
    public static final String ATTRIBUTE_USER_STORY_ID = "userStoryId";
    public static final String ATTRIBUTE_SUBTASK_IDS = "attribute.xplanner.subtask_ids";
    public static final String ATTRIBUTE_SUBTASK_KEYS = "attribute.xplanner.subtask_keys";
    private static Map<String, Attribute> commonKeyToAttributesMap = new HashMap<String, Attribute>();

    static {
        Attribute.values();
    }

    public XPlannerAttributeMapper(TaskRepository repository) {
        super(repository);
    }

    public static void setKind(ITask mylynTask, DomainData data) {
        String tempKind = XPlannerTaskKind.TASK.toString();
        if (data instanceof IterationData) {
            tempKind = XPlannerTaskKind.ITERATION.toString();
        } else if (data instanceof UserStoryData) {
            tempKind = XPlannerTaskKind.USER_STORY.toString();
        }
        mylynTask.setTaskKind(tempKind);
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        Attribute attribute = commonKeyToAttributesMap.get(key);
        if (attribute != null) {
            return attribute.getCommonAttributeKey();
        }
        return super.mapToRepositoryKey(parent, key);
    }

    public static Attribute getAttribute(String commonKey) {
        return commonKeyToAttributesMap.get(commonKey);
    }

    public Date getDateValue(TaskAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        String dateString = attribute.getValue();
        Date parsedDate = this.getDateForAttributeType(attribute, dateString);
        if (parsedDate == null) {
            parsedDate = super.getDateValue(attribute);
        }
        return parsedDate;
    }

    public Date getDateForAttributeType(TaskAttribute attribute, String dateString) {
        String mappedAttributeKey = this.mapToRepositoryKey(attribute, attribute.getId());
        return XPlannerAttributeMapper.getDateForAttributeType(mappedAttributeKey, dateString);
    }

    public static Date getDateForAttributeType(String mappedAttributeKey, String dateString) {
        if (mappedAttributeKey == null || mappedAttributeKey.length() == 0 || dateString == null || dateString.length() == 0) {
            return null;
        }
        Date date = null;
        try {
            if (mappedAttributeKey.equals(ATTRIBUTE_ACT_HOURS_NAME) || mappedAttributeKey.equals(ATTRIBUTE_EST_HOURS_NAME) || mappedAttributeKey.equals(ATTRIBUTE_REMAINING_HOURS_NAME) || mappedAttributeKey.equals("task.common.date.created")) {
                DateFormat dateFormat = DateFormat.getDateInstance(2);
                date = dateFormat.parse(dateString);
            } else if (mappedAttributeKey.equals("task.common.date.modified") || mappedAttributeKey.equals("LastModified")) {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat(TIME_DATE_FORMAT_STRING);
                date = timeDateFormat.parse(dateString);
            }
        }
        catch (Exception e) {
            XPlannerMylynUIPlugin.log(e.getCause(), "", false);
        }
        return date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        DESCRIPTION("Description:", "task.common.description", false),
        OWNER("Acceptor:", "task.common.user.assigned", true),
        PRIORITY("Priority:", "task.common.priority", true),
        STATUS("Status:", "task.common.status", true),
        NAME("Name:", "task.common.summary", false),
        CREATED_ON("Created:", "task.common.date.created", true),
        MODIFIED_TIME("Last Update:", "task.common.date.modified", true),
        SUBTASK_IDS("Subtask ids:", "attribute.xplanner.subtask_ids", true),
        SUBTASK_KEYS("Sub-Tasks:", "attribute.xplanner.subtask_keys", true);

        private final boolean isReadOnly;
        private final String displayName;
        private final String commonAttributeKey;

        private Attribute(String displayName, String commonAttributeKey, boolean readonly) {
            this.displayName = displayName;
            this.commonAttributeKey = commonAttributeKey;
            this.isReadOnly = readonly;
            commonKeyToAttributesMap.put(commonAttributeKey, this);
        }

        public String getCommonAttributeKey() {
            return this.commonAttributeKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XPlannerTaskKind {
        ITERATION,
        USER_STORY,
        TASK;


        public String toString() {
            switch (this) {
                case ITERATION: {
                    return "Iteration";
                }
                case USER_STORY: {
                    return "User Story";
                }
                case TASK: {
                    return "Task";
                }
            }
            return "";
        }

        public static XPlannerTaskKind fromString(String kindValue) {
            XPlannerTaskKind kind = TASK;
            if (kindValue.equals(TASK.toString())) {
                kind = TASK;
            } else if (kindValue.equals(USER_STORY.toString())) {
                kind = USER_STORY;
            } else if (kindValue.equals(ITERATION.toString())) {
                kind = ITERATION;
            }
            return kind;
        }
    }
}

