/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.xplanner.core.XPlannerCorePlugin;
import org.eclipse.mylyn.internal.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.internal.xplanner.ui.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerRepositoryConnector;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.PersonData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryUtils {
    private static final String TYPE_FEATURE = "Feature";
    private static final String NO_TASK_NAME = Messages.XPlannerRepositoryUtils_NO_TASK_NAME;
    public static final String DISPOSITION_PLANNED = "planned";
    private static HashSet<String> validatedRepositoryUrls = new HashSet();

    private XPlannerRepositoryUtils() {
    }

    public static TaskData createRepositoryTaskData(TaskRepository repository, ITask xplannerTask, XPlannerClient client) throws CoreException {
        TaskData repositoryTaskData = null;
        try {
            Date completionDate = null;
            if (XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString().equals(xplannerTask.getTaskKind()) || "task".equals(xplannerTask.getTaskKind())) {
                org.xplanner.soap.TaskData taskData = client.getTask(Integer.valueOf(xplannerTask.getTaskId()).intValue());
                if (taskData.isCompleted()) {
                    completionDate = taskData.getLastUpdateTime().getTime();
                }
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getRepositoryUrl(), taskData, xplannerTask.getTaskId());
                xplannerTask.setCompletionDate(completionDate);
            } else if (XPlannerAttributeMapper.XPlannerTaskKind.USER_STORY.toString().equals(xplannerTask.getTaskKind())) {
                UserStoryData userStory = client.getUserStory(Integer.valueOf(xplannerTask.getTaskId()).intValue());
                if (userStory.isCompleted()) {
                    completionDate = userStory.getLastUpdateTime().getTime();
                }
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getRepositoryUrl(), userStory, xplannerTask.getTaskId());
                xplannerTask.setCompletionDate(completionDate);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", 0, MessageFormat.format(Messages.XPlannerRepositoryUtils_TASK_DOWNLOAD_FAILED, xplannerTask.getRepositoryUrl(), TasksUiPlugin.LABEL_VIEW_REPOSITORIES), (Throwable)e));
        }
        return repositoryTaskData;
    }

    public static TaskData createRepositoryTaskData(TaskRepository repository, String taskId) throws CoreException {
        TaskData repositoryTaskData = null;
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        try {
            org.xplanner.soap.TaskData taskData = client.getTask(Integer.valueOf(taskId).intValue());
            if (taskData != null) {
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getRepositoryUrl(), taskData, taskId);
            } else {
                UserStoryData userStory = client.getUserStory(Integer.valueOf(taskId).intValue());
                if (userStory != null) {
                    repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getRepositoryUrl(), userStory, taskId);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", 0, MessageFormat.format(Messages.XPlannerRepositoryUtils_TASK_DOWNLOAD_FAILED, repository.getRepositoryUrl(), TasksUiPlugin.LABEL_VIEW_REPOSITORIES), (Throwable)e));
        }
        return repositoryTaskData;
    }

    public static TaskData getXPlannerRepositoryTaskData(String repositoryUrl, org.xplanner.soap.TaskData taskData, String id) throws IOException, MalformedURLException, LoginException, GeneralSecurityException, CoreException {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        TaskData repositoryTaskData = new TaskData((TaskAttributeMapper)new XPlannerAttributeMapper(repository), "xplanner", repositoryUrl, id);
        XPlannerRepositoryUtils.setupTaskAttributes(taskData, repositoryTaskData);
        return repositoryTaskData;
    }

    public static TaskData getXPlannerRepositoryTaskData(String repositoryUrl, UserStoryData userStory, String id) throws IOException, MalformedURLException, LoginException, GeneralSecurityException, CoreException {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        TaskData repositoryTaskData = new TaskData((TaskAttributeMapper)new XPlannerAttributeMapper(repository), "xplanner", repositoryUrl, id);
        XPlannerRepositoryUtils.setupUserStoryAttributes(userStory, repositoryTaskData);
        return repositoryTaskData;
    }

    public static void setupTaskAttributes(org.xplanner.soap.TaskData taskData, TaskData repositoryTaskData) throws CoreException {
        Date completionDate;
        Date lastUpdatedDate;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.kind", XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.description", taskData.getDescription());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(taskData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.status", taskData.getDispositionName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.summary", taskData.getName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(taskData.getAcceptorId(), client));
        if (taskData.getCreatedDate() != null) {
            Date createdDate = taskData.getCreatedDate().getTime();
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.date.created", dateFormat.format(createdDate));
        }
        if ((lastUpdatedDate = taskData.getLastUpdateTime().getTime()) != null) {
            XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.date.modified", timeDateFormat.format(lastUpdatedDate));
        }
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedHours", XPlannerRepositoryUtils.getStringValue(taskData.getEstimatedHours()));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "actualHours", XPlannerRepositoryUtils.getStringValue(taskData.getActualHours()));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "remainingHours", XPlannerRepositoryUtils.getStringValue(taskData.getRemainingHours()));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedOriginalHours", XPlannerRepositoryUtils.getStringValue(taskData.getEstimatedOriginalHours()));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "adjustedEstimatedHours", XPlannerRepositoryUtils.getStringValue(taskData.getAdjustedEstimatedHours()));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "projectName", XPlannerRepositoryUtils.getProjectName(taskData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "iterationName", XPlannerRepositoryUtils.getIterationName(taskData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "userStoryName", XPlannerRepositoryUtils.getUserStoryName(taskData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "completed", taskData.isCompleted() ? "1" : "0");
        if (taskData.isCompleted() && (completionDate = taskData.getLastUpdateTime().getTime()) != null) {
            XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.date.completed", timeDateFormat.format(lastUpdatedDate));
        }
    }

    public static void setupNewTaskAttributes(UserStoryData userStoryData, TaskData repositoryTaskData) throws CoreException {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.kind", XPlannerAttributeMapper.XPlannerTaskKind.TASK.toString());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.summary", "");
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(userStoryData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.status", userStoryData.getDispositionName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(userStoryData.getTrackerId(), client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "assignedId", "" + userStoryData.getTrackerId());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "projectName", XPlannerRepositoryUtils.getProjectName(userStoryData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "projectId", "" + XPlannerRepositoryUtils.getProjectId(userStoryData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "iterationName", XPlannerRepositoryUtils.getIterationName(userStoryData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "iterationId", "" + XPlannerRepositoryUtils.getIterationId(userStoryData, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "userStoryName", userStoryData.getName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "userStoryId", "" + userStoryData.getId());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "completed", "0");
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedHours", XPlannerRepositoryUtils.formatSingleFractionHours(0.0));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "actualHours", XPlannerRepositoryUtils.formatSingleFractionHours(0.0));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedOriginalHours", XPlannerRepositoryUtils.formatSingleFractionHours(0.0));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "remainingHours", XPlannerRepositoryUtils.formatSingleFractionHours(0.0));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "adjustedEstimatedHours", XPlannerRepositoryUtils.formatSingleFractionHours(0.0));
        XPlannerRepositoryUtils.setAttributeValues(repositoryTaskData, "attribute.xplanner.subtask_ids", XPlannerRepositoryUtils.getUserStoryTaskIds(userStoryData, client));
    }

    private static List<String> getUserStoryTaskIds(UserStoryData userStoryData, XPlannerClient client) throws CoreException {
        ArrayList<String> taskIds = new ArrayList<String>();
        try {
            org.xplanner.soap.TaskData[] userStoryTasks;
            org.xplanner.soap.TaskData[] taskDataArray = userStoryTasks = client.getTasks(userStoryData.getId());
            int n = userStoryTasks.length;
            int n2 = 0;
            while (n2 < n) {
                org.xplanner.soap.TaskData taskData = taskDataArray[n2];
                taskIds.add("" + taskData.getId());
                ++n2;
            }
        }
        catch (RemoteException re) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", re.getMessage(), (Throwable)re));
        }
        return taskIds;
    }

    public static org.xplanner.soap.TaskData createNewTaskData(TaskData repositoryTaskData, XPlannerClient client) {
        org.xplanner.soap.TaskData taskData = new org.xplanner.soap.TaskData();
        String assignedToId = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "assignedId");
        taskData.setAcceptorId(assignedToId == null || assignedToId.length() == 0 ? -1 : Integer.valueOf(assignedToId));
        String userStoryId = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "userStoryId");
        taskData.setStoryId(userStoryId == null || userStoryId.length() == 0 ? -1 : Integer.valueOf(userStoryId));
        String completed = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "completed");
        taskData.setCompleted(completed != null && !"0".equals(completed));
        taskData.setDispositionName(DISPOSITION_PLANNED);
        taskData.setType(TYPE_FEATURE);
        return taskData;
    }

    public static void ensureTaskDataValid(org.xplanner.soap.TaskData taskData) {
        if (taskData != null) {
            if (taskData.getDispositionName() == null || taskData.getDispositionName().length() == 0) {
                taskData.setDispositionName(DISPOSITION_PLANNED);
            }
            if (taskData.getName() == null || taskData.getName().length() == 0) {
                taskData.setName(NO_TASK_NAME);
            }
        }
    }

    public static void setupUserStoryAttributes(UserStoryData userStory, TaskData repositoryTaskData) throws CoreException {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.kind", XPlannerAttributeMapper.XPlannerTaskKind.USER_STORY.toString());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.description", userStory.getDescription());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(userStory, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.summary", userStory.getName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.status", userStory.getDispositionName());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(userStory.getTrackerId(), client));
        Date lastUpdatedDate = userStory.getLastUpdateTime().getTime();
        if (lastUpdatedDate != null) {
            XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "task.common.date.modified", timeDateFormat.format(lastUpdatedDate));
        }
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedHours", "" + userStory.getEstimatedHours());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "actualHours", "" + userStory.getActualHours());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "estimatedOriginalHours", "" + userStory.getEstimatedOriginalHours());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "remainingHours", "" + userStory.getRemainingHours());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "adjustedEstimatedHours", "" + userStory.getAdjustedEstimatedHours());
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "projectName", XPlannerRepositoryUtils.getProjectName(userStory, client));
        XPlannerRepositoryUtils.setAttributeValue(repositoryTaskData, "iterationName", XPlannerRepositoryUtils.getIterationName(userStory, client));
        XPlannerRepositoryUtils.setAttributeValues(repositoryTaskData, "attribute.xplanner.subtask_ids", XPlannerRepositoryUtils.getUserStoryTaskIds(userStory, client));
    }

    public static String getProjectName(TaskData repositoryTaskData) {
        return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "projectName");
    }

    public static String getIterationName(TaskData repositoryTaskData) {
        return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "iterationName");
    }

    public static String getUserStoryName(TaskData repositoryTaskData) {
        return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "userStoryName");
    }

    public static String getPersonName(int personId, XPlannerClient client) {
        String personName = Messages.XPlannerRepositoryUtils_NO_PERSON_NAME;
        try {
            PersonData personData = client.getPerson(personId);
            if (personData != null) {
                personName = personData.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personName;
    }

    public static void setAttributeValue(TaskData repositoryTaskData, String attributeId, String value) {
        TaskAttribute taskAttribute = repositoryTaskData.getRoot().getMappedAttribute(attributeId);
        if (taskAttribute == null) {
            taskAttribute = repositoryTaskData.getRoot().createMappedAttribute(attributeId);
            taskAttribute.getMetaData().defaults();
            taskAttribute.getMetaData().setReadOnly(false);
            taskAttribute.getMetaData().setType(XPlannerRepositoryUtils.getType(attributeId));
            XPlannerAttributeMapper.Attribute xplannerAttribute = XPlannerAttributeMapper.getAttribute(attributeId);
            if (xplannerAttribute != null) {
                taskAttribute.getMetaData().setLabel(xplannerAttribute.getDisplayName());
                taskAttribute.getMetaData().setReadOnly(xplannerAttribute.isReadOnly());
            }
        }
        if (taskAttribute != null) {
            repositoryTaskData.getAttributeMapper().setValue(taskAttribute, value == null ? "" : value);
        }
    }

    public static void setAttributeValues(TaskData repositoryTaskData, String attributeId, List<String> values) {
        TaskAttribute attribute = repositoryTaskData.getRoot().getMappedAttribute(attributeId);
        if (attribute == null) {
            attribute = repositoryTaskData.getRoot().createMappedAttribute(attributeId);
            attribute.getMetaData().defaults();
            attribute.getMetaData().setReadOnly(false);
        }
        if (attribute != null) {
            repositoryTaskData.getAttributeMapper().setValues(attribute, (List)(values == null ? new ArrayList() : values));
        }
    }

    public static String getType(String attributeId) {
        if (attributeId.equals(XPlannerAttributeMapper.Attribute.DESCRIPTION.getCommonAttributeKey())) {
            return "longRichText";
        }
        return "shortText";
    }

    public static String getAttributeValue(TaskData repositoryTaskData, String attributeId) {
        String value = null;
        TaskAttribute attribute = repositoryTaskData.getRoot().getMappedAttribute(attributeId);
        if (attribute != null) {
            value = repositoryTaskData.getAttributeMapper().getValue(attribute);
        }
        return value;
    }

    public static String getStringValue(Double hours) {
        return XPlannerRepositoryUtils.getStandardHoursNumberFormat().format(hours);
    }

    public static double getDoubleValue(String hours) {
        double doubleValue = 0.0;
        try {
            doubleValue = XPlannerRepositoryUtils.getStandardHoursNumberFormat().parse(hours).doubleValue();
        }
        catch (ParseException parseException) {
            doubleValue = Double.valueOf(hours);
        }
        return doubleValue;
    }

    public static double getActualHours(TaskData repositoryTaskData) {
        String hours = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "actualHours");
        return XPlannerRepositoryUtils.getDoubleValue(hours);
    }

    public static double getRemainingHours(TaskData repositoryTaskData) {
        String hours = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "remainingHours");
        return XPlannerRepositoryUtils.getDoubleValue(hours);
    }

    public static double getEstimatedHours(TaskData repositoryTaskData) {
        String hours = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "estimatedHours");
        return XPlannerRepositoryUtils.getDoubleValue(hours);
    }

    public static Double getAdjustedEstimatedHours(TaskData repositoryTaskData) {
        String hours = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "adjustedEstimatedHours");
        return XPlannerRepositoryUtils.getDoubleValue(hours);
    }

    public static Double getEstimatedOriginalHours(TaskData repositoryTaskData) {
        String hours = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "estimatedOriginalHours");
        return XPlannerRepositoryUtils.getDoubleValue(hours);
    }

    public static Date getCreatedDate(TaskData repositoryTaskData) {
        Date createdDate = null;
        String dateString = XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.date.created");
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            createdDate = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            XPlannerMylynUIPlugin.log(e.getCause(), "", false);
        }
        return createdDate;
    }

    public static String getProjectName(org.xplanner.soap.TaskData taskData, XPlannerClient client) throws CoreException {
        String projectName = Messages.XPlannerRepositoryUtils_NO_PROJECT_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            projectName = XPlannerRepositoryUtils.getProjectName(userStory, client);
        }
        catch (RemoteException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", e.getMessage(), (Throwable)e));
        }
        return projectName;
    }

    public static String getProjectName(UserStoryData userStory, XPlannerClient client) {
        String projectName = Messages.XPlannerRepositoryUtils_NO_PROJECT_NAME;
        try {
            ProjectData project;
            IterationData iteration;
            if (userStory != null && (iteration = client.getIteration(userStory.getIterationId())) != null && (project = client.getProject(iteration.getProjectId())) != null) {
                projectName = project.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectName;
    }

    public static int getProjectId(UserStoryData userStory, XPlannerClient client) {
        int projectId = -1;
        try {
            IterationData iteration;
            if (userStory != null && (iteration = client.getIteration(userStory.getIterationId())) != null) {
                projectId = iteration.getProjectId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectId;
    }

    public static String getIterationName(org.xplanner.soap.TaskData taskData, XPlannerClient client) throws CoreException {
        String iterationName = Messages.XPlannerRepositoryUtils_NO_ITERATION_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            iterationName = XPlannerRepositoryUtils.getIterationName(userStory, client);
        }
        catch (RemoteException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", e.getMessage(), (Throwable)e));
        }
        return iterationName;
    }

    public static String getIterationName(UserStoryData userStory, XPlannerClient client) {
        String iterationName = Messages.XPlannerRepositoryUtils_NO_ITERATION_NAME;
        try {
            IterationData iteration = client.getIteration(userStory.getIterationId());
            if (iteration != null) {
                iterationName = iteration.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterationName;
    }

    public static int getIterationId(UserStoryData userStory, XPlannerClient client) {
        int iterationId = -1;
        try {
            IterationData iteration = client.getIteration(userStory.getIterationId());
            if (iteration != null) {
                iterationId = iteration.getId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterationId;
    }

    public static String getUserStoryName(org.xplanner.soap.TaskData taskData, XPlannerClient client) {
        String userStoryName = Messages.XPlannerRepositoryUtils_NO_USER_STORY_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            if (userStory != null) {
                userStoryName = userStory.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userStoryName;
    }

    public static String getDescription(TaskData repositoryTaskData) {
        return XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "task.common.description");
    }

    public static boolean isCompleted(TaskData repositoryTaskData) {
        return "1".equals(XPlannerRepositoryUtils.getAttributeValue(repositoryTaskData, "completed"));
    }

    public static String getName(TaskData repositoryTaskData) {
        String name = null;
        TaskAttribute attribute = repositoryTaskData.getRoot().getMappedAttribute("task.common.summary");
        if (attribute != null) {
            name = repositoryTaskData.getAttributeMapper().getValue(attribute);
        }
        return name;
    }

    public static String getAssignedTo(TaskData repositoryTaskData) {
        String name = null;
        TaskAttribute attribute = repositoryTaskData.getRoot().getMappedAttribute("task.common.user.assigned");
        if (attribute != null) {
            name = repositoryTaskData.getAttributeMapper().getValue(attribute);
        }
        return name;
    }

    public static String getPriorityFromXPlannerObject(Object xplannerObject, XPlannerClient client) {
        int priority = -1;
        UserStoryData userStory = null;
        try {
            if (xplannerObject instanceof org.xplanner.soap.TaskData) {
                userStory = client.getUserStory(((org.xplanner.soap.TaskData)xplannerObject).getStoryId());
            } else if (xplannerObject instanceof UserStoryData) {
                userStory = (UserStoryData)xplannerObject;
            }
            if (userStory != null) {
                priority = userStory.getPriority();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return priority == -1 ? "" : String.valueOf(priority);
    }

    public static boolean isRepositoryUrlValidated(String repositoryUrl) {
        return validatedRepositoryUrls.contains(repositoryUrl);
    }

    static void addValidatedRepositoryUrl(String url) {
        validatedRepositoryUrls.add(url);
    }

    static void removeValidatedRepositoryUrl(String url) {
        validatedRepositoryUrls.remove(url);
    }

    public static void checkRepositoryValidated(String repositoryUrl) throws CoreException {
        if (repositoryUrl == null) {
            return;
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        if (taskRepository != null && !XPlannerRepositoryUtils.isRepositoryUrlValidated(taskRepository.getRepositoryUrl())) {
            XPlannerRepositoryUtils.validateRepository(taskRepository);
        }
    }

    public static void validateRepository(TaskRepository taskRepository) throws CoreException {
        AuthenticationCredentials repositoryCredentials = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
        if (repositoryCredentials == null) {
            return;
        }
        AuthenticationCredentials httpCredentials = taskRepository.getCredentials(AuthenticationType.HTTP);
        XPlannerRepositoryConnector connector = (XPlannerRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("xplanner");
        TaskRepositoryLocationFactory locationFactory = connector.getTaskRepositoryLocationFactory();
        AbstractWebLocation location = locationFactory.createWebLocation(taskRepository);
        String repositoryUrl = taskRepository.getRepositoryUrl();
        String repositoryUserName = repositoryCredentials.getUserName();
        String repositoryPassword = repositoryCredentials.getPassword();
        Proxy proxy = location.getProxyForHost(location.getUrl(), "HTTP");
        String httpUserName = httpCredentials == null ? null : httpCredentials.getUserName();
        String httpPassword = httpCredentials == null ? null : httpCredentials.getPassword();
        XPlannerRepositoryUtils.validateRepository(repositoryUrl, repositoryUserName, repositoryPassword, proxy, httpUserName, httpPassword);
    }

    public static void validateRepository(String url, String userName, String password) throws CoreException {
        XPlannerRepositoryUtils.validateRepository(url, userName, password, Proxy.NO_PROXY, null, null);
    }

    public static void validateRepository(String url, String userName, String password, Proxy proxy, String httpUser, String httpPassword) throws CoreException {
        try {
            XPlannerClientFacade.getDefault().validateServerAndCredentials(url, userName, password, proxy, httpUser, httpPassword);
        }
        catch (Exception e) {
            throw new CoreException(XPlannerCorePlugin.toStatus((Throwable)e));
        }
    }

    public static TaskData getNewRepositoryTaskData(TaskRepository taskRepository, UserStoryData userStoryData) throws CoreException {
        if (taskRepository == null || userStoryData == null) {
            return null;
        }
        XPlannerRepositoryConnector connector = (XPlannerRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("xplanner");
        XPlannerTaskDataHandler taskDataHandler = (XPlannerTaskDataHandler)connector.getTaskDataHandler();
        TaskAttributeMapper attributeMapper = taskDataHandler.getAttributeMapper(taskRepository);
        TaskData repositoryTaskData = new TaskData(attributeMapper, "xplanner", taskRepository.getRepositoryUrl(), "");
        taskDataHandler.initializeTaskData(taskRepository, repositoryTaskData, userStoryData);
        return repositoryTaskData;
    }

    public static ITask.PriorityLevel getPriorityLevel(String priority) {
        ITask.PriorityLevel priorityLevel = ITask.PriorityLevel.getDefault();
        int priorityValue = Integer.valueOf(priority);
        switch (priorityValue) {
            case 0: {
                priorityLevel = ITask.PriorityLevel.P1;
                break;
            }
            case 1: {
                priorityLevel = ITask.PriorityLevel.P1;
                break;
            }
            case 2: {
                priorityLevel = ITask.PriorityLevel.P2;
                break;
            }
            case 3: {
                priorityLevel = ITask.PriorityLevel.P3;
                break;
            }
            case 4: {
                priorityLevel = ITask.PriorityLevel.P4;
                break;
            }
            case 5: {
                priorityLevel = ITask.PriorityLevel.P5;
            }
        }
        return priorityLevel;
    }

    public static String formatHours(Double hours, boolean roundToHalfHour) {
        Double updatedHours = hours;
        if (roundToHalfHour) {
            Double decimal = new Double(Math.floor(hours));
            Double fraction = hours - decimal;
            updatedHours = fraction == 0.5 || fraction == 0.0 ? hours : (fraction > 0.0 && fraction < 0.25 ? decimal : (fraction >= 0.25 && fraction < 0.5 ? Double.valueOf(decimal + 0.5) : (fraction > 0.5 && fraction < 0.75 ? Double.valueOf(decimal + 0.5) : Double.valueOf(decimal + 1.0))));
        }
        return XPlannerRepositoryUtils.formatSingleFractionHours(updatedHours);
    }

    public static String formatSingleFractionHours(Double updatedHours) {
        NumberFormat format = XPlannerRepositoryUtils.getHoursNumberFormat();
        return format.format(updatedHours);
    }

    public static Double getHoursValue(String hoursStringValue) {
        Double hoursValue = 0.0;
        try {
            hoursValue = XPlannerRepositoryUtils.getHoursNumberFormat().parse(hoursStringValue).doubleValue();
        }
        catch (ParseException e) {
            XPlannerMylynUIPlugin.log(e.getCause(), "", false);
        }
        return hoursValue;
    }

    public static NumberFormat getStandardHoursNumberFormat() {
        return XPlannerRepositoryUtils.getHoursNumberFormat(Locale.US);
    }

    public static NumberFormat getHoursNumberFormat() {
        return XPlannerRepositoryUtils.getHoursNumberFormat(Locale.getDefault());
    }

    public static NumberFormat getHoursNumberFormat(Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumIntegerDigits(5);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        format.setGroupingUsed(false);
        format.setParseIntegerOnly(false);
        return format;
    }
}

