/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.editor;

import java.text.DecimalFormatSymbols;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.internal.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.editor.XPlannerEditorAttributeProvider;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class XPlannerTaskEditorExtraControls
extends AbstractTaskEditorPart {
    private final AbstractTaskEditorPage editor;
    private Label remainingTimeValueLabel;
    private Button completedButton;
    private Text actualTimeText;
    private String errorMessage = null;
    private Control errorControl = null;
    private Double lastRepositoryActualTime = 0.0;
    private boolean showTask = false;

    public XPlannerTaskEditorExtraControls(AbstractTaskEditorPage editor) {
        this(editor, true);
    }

    public XPlannerTaskEditorExtraControls(AbstractTaskEditorPage editor, boolean showTask) {
        this.editor = editor;
        this.showTask = showTask;
        this.setPartName(Messages.XPlannerTaskEditorExtraControls_ATTRIBUTES_TITLE);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        this.createHierarchySection(toolkit, composite, this.getRepositoryTaskData(), this.showTask);
        this.createDataSection(toolkit, composite, this.getRepositoryTaskData());
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.setSection(toolkit, section);
    }

    protected void createHierarchySection(FormToolkit toolkit, Composite formBody, TaskData repositoryTaskData, boolean showTask) {
        Section hierarchySection = toolkit.createSection(formBody, 258);
        hierarchySection.setText(Messages.XPlannerTaskEditor_HIERARCHY_SECTION_TITLE);
        hierarchySection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchySection);
        hierarchySection.setExpanded(true);
        Composite hierarchyComposite = toolkit.createComposite((Composite)hierarchySection, 0);
        GridLayout hierarchyGridLayout = new GridLayout(1, false);
        hierarchyGridLayout.marginWidth = 0;
        hierarchyComposite.setLayout((Layout)hierarchyGridLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchyComposite);
        hierarchySection.setClient((Control)hierarchyComposite);
        Tree hierarchyTree = toolkit.createTree(hierarchyComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(200, 80).applyTo((Control)hierarchyTree);
        TreeItem projectItem = new TreeItem(hierarchyTree, 0);
        projectItem.setText(XPlannerRepositoryUtils.getProjectName(repositoryTaskData));
        TreeItem iterationItem = new TreeItem(projectItem, 0);
        iterationItem.setText(XPlannerRepositoryUtils.getIterationName(repositoryTaskData));
        TreeItem storyItem = new TreeItem(iterationItem, 0);
        storyItem.setText(XPlannerRepositoryUtils.getUserStoryName(repositoryTaskData));
        if (showTask) {
            TreeItem taskItem = new TreeItem(storyItem, 0);
            taskItem.setText(XPlannerRepositoryUtils.getName(repositoryTaskData));
            hierarchyTree.showItem(taskItem);
        } else {
            hierarchyTree.showItem(storyItem);
        }
        hierarchySection.setExpanded(true);
    }

    private void createDataSection(FormToolkit toolkit, Composite formBody, TaskData repositoryTaskData) {
        Section dataSection = toolkit.createSection(formBody, 258);
        dataSection.setText(Messages.XPlannerTaskEditor_DATA_SECTION_TITLE);
        dataSection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 128).applyTo((Control)dataSection);
        dataSection.setExpanded(true);
        Composite dataComposite = toolkit.createComposite((Composite)dataSection, 2048);
        dataComposite.setLayout((Layout)new GridLayout(5, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dataComposite);
        dataSection.setClient((Control)dataComposite);
        Label acceptorLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ACCEPTOR_TEXT);
        acceptorLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Label acceptorValue = toolkit.createLabel(dataComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)acceptorValue);
        acceptorValue.setText(this.getAssignedToValue());
        Label estimatedHoursLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ESTIMATED_HOURS_TEXT);
        estimatedHoursLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        final Text estimatedTimeText = toolkit.createText(dataComposite, XPlannerRepositoryUtils.formatSingleFractionHours(XPlannerRepositoryUtils.getAdjustedEstimatedHours(repositoryTaskData)));
        estimatedTimeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Double value = XPlannerRepositoryUtils.getHoursValue(estimatedTimeText.getText());
                XPlannerTaskEditorExtraControls.this.updateAttribute("estimatedHours", Double.toString(value));
            }
        });
        estimatedTimeText.addVerifyListener((VerifyListener)new HoursVerifyListener());
        toolkit.createLabel(dataComposite, " (" + XPlannerRepositoryUtils.formatSingleFractionHours(XPlannerRepositoryUtils.getEstimatedOriginalHours(repositoryTaskData)) + ")");
        this.completedButton = toolkit.createButton(dataComposite, Messages.XPlannerTaskEditor_COMPLETED_BUTTON, 32);
        this.completedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerTaskEditorExtraControls.this.updateAttribute("completed", XPlannerTaskEditorExtraControls.this.completedButton.getSelection() ? "1" : "0");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.completedButton.setSelection(XPlannerRepositoryUtils.isCompleted(repositoryTaskData));
        Label actualTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ACTUAL_HOURS_TEXT);
        actualTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)actualTimeLabel);
        this.lastRepositoryActualTime = XPlannerRepositoryUtils.getActualHours(repositoryTaskData);
        this.actualTimeText = toolkit.createText(dataComposite, XPlannerRepositoryUtils.formatSingleFractionHours(this.lastRepositoryActualTime));
        this.actualTimeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (XPlannerTaskEditorExtraControls.this.validateActualTime() == null) {
                    Double value = XPlannerRepositoryUtils.getHoursValue(XPlannerTaskEditorExtraControls.this.actualTimeText.getText());
                    XPlannerTaskEditorExtraControls.this.updateAttribute("actualHours", Double.toString(value));
                }
            }
        });
        this.actualTimeText.addVerifyListener((VerifyListener)new HoursVerifyListener());
        Label remainingTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_REMAINING_HOURS_TEXT);
        remainingTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)remainingTimeLabel);
        Double remainingHours = new Double(XPlannerRepositoryUtils.getRemainingHours(repositoryTaskData));
        String formattedRemainingHours = XPlannerRepositoryUtils.formatSingleFractionHours(remainingHours);
        this.remainingTimeValueLabel = toolkit.createLabel(dataComposite, formattedRemainingHours);
        this.updateRemainingTimeFont();
        dataSection.setExpanded(true);
    }

    private String getAssignedToValue() {
        return XPlannerRepositoryUtils.getAssignedTo(this.getModel().getTaskData());
    }

    private void updateRemainingTimeFont() {
        if (this.remainingTimeValueLabel != null) {
            if (this.isTaskCompleted()) {
                this.remainingTimeValueLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
            } else {
                this.remainingTimeValueLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
        }
    }

    private boolean isTaskCompleted() {
        return this.completedButton.getSelection();
    }

    private void updateAttribute(String attributeName, String attributeValue) {
        TaskAttribute attribute = this.getRepositoryTaskData().getRoot().getMappedAttribute(attributeName);
        attribute.setValue(attributeValue);
        if (this.editor instanceof XPlannerEditorAttributeProvider) {
            ((XPlannerEditorAttributeProvider)this.editor).xplannerAttributeChanged(attribute);
        }
    }

    protected String validate() {
        if (this.errorMessage != null && this.errorControl != null) {
            this.errorControl.setFocus();
        }
        return this.errorMessage;
    }

    private String validateActualTime() {
        try {
            Double updatedActualTimeValue = XPlannerRepositoryUtils.getHoursValue(this.actualTimeText.getText());
            Double currentActualTimeValue = XPlannerRepositoryUtils.getActualHours(this.getRepositoryTaskData());
            if (updatedActualTimeValue < currentActualTimeValue) {
                this.errorMessage = Messages.XPlannerTaskEditorExtraControls_CANNOT_DECREASE_ACTUAL_TIME_VALUE_ERROR;
                this.errorControl = this.actualTimeText;
            } else {
                this.errorMessage = null;
                this.errorControl = null;
            }
            return this.errorMessage;
        }
        catch (Throwable throwable) {
            return "bad";
        }
    }

    protected void updateActualTimeWithElapsed(long newElapsedTime, boolean addToCurrent, boolean roundToHalfHour) {
        String elapsedHoursString = XPlannerRepositoryUtils.formatSingleFractionHours(0.0);
        try {
            elapsedHoursString = this.getElapsedHoursAsString(newElapsedTime, addToCurrent, roundToHalfHour);
        }
        catch (RuntimeException e1) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", Messages.XPlannerTaskEditorExtraControls_COULD_NOT_FORMAT_ELAPSED_TIME_ERROR, (Throwable)e1));
        }
        this.actualTimeText.setText(elapsedHoursString);
    }

    private static double convertMilliSecondsToHours(long milliSeconds) {
        Long minutes = Long.valueOf("" + milliSeconds) / 60000L;
        Double hours = (double)minutes.longValue() / 60.0;
        return hours;
    }

    private String getElapsedHoursAsString(long milliSeconds, boolean addToCurrent, boolean roundToHalfHour) {
        Double hours = XPlannerTaskEditorExtraControls.convertMilliSecondsToHours(milliSeconds);
        if (addToCurrent) {
            hours = new Double(this.lastRepositoryActualTime + hours);
        }
        String hoursString = hours == 0.0 ? XPlannerRepositoryUtils.formatSingleFractionHours(0.0) : XPlannerRepositoryUtils.formatHours(hours, roundToHalfHour);
        return hoursString;
    }

    private TaskData getRepositoryTaskData() {
        return this.editor.getModel().getTaskData();
    }

    public class HoursVerifyListener
    implements VerifyListener {
        public void verifyText(VerifyEvent event) {
            switch (event.keyCode) {
                case 8: 
                case 127: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000007: 
                case 0x1000008: {
                    return;
                }
            }
            if (event.character != '\u0000') {
                if (!this.isValidCharacter(event.character)) {
                    event.doit = false;
                }
            } else if (event.text != null) {
                int i = 0;
                while (i < event.text.length() && event.doit) {
                    if (!this.isValidCharacter(event.text.charAt(i))) {
                        event.doit = false;
                    }
                    ++i;
                }
            }
        }

        private boolean isValidCharacter(char character) {
            return Character.isDigit(character) || character == new DecimalFormatSymbols().getDecimalSeparator();
        }
    }
}

