/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.internal.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.editor.XPlannerTaskEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class XPlannerTimeTrackingEditorPart
extends AbstractTaskEditorPart
implements ITaskActivityListener,
SelectionListener {
    private Button useTimeTrackingButton;
    private Button addToCurrentTimeButton;
    private Button replaceCurrentTimeButton;
    private Button roundToHalfHourButton;
    private boolean useAutoTimeTracking;
    private boolean roundToHalfHour;
    private boolean addToCurrentTime;
    private Section timeTrackingSection;
    private final ITask task;
    private final XPlannerTaskEditor editor;

    public XPlannerTimeTrackingEditorPart(ITask task, XPlannerTaskEditor editor) {
        this.task = task;
        this.editor = editor;
        this.setPartName(Messages.XPlannerTimeTrackingEditorPart_TIME_TRACKING_TITLE);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.timeTrackingSection = toolkit.createSection(parent, 8210);
        this.timeTrackingSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.timeTrackingSection);
        this.timeTrackingSection.setText("");
        this.useTimeTrackingButton = toolkit.createButton((Composite)this.timeTrackingSection, Messages.XPlannerTimeTrackingEditorPart_UPDATE_TASK_TIME_FROM_MYLYN, 32);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).align(16384, 0x1000000).applyTo((Control)this.useTimeTrackingButton);
        this.useTimeTrackingButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(XPlannerTimeTrackingEditorPart.this.useTimeTrackingButton)) {
                    XPlannerTimeTrackingEditorPart.this.updateTimeTrackingSection();
                }
            }
        });
        this.useTimeTrackingButton.addSelectionListener((SelectionListener)this);
        this.timeTrackingSection.setTextClient((Control)this.useTimeTrackingButton);
        Composite timeTrackingComposite = toolkit.createComposite((Composite)this.timeTrackingSection, 0);
        this.timeTrackingSection.setClient((Control)timeTrackingComposite);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)timeTrackingComposite);
        timeTrackingComposite.setLayout((Layout)new GridLayout(1, false));
        this.roundToHalfHourButton = toolkit.createButton(timeTrackingComposite, Messages.XPlannerTimeTrackingEditorPart_ROUND_TO_HALF_HOUR, 32);
        GridDataFactory.fillDefaults().indent(new Point(15, 5)).applyTo((Control)this.roundToHalfHourButton);
        this.roundToHalfHourButton.addSelectionListener((SelectionListener)this);
        Composite updateMethodComposite = toolkit.createComposite(timeTrackingComposite);
        GridDataFactory.fillDefaults().indent(new Point(10, 0)).applyTo((Control)updateMethodComposite);
        updateMethodComposite.setLayout((Layout)new GridLayout(2, true));
        this.addToCurrentTimeButton = toolkit.createButton(updateMethodComposite, Messages.XPlannerTimeTrackingEditorPart_ADD_TO_CURRENT_REPOSITORY_TIME, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.addToCurrentTimeButton);
        this.addToCurrentTimeButton.setSelection(true);
        this.addToCurrentTimeButton.addSelectionListener((SelectionListener)this);
        this.replaceCurrentTimeButton = toolkit.createButton(updateMethodComposite, Messages.XPlannerTimeTrackingEditorPart_REPLACE_CURRENT_REPOSITORY_TIME, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.replaceCurrentTimeButton);
        this.replaceCurrentTimeButton.addSelectionListener((SelectionListener)this);
        TasksUiPlugin.getTaskActivityManager().addActivityListener((ITaskActivityListener)this);
        this.loadValuesFromPreferenceSettings();
        this.updateTimeTrackingControls();
    }

    private void updateTimeTrackingControls() {
        boolean enabled = this.isUseAutoTimeTracking();
        this.roundToHalfHourButton.setEnabled(enabled);
        this.addToCurrentTimeButton.setEnabled(enabled);
        this.replaceCurrentTimeButton.setEnabled(enabled);
    }

    public void dispose() {
        this.savePreferenceSettings();
        TasksUiPlugin.getTaskActivityManager().removeActivityListener((ITaskActivityListener)this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.useTimeTrackingButton)) {
            this.updateTimeTrackingControls();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.useTimeTrackingButton)) {
            this.setUseAutoTimeTracking(this.useTimeTrackingButton.getSelection());
            if (this.isUseAutoTimeTracking()) {
                this.forceElapsedTimeUpdated();
            }
            this.updateTimeTrackingControls();
        } else if (source.equals(this.roundToHalfHourButton)) {
            this.setRoundToHalfHour(this.roundToHalfHourButton.getSelection());
            this.forceElapsedTimeUpdated();
        } else if (source.equals(this.replaceCurrentTimeButton)) {
            this.setAddToCurrentTime(!this.replaceCurrentTimeButton.getSelection());
            if (!this.isAddToCurrentTime()) {
                this.forceElapsedTimeUpdated();
            }
        } else if (source.equals(this.addToCurrentTimeButton)) {
            this.setAddToCurrentTime(this.addToCurrentTimeButton.getSelection());
            if (this.isAddToCurrentTime()) {
                this.forceElapsedTimeUpdated();
            }
        }
    }

    public void setUseAutoTimeTracking(boolean useTimeTracking) {
        this.useAutoTimeTracking = useTimeTracking;
    }

    public boolean isUseAutoTimeTracking() {
        return this.useAutoTimeTracking;
    }

    private boolean isRoundToHalfHour() {
        return this.roundToHalfHour;
    }

    private void setRoundToHalfHour(boolean roundToHalfHour) {
        this.roundToHalfHour = roundToHalfHour;
    }

    private boolean isAddToCurrentTime() {
        return this.addToCurrentTime;
    }

    private void setAddToCurrentTime(boolean addToCurrentTime) {
        this.addToCurrentTime = addToCurrentTime;
    }

    private void forceElapsedTimeUpdated() {
        long elapsedTimeMillis = TasksUiPlugin.getTaskActivityManager().getElapsedTime(this.task);
        this.elapsedTimeUpdated(this.task, elapsedTimeMillis);
    }

    private void updateTimeTrackingSection() {
        this.timeTrackingSection.setExpanded(this.useTimeTrackingButton.getSelection());
    }

    private void loadValuesFromPreferenceSettings() {
        boolean useTimeTrackingPreference = XPlannerMylynUIPlugin.getBooleanPreference("UseAutoTimeTracking");
        this.useTimeTrackingButton.setSelection(useTimeTrackingPreference);
        this.setUseAutoTimeTracking(useTimeTrackingPreference);
        this.updateTimeTrackingSection();
        boolean roundToHalfHourPreference = XPlannerMylynUIPlugin.getBooleanPreference("RoundAutoTimeTrackingToHalfHour");
        this.roundToHalfHourButton.setSelection(roundToHalfHourPreference);
        this.setRoundToHalfHour(roundToHalfHourPreference);
        boolean addToCurrentTimePreference = XPlannerMylynUIPlugin.getBooleanPreference("AddAutoTrackedTimeToRepositoryValue");
        this.addToCurrentTimeButton.setSelection(addToCurrentTimePreference);
        this.replaceCurrentTimeButton.setSelection(!addToCurrentTimePreference);
        this.setAddToCurrentTime(addToCurrentTimePreference);
    }

    protected void savePreferenceSettings() {
        XPlannerMylynUIPlugin.setBooleanPreference("UseAutoTimeTracking", this.isUseAutoTimeTracking());
        XPlannerMylynUIPlugin.setBooleanPreference("RoundAutoTimeTrackingToHalfHour", this.isRoundToHalfHour());
        XPlannerMylynUIPlugin.setBooleanPreference("AddAutoTrackedTimeToRepositoryValue", this.isAddToCurrentTime());
    }

    public void elapsedTimeUpdated(ITask task, final long newElapsedTime) {
        if (!this.isUseAutoTimeTracking()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XPlannerTimeTrackingEditorPart.this.editor.getExtraControls().updateActualTimeWithElapsed(newElapsedTime, XPlannerTimeTrackingEditorPart.this.isAddToCurrentTime(), XPlannerTimeTrackingEditorPart.this.isRoundToHalfHour());
            }
        });
    }

    public void activityReset() {
    }
}

