/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class EscapeBlock
extends Block {
    private static final Pattern START_PATTERN = Pattern.compile("\\s*(<nowiki>).*", 2);
    private static final Pattern END_PATTERN = Pattern.compile("(</nowiki>)", 2);
    private int blockLineCount = 0;

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            Matcher matcher = START_PATTERN.matcher(line);
            if (offset > 0) {
                matcher.region(offset, line.length());
            }
            if (matcher.matches()) {
                offset = matcher.end(1);
            }
        }
        Matcher closeMatcher = END_PATTERN.matcher(line);
        if (offset > 0) {
            closeMatcher.region(offset, line.length());
        }
        int contentEnd = line.length();
        int end = -1;
        if (closeMatcher.find()) {
            int newContentStart = closeMatcher.end(1);
            this.setClosed(true);
            if (newContentStart < line.length()) {
                end = newContentStart;
                contentEnd = closeMatcher.start(1);
            }
        }
        this.getBuilder().characters(line.substring(offset, contentEnd));
        return end;
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            Matcher matcher = START_PATTERN.matcher(line);
            if (lineOffset > 0) {
                matcher.region(lineOffset, line.length());
            }
            if (matcher.matches()) {
                return true;
            }
        }
        return false;
    }
}

