/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map boosts;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer, Map boosts) {
        this(Version.LUCENE_24, fields, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(Version matchVersion, String[] fields, Analyzer analyzer, Map boosts) {
        this(matchVersion, fields, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        this(Version.LUCENE_24, fields, analyzer);
    }

    public MultiFieldQueryParser(Version matchVersion, String[] fields, Analyzer analyzer) {
        super(matchVersion, null, analyzer);
        this.fields = fields;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i], queryText);
                if (q == null) continue;
                if (this.boosts != null && (boost = (Float)this.boosts.get(this.fields[i])) != null) {
                    q.setBoost(boost.floatValue());
                }
                this.applySlop(q, slop);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        Query q = super.getFieldQuery(field, queryText);
        this.applySlop(q, slop);
        return q;
    }

    private void applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            ((PhraseQuery)q).setSlop(slop);
        } else if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
        }
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, 0);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getFuzzyQuery(this.fields[i], termStr, minSimilarity), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getPrefixQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getPrefixQuery(field, termStr);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getWildcardQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getWildcardQuery(field, termStr);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (field == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(this.getRangeQuery(this.fields[i], part1, part2, inclusive), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        return MultiFieldQueryParser.parse(Version.LUCENE_24, queries, fields, analyzer);
    }

    public static Query parse(Version matchVersion, String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(matchVersion, fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery;
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        return MultiFieldQueryParser.parse(Version.LUCENE_24, query, fields, flags, analyzer);
    }

    public static Query parse(Version matchVersion, String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(matchVersion, fields[i], analyzer);
            Query q = qp.parse(query);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery;
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        return MultiFieldQueryParser.parse(Version.LUCENE_24, queries, fields, flags, analyzer);
    }

    public static Query parse(Version matchVersion, String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(matchVersion, fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, flags[i]);
        }
        return bQuery;
    }
}

