/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.support.MockRepositoryConnectorAdapter;
import org.eclipse.mylyn.tasks.tests.support.MockRepositoryConnectorDescriptor;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.graphics.Image;
import org.junit.Test;

public class RepositoryConnectorContributorTest
extends TestCase {
    @Test
    public void testConnectorContributed() {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)"mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected dynamically contributed mock connector", (Object)connector);
        RepositoryConnectorContributorTest.assertEquals(MockRepositoryConnectorDescriptor.DynamicMockRepositoryConnector.class, connector.getClass());
        RepositoryConnectorContributorTest.assertEquals((String)"mock.dynamic", (String)connector.getConnectorKind());
    }

    @Test
    public void testConnectorUiContributed() {
        AbstractRepositoryConnectorUi connector = TasksUi.getRepositoryConnectorUi((String)"mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected connector UI contributed by MockRepositoryConnectorAdapter", (Object)connector);
        RepositoryConnectorContributorTest.assertEquals(MockRepositoryConnectorAdapter.DynamicMockRepositoryConnectorUi.class, connector.getClass());
        RepositoryConnectorContributorTest.assertEquals((String)"mock.dynamic", (String)connector.getConnectorKind());
    }

    @Test
    public void testMockBrandingIcon() {
        Image brandingImage = TasksUiPlugin.getDefault().getBrandingIcon("mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected branding image contributed by MockRepositoryConnectorAdapter", (Object)brandingImage);
    }

    @Test
    public void testMockOverlayIcon() {
        ImageDescriptor overlay = TasksUiPlugin.getDefault().getOverlayIcon("mock.dynamic");
        RepositoryConnectorContributorTest.assertNotNull((String)"Expected overlay image contributed by MockRepositoryConnectorAdapter", (Object)overlay);
        RepositoryConnectorContributorTest.assertEquals((int)8, (int)overlay.getImageData().height);
    }
}

