/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.elementparsers.ComputedAttributeInterpreter;
import com.google.gwt.uibinder.elementparsers.FieldInterpreter;
import com.google.gwt.uibinder.elementparsers.InterpreterPipe;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.uibinder.rebind.messages.PlaceholderInterpreter;

class HtmlPlaceholderInterpreter
extends PlaceholderInterpreter {
    private int serial = 0;
    private final XMLElement.Interpreter<String> fieldAndComputed;

    HtmlPlaceholderInterpreter(UiBinderWriter writer, MessageWriter message, String ancestorExpression) {
        super(writer, message);
        this.fieldAndComputed = InterpreterPipe.newPipe(new FieldInterpreter(writer, ancestorExpression), new ComputedAttributeInterpreter(writer));
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        this.fieldAndComputed.interpretElement(elem);
        if (this.isDomPlaceholder(elem)) {
            MessagesWriter mw = this.uiWriter.getMessages();
            String name = mw.consumeMessageAttribute("ph", elem);
            if ("".equals(name)) {
                name = "htmlElement" + ++this.serial;
            }
            String openTag = elem.consumeOpeningTag();
            String openPlaceholder = this.nextPlaceholder(name + "Begin", this.stripTokens(openTag), this.uiWriter.detokenate(openTag));
            String body = this.tokenator.nextToken(elem.consumeInnerHtml((XMLElement.PostProcessingInterpreter)this));
            String closeTag = elem.getClosingTag();
            String closePlaceholder = this.nextPlaceholder(name + "End", closeTag, closeTag);
            return openPlaceholder + body + closePlaceholder;
        }
        return super.interpretElement(elem);
    }

    protected String consumePlaceholderInnards(XMLElement elem) throws UnableToCompleteException {
        return elem.consumeInnerHtml(this.fieldAndComputed);
    }

    private boolean isDomPlaceholder(XMLElement elem) {
        MessagesWriter mw = this.uiWriter.getMessages();
        if (mw.hasMessageAttribute("ph", elem)) {
            return true;
        }
        for (int i = elem.getAttributeCount() - 1; i >= 0; --i) {
            if (!elem.getAttribute(i).hasToken()) continue;
            return true;
        }
        return false;
    }
}

