/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.sdk.java;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.sdk.java.TestJavaProject;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.pde.internal.core.natures.PluginProject;

public class WorkspaceSetupHelper {
    private static final int MAX_RETRY = 10;
    private static final String HELPER_CONTEXT_ID = "helper-context";
    private static boolean isSetup = false;
    private static InteractionContext taskscape;
    private static IJavaProject project1;
    private static IJavaProject project2;
    private static TestJavaProject jdtCoreDomProject;
    private static IWorkspaceRoot workspaceRoot;
    private static final IProgressMonitor NULL_MONITOR;

    static {
        NULL_MONITOR = new NullProgressMonitor();
    }

    public static IJavaProject createJavaPluginProjectFromZip(Object source, String projectName, String zipFileName) throws CoreException, ZipException, IOException {
        IProject project = WorkspaceSetupHelper.createProject(projectName);
        ZipFile zip = new ZipFile(CommonTestUtil.getFile((Object)source, (String)("testdata/projects/" + zipFileName)));
        CommonTestUtil.unzip((ZipFile)zip, (File)project.getLocation().toFile());
        project.refreshLocal(2, null);
        IJavaProject javaProject = WorkspaceSetupHelper.createPluginProject(project);
        return javaProject;
    }

    public static IJavaProject createJavaPluginProjectFromDirectory(File sourceDirectory, String projectName) throws CoreException, ZipException, IOException {
        IProject project = WorkspaceSetupHelper.createProject(projectName);
        CommonTestUtil.copyFolderRecursively((File)sourceDirectory, (File)project.getLocation().toFile());
        project.refreshLocal(2, null);
        IJavaProject javaProject = WorkspaceSetupHelper.createPluginProject(project);
        return javaProject;
    }

    public static IJavaProject createPluginProject(IProject project) throws CoreException, JavaModelException {
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder binFolder = project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(false, true, null);
        }
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.pde.PluginNature", "org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IPath outputLocation = binFolder.getFullPath();
        javaProject.setOutputLocation(outputLocation, null);
        PluginProject pluginProject = new PluginProject();
        pluginProject.setProject(project);
        pluginProject.configure();
        return javaProject;
    }

    public static IProject createProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(NULL_MONITOR);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(NULL_MONITOR);
        }
        return project;
    }

    public static void clearWorkspace() throws CoreException, IOException {
        isSetup = false;
        ResourcesPlugin.getWorkspace().getRoot().delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        WorkspaceSetupHelper.clearDoiModel();
    }

    public static IWorkspaceRoot setupWorkspace() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (isSetup) {
            WorkspaceSetupHelper.clearDoiModel();
            return workspaceRoot;
        }
        taskscape = new InteractionContext(HELPER_CONTEXT_ID, (IInteractionContextScaling)new InteractionContextScaling());
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        project1 = WorkspaceSetupHelper.createJavaPluginProjectFromZip(WorkspaceSetupHelper.class, "project1", "project1.zip");
        project2 = WorkspaceSetupHelper.createJavaPluginProjectFromZip(WorkspaceSetupHelper.class, "project2", "project2.zip");
        jdtCoreDomProject = new TestJavaProject("workspace-helper-project");
        IPackageFragment jdtCoreDomPkg = jdtCoreDomProject.createPackage("org.eclipse.jdt.core.dom");
        IType astNodeType = jdtCoreDomProject.createType(jdtCoreDomPkg, "ASTNode.java", "public class ASTNode { }");
        astNodeType.createMethod("public final void setSourceRange(int startPosition, int length) { }", null, false, null);
        isSetup = true;
        project1.open((IProgressMonitor)new NullProgressMonitor());
        project2.open((IProgressMonitor)new NullProgressMonitor());
        jdtCoreDomProject.getJavaProject().open((IProgressMonitor)new NullProgressMonitor());
        return workspaceRoot;
    }

    public static void delete(final IResource resource) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < 10) {
                    try {
                        resource.delete(true, null);
                        i = 10;
                    }
                    catch (CoreException e) {
                        if (i == 9) {
                            StatusHandler.log((IStatus)e.getStatus());
                            throw e;
                        }
                        System.gc();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public static void deleteProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            WorkspaceSetupHelper.delete((IResource)project);
        }
    }

    public static void clearDoiModel() throws CoreException {
        ContextCore.getContextManager().deleteContext(HELPER_CONTEXT_ID);
        taskscape = new InteractionContext(HELPER_CONTEXT_ID, (IInteractionContextScaling)new InteractionContextScaling());
    }

    public static InteractionContext getContext() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (!isSetup) {
            WorkspaceSetupHelper.setupWorkspace();
        }
        return taskscape;
    }

    public static IJavaProject getJdtCoreDomProject() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (!isSetup) {
            WorkspaceSetupHelper.setupWorkspace();
        }
        return jdtCoreDomProject.getJavaProject();
    }

    public static IJavaProject getProject1() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (!isSetup) {
            WorkspaceSetupHelper.setupWorkspace();
        }
        return project1;
    }

    public static IJavaProject getProject2() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (!isSetup) {
            WorkspaceSetupHelper.setupWorkspace();
        }
        return project2;
    }

    public static IWorkspaceRoot getWorkspaceRoot() throws CoreException, IOException, InvocationTargetException, InterruptedException {
        if (!isSetup) {
            WorkspaceSetupHelper.setupWorkspace();
        }
        return workspaceRoot;
    }

    public static IFile getFile(IJavaProject jp, String name) throws JavaModelException {
        Object[] files;
        if (jp == null || name == null) {
            return null;
        }
        Object[] objectArray = files = jp.getNonJavaResources();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile && ((IFile)o).getName().equals(name)) {
                return (IFile)o;
            }
            ++n2;
        }
        return null;
    }

    public static IType getType(IJavaProject jp, String fullyQualifiedName) throws JavaModelException {
        if (jp == null || fullyQualifiedName == null) {
            return null;
        }
        IType t = jp.findType(fullyQualifiedName);
        return t;
    }

    public static IMethod getMethod(IType t, String methodName, String[] params) {
        if (t == null || methodName == null || params == null) {
            return null;
        }
        return t.getMethod(methodName, params);
    }
}

