/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCommentLinkDetector;
import org.eclipse.mylyn.internal.gerrit.ui.GerritImages;
import org.eclipse.mylyn.internal.gerrit.ui.GerritRepositorySettingsPage;
import org.eclipse.mylyn.internal.gerrit.ui.Messages;
import org.eclipse.mylyn.internal.gerrit.ui.wizards.GerritCustomQueryPage;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class GerritConnectorUi
extends AbstractRepositoryConnectorUi {
    private static final Pattern PATTERN_CHANGE_ID = Pattern.compile("(?:\\W||^)(I[0-9a-f]{8}([0-9a-f]{32})?)");
    private final GerritConnector connector = (GerritConnector)TasksUi.getRepositoryConnector((String)"org.eclipse.mylyn.gerrit");

    public String getConnectorKind() {
        return "org.eclipse.mylyn.gerrit";
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        return new NewTaskWizard(taskRepository, taskSelection);
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        wizard.addPage((IWizardPage)new GerritCustomQueryPage(repository, "GerritQueryPage", query));
        return wizard;
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new GerritRepositorySettingsPage(taskRepository);
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new GerritCustomQueryPage(repository, "GerritQueryPage", null);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getTaskKindLabel(ITask task) {
        return Messages.GerritConnectorUi_Change;
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        return GerritImages.OVERLAY_REVIEW;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, ITask task, String text, int index, int textOffset) {
        GerritCommentLinkDetector detector;
        List<IHyperlink> commentLinks;
        GerritConfigX config;
        ArrayList<Object> links = null;
        Matcher matcher = PATTERN_CHANGE_ID.matcher(text);
        while (matcher.find()) {
            if (index != -1 && (index < matcher.start() || index > matcher.end())) continue;
            String key = matcher.group(1);
            if (task != null && task.getTaskKey() != null && key.startsWith(task.getTaskKey())) continue;
            if (links == null) {
                links = new ArrayList<Object>();
            }
            int start = matcher.start(1);
            Region region = new Region(textOffset + start, matcher.end(1) - start);
            links.add(new TaskHyperlink((IRegion)region, repository, key));
        }
        GerritConfiguration configuration = this.connector.getConfiguration(repository);
        if (configuration != null && (config = configuration.getGerritConfig()) != null && (commentLinks = (detector = new GerritCommentLinkDetector(repository, config)).findHyperlinks(text, index, textOffset)) != null) {
            if (links == null) {
                links = new ArrayList();
            }
            links.addAll(commentLinks);
        }
        return links != null ? links.toArray(new IHyperlink[links.size()]) : null;
    }
}

