/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.common.base.Strings;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.gerrit.core.GerritOperationFactory;
import org.eclipse.mylyn.internal.gerrit.core.Messages;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.DiscardDraftRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.SaveDraftRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.egit.GitFileRevisionUtils;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;

public class GerritReviewBehavior
extends ReviewBehavior {
    private Repository repository = null;
    private final short LEFT_SIDE = 0;
    private final short RIGHT_SIDE = 1;
    private final String BASE = "base-";

    public GerritReviewBehavior(ITask task) {
        super(task);
    }

    public GerritReviewBehavior(ITask task, Repository repository) {
        super(task);
        this.repository = repository;
    }

    public GerritOperationFactory getOperationFactory() {
        return GerritUiPlugin.getDefault().getOperationFactory();
    }

    public IStatus addComment(IReviewItem item, IComment comment, IProgressMonitor monitor) {
        short side = 1;
        String id = item.getId();
        if (id.startsWith("base-")) {
            id = id.substring("base-".length());
            side = 0;
        }
        Patch.Key key = Patch.Key.parse((String)id);
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            ILineLocation lineLocation = (ILineLocation)location;
            SaveDraftRequest request = new SaveDraftRequest(key, lineLocation.getRangeMin(), side, null, Strings.emptyToNull((String)comment.getId()));
            request.setMessage(comment.getDescription());
            GerritOperation operation = this.getOperationFactory().createOperation(this.getTask(), (AbstractRequest)request);
            IStatus status = operation.run(monitor);
            PatchLineComment patchLineComment = (PatchLineComment)operation.getOperationResult();
            if (patchLineComment != null && patchLineComment.getKey() != null) {
                comment.setId(patchLineComment.getKey().get());
            }
            return status;
        }
        throw new RuntimeException(NLS.bind((String)Messages.GerritReviewBehavior_Internal_Exception, (Object)comment.getId()));
    }

    public IStatus discardComment(IReviewItem item, IComment comment, IProgressMonitor monitor) {
        String id = item.getId();
        if (id.startsWith("base-")) {
            id = id.substring("base-".length());
        }
        Patch.Key key = Patch.Key.parse((String)id);
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            ILineLocation cfr_ignored_0 = (ILineLocation)location;
            DiscardDraftRequest request = new DiscardDraftRequest(key, comment.getId());
            request.setMessage(comment.getDescription());
            GerritOperation operation = this.getOperationFactory().createOperation(this.getTask(), (AbstractRequest)request);
            return operation.run(monitor);
        }
        throw new RuntimeException(String.valueOf(Messages.GerritReviewBehavior_Internal_Exception) + comment.getId());
    }

    public IFileRevision getFileRevision(IFileVersion reviewFileVersion) {
        if (this.repository != null) {
            return GitFileRevisionUtils.getFileRevision(this.repository, reviewFileVersion);
        }
        return null;
    }
}

