/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.HasSetters;
import com.google.gwt.rpc.client.ast.IdentityValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.client.impl.CommandSerializationStreamWriterBase;
import com.google.gwt.rpc.client.impl.HasValuesCommandSink;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.CommandSerializationUtil;
import com.google.gwt.rpc.server.HostedModeClientOracle;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServerSerializationStreamWriter
extends CommandSerializationStreamWriterBase {
    private final ClientOracle clientOracle;
    private final Map<Object, IdentityValueCommand> identityMap;

    public CommandServerSerializationStreamWriter(CommandSink sink) {
        this(new HostedModeClientOracle(), sink);
    }

    public CommandServerSerializationStreamWriter(ClientOracle oracle, CommandSink sink) {
        this(oracle, sink, new IdentityHashMap<Object, IdentityValueCommand>());
    }

    private CommandServerSerializationStreamWriter(ClientOracle oracle, CommandSink sink, Map<Object, IdentityValueCommand> identityMap) {
        super(sink);
        this.clientOracle = oracle;
        this.identityMap = identityMap;
    }

    @Override
    protected ValueCommand makeValue(Class<?> type, Object value) throws SerializationException {
        if (value == null) {
            return NullValueCommand.INSTANCE;
        }
        CommandSerializationUtil.Accessor accessor = CommandSerializationUtil.getAccessor(type);
        if (accessor.canMakeValueCommand()) {
            return accessor.makeValueCommand(value);
        }
        if (this.identityMap.containsKey(value)) {
            return this.identityMap.get(value);
        }
        if (type.isArray()) {
            return this.makeArray(type, value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.makeEnum(value);
        }
        return this.makeObject(type, value);
    }

    private ArrayValueCommand makeArray(Class<?> type, Object value) throws SerializationException {
        ArrayValueCommand toReturn = new ArrayValueCommand(type.getComponentType());
        this.identityMap.put(value, toReturn);
        int j = Array.getLength(value);
        for (int i = 0; i < j; ++i) {
            Object arrayValue = Array.get(value, i);
            if (arrayValue == null) {
                toReturn.add(NullValueCommand.INSTANCE);
                continue;
            }
            Class<?> valueType = type.getComponentType().isPrimitive() ? type.getComponentType() : arrayValue.getClass();
            toReturn.add(this.makeValue(valueType, arrayValue));
        }
        return toReturn;
    }

    private ValueCommand makeEnum(Object value) {
        EnumValueCommand toReturn = new EnumValueCommand();
        toReturn.setValue((Enum)value);
        return toReturn;
    }

    private IdentityValueCommand makeObject(Class<?> type, Object value) throws SerializationException {
        IdentityValueCommand ins;
        Class<?> customSerializer;
        if (type.isAnonymousClass() || type.isLocalClass()) {
            throw new SerializationException("Cannot serialize anonymous or local classes");
        }
        Class<?> manualType = type;
        while ((customSerializer = SerializabilityUtil.hasCustomFieldSerializer(manualType)) == null && (manualType = manualType.getSuperclass()) != null) {
        }
        if (customSerializer != null) {
            ins = this.serializeWithCustomSerializer(customSerializer, value, type, manualType);
        } else {
            ins = new InstantiateCommand(type);
            this.identityMap.put(value, ins);
        }
        if (type != manualType && !Serializable.class.isAssignableFrom(type) && !IsSerializable.class.isAssignableFrom(type)) {
            throw new SerializationException(type.getName() + " is not a serializable type");
        }
        while (type != manualType) {
            Field[] serializableFields;
            for (Field declField : serializableFields = this.clientOracle.getOperableFields(type)) {
                ValueCommand valueCommand;
                assert (declField != null);
                CommandSerializationUtil.Accessor accessor = CommandSerializationUtil.getAccessor(declField.getType());
                Object fieldValue = accessor.get(value, declField);
                if (fieldValue == null) {
                    valueCommand = NullValueCommand.INSTANCE;
                } else {
                    Class<?> fieldType = declField.getType().isPrimitive() ? declField.getType() : fieldValue.getClass();
                    valueCommand = this.makeValue(fieldType, fieldValue);
                }
                ((HasSetters)((Object)ins)).set(declField.getDeclaringClass(), declField.getName(), valueCommand);
            }
            type = type.getSuperclass();
        }
        return ins;
    }

    private InvokeCustomFieldSerializerCommand serializeWithCustomSerializer(Class<?> customSerializer, Object instance, Class<?> instanceClass, Class<?> manuallySerializedType) throws SerializationException {
        Exception ex;
        assert (!instanceClass.isArray());
        try {
            for (Method method : customSerializer.getMethods()) {
                if (!"serialize".equals(method.getName())) continue;
                assert (Modifier.isStatic(method.getModifiers())) : "serialize method in type " + customSerializer.getName() + " must be static";
                InvokeCustomFieldSerializerCommand toReturn = new InvokeCustomFieldSerializerCommand(instanceClass, customSerializer, manuallySerializedType);
                this.identityMap.put(instance, toReturn);
                CommandServerSerializationStreamWriter subWriter = new CommandServerSerializationStreamWriter(this.clientOracle, new HasValuesCommandSink(toReturn), this.identityMap);
                method.invoke(null, subWriter, instance);
                return toReturn;
            }
            throw new NoSuchMethodException("Could not find serialize method in custom serializer " + customSerializer.getName());
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new SerializationException(ex);
    }
}

