/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.GradientCanvas;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.BundleDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.core.model.RemoteBundleDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryCategoryComparator;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryConnectorComparator;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryImages;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.mylyn.internal.discovery.ui.wizards.OverviewToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DiscoveryViewer {
    private static final int MINIMUM_HEIGHT = 100;
    private boolean showConnectorDescriptorKindFilter;
    private boolean showConnectorDescriptorTextFilter;
    private static final String COLOR_WHITE = "white";
    private static final String COLOR_DARK_GRAY = "DarkGray";
    private static Boolean useNativeSearchField;
    private final List<ConnectorDescriptor> installableConnectors = new ArrayList<ConnectorDescriptor>();
    private volatile ConnectorDiscovery discovery;
    private Composite body;
    private final List<Resource> disposables;
    private Font h2Font;
    private Font h1Font;
    private Color colorWhite;
    private Text filterText;
    private WorkbenchJob refreshJob;
    private String previousFilterText = "";
    private Pattern filterPattern;
    private Label clearFilterTextControl;
    private Set<String> installedFeatures;
    private Image infoImage;
    private Cursor handCursor;
    private Color colorCategoryGradientStart;
    private Color colorCategoryGradientEnd;
    private Color colorDisabled;
    private ScrolledComposite bodyScrolledComposite;
    private boolean verifyUpdateSiteAvailability;
    private final Map<ConnectorDescriptorKind, Boolean> connectorDescriptorKindToVisibility = new HashMap<ConnectorDescriptorKind, Boolean>();
    private Dictionary<Object, Object> environment;
    private boolean complete;
    private final IRunnableContext context;
    private final IShellProvider shellProvider;
    private Control control;
    private String directoryUrl;
    private final SelectionProviderAdapter selectionProvider;
    private List<DiscoveryConnector> allConnectors;
    private int minimumHeight;
    private final List<ViewerFilter> filters;
    private boolean showInstalledFilterEnabled;
    private boolean showInstalled;

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    public DiscoveryViewer(IShellProvider shellProvider, IRunnableContext context) {
        ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
        int n = connectorDescriptorKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
            this.connectorDescriptorKindToVisibility.put(kind, true);
            ++n2;
        }
        this.filters = new ArrayList<ViewerFilter>();
        this.shellProvider = shellProvider;
        this.context = context;
        this.selectionProvider = new SelectionProviderAdapter();
        this.allConnectors = Collections.emptyList();
        this.disposables = new ArrayList<Resource>();
        this.setShowConnectorDescriptorKindFilter(true);
        this.setShowConnectorDescriptorTextFilter(true);
        this.setMinimumHeight(100);
        this.createEnvironment();
        this.setComplete(false);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    private void clearDisposables() {
        this.disposables.clear();
        this.h1Font = null;
        this.h2Font = null;
        this.infoImage = null;
        this.handCursor = null;
        this.colorCategoryGradientStart = null;
        this.colorCategoryGradientEnd = null;
    }

    private void clearFilterText() {
        this.filterText.setText("");
        this.filterTextChanged();
    }

    private Image computeIconImage(AbstractDiscoverySource discoverySource, Icon icon, int dimension, boolean fallback) {
        ImageDescriptor descriptor;
        Image image;
        URL resource;
        String imagePath;
        switch (dimension) {
            case 64: {
                imagePath = icon.getImage64();
                if (imagePath != null || !fallback) break;
            }
            case 48: {
                imagePath = icon.getImage48();
                if (imagePath != null || !fallback) break;
            }
            case 32: {
                imagePath = icon.getImage32();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (imagePath != null && imagePath.length() > 0 && (resource = discoverySource.getResource(imagePath)) != null && (image = (descriptor = ImageDescriptor.createFromURL((URL)resource)).createImage()) != null) {
            this.disposables.add((Resource)image);
            return image;
        }
        return null;
    }

    private IStatus computeStatus(InvocationTargetException e, String message) {
        Throwable cause = e.getCause();
        Object statusCause = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.mylyn.discovery.ui", cause.getMessage(), cause);
        if (statusCause.getMessage() != null) {
            message = NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_message_with_cause, (Object)message, (Object)statusCause.getMessage());
        }
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.discovery.ui", 0, new IStatus[]{statusCause}, message, cause);
        return status;
    }

    private void configureLook(Control control, Color background) {
        control.setBackground(background);
    }

    public void connectorDescriptorKindVisibilityUpdated() {
        this.createBodyContents();
    }

    public void createBodyContents() {
        Control[] controlArray = this.body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.clearDisposables();
        this.allConnectors = new ArrayList<DiscoveryConnector>();
        this.initializeCursors();
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        GridLayoutFactory.fillDefaults().applyTo(this.body);
        this.bodyScrolledComposite = new ScrolledComposite(this.body, 2816);
        this.configureLook((Control)this.bodyScrolledComposite, this.colorWhite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.bodyScrolledComposite);
        final Composite scrolledContents = new Composite((Composite)this.bodyScrolledComposite, 0);
        this.configureLook((Control)scrolledContents, this.colorWhite);
        scrolledContents.setRedraw(false);
        try {
            this.createDiscoveryContents(scrolledContents);
        }
        finally {
            scrolledContents.layout(true);
            scrolledContents.setRedraw(true);
        }
        Point size = scrolledContents.computeSize(this.body.getSize().x, -1, true);
        scrolledContents.setSize(size);
        this.bodyScrolledComposite.setExpandHorizontal(true);
        this.bodyScrolledComposite.setMinWidth(100);
        this.bodyScrolledComposite.setExpandVertical(true);
        this.bodyScrolledComposite.setMinHeight(1);
        this.bodyScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = scrolledContents.computeSize(((DiscoveryViewer)DiscoveryViewer.this).body.getSize().x - 20, -1, true);
                scrolledContents.setSize(size);
                DiscoveryViewer.this.bodyScrolledComposite.setMinHeight(size.y);
            }
        });
        this.bodyScrolledComposite.setContent((Control)scrolledContents);
        Dialog.applyDialogFont((Control)this.body);
        this.body.layout(true);
    }

    private Label createClearFilterTextControl(Composite filterContainer, final Text filterText) {
        final Image inactiveImage = CommonImages.FIND_CLEAR_DISABLED.createImage();
        final Image activeImage = CommonImages.FIND_CLEAR.createImage();
        final Image pressedImage = new Image((Device)filterContainer.getDisplay(), activeImage, 2);
        final Label clearButton = new Label(filterContainer, 0);
        clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        clearButton.setImage(inactiveImage);
        clearButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_clearButton_toolTip);
        clearButton.setBackground(filterContainer.getDisplay().getSystemColor(25));
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = clearButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }

            public void mouseDown(MouseEvent e) {
                clearButton.setImage(pressedImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                clearButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    clearButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton) {
                        DiscoveryViewer.this.clearFilterText();
                        filterText.setFocus();
                    }
                }
            }
        });
        clearButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                clearButton.setImage(activeImage);
            }

            public void mouseExit(MouseEvent e) {
                clearButton.setImage(inactiveImage);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        clearButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                inactiveImage.dispose();
                activeImage.dispose();
                pressedImage.dispose();
            }
        });
        clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ConnectorDiscoveryWizardMainPage_clearButton_accessibleListener;
            }
        });
        clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return clearButton;
    }

    public void createControl(Composite parent) {
        this.createRefreshJob();
        Composite container = new Composite(parent, 0);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DiscoveryViewer.this.refreshJob.cancel();
                if (DiscoveryViewer.this.disposables != null) {
                    for (Resource resource : DiscoveryViewer.this.disposables) {
                        resource.dispose();
                    }
                    DiscoveryViewer.this.clearDisposables();
                }
                if (DiscoveryViewer.this.discovery != null) {
                    DiscoveryViewer.this.discovery.dispose();
                }
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Composite header = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(header);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        if (this.isShowConnectorDescriptorKindFilter() || this.isShowConnectorDescriptorTextFilter()) {
            Composite filterContainer = new Composite(header, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterContainer);
            Label label = new Label(filterContainer, 0);
            label.setText(Messages.ConnectorDiscoveryWizardMainPage_filterLabel);
            if (this.isShowConnectorDescriptorTextFilter()) {
                Composite textFilterContainer;
                boolean nativeSearch = DiscoveryViewer.useNativeSearchField(header);
                if (nativeSearch) {
                    textFilterContainer = new Composite(filterContainer, 0);
                } else {
                    textFilterContainer = new Composite(filterContainer, 2048);
                    textFilterContainer.setBackground(header.getDisplay().getSystemColor(25));
                }
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textFilterContainer);
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textFilterContainer);
                this.filterText = nativeSearch ? new Text(textFilterContainer, 2436) : new Text(textFilterContainer, 4);
                this.filterText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        DiscoveryViewer.this.filterTextChanged();
                    }
                });
                if (nativeSearch) {
                    this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                            if (e.detail == 256) {
                                DiscoveryViewer.this.clearFilterText();
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.filterText);
                } else {
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
                    this.clearFilterTextControl = this.createClearFilterTextControl(textFilterContainer, this.filterText);
                    this.clearFilterTextControl.setVisible(false);
                }
            }
            if (this.isShowInstalledFilterEnabled()) {
                final Button checkbox = new Button(filterContainer, 32);
                checkbox.setSelection(false);
                checkbox.setText(Messages.DiscoveryViewer_Show_Installed);
                checkbox.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        DiscoveryViewer.this.setShowInstalled(checkbox.getSelection());
                    }
                });
            }
            if (this.isShowConnectorDescriptorKindFilter()) {
                ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
                int n = connectorDescriptorKindArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
                    final Button checkbox = new Button(filterContainer, 32);
                    checkbox.setSelection(this.isVisible(kind));
                    checkbox.setText(this.getFilterLabel(kind));
                    checkbox.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }

                        public void widgetSelected(SelectionEvent e) {
                            boolean selection = checkbox.getSelection();
                            DiscoveryViewer.this.setVisibility(kind, selection);
                            DiscoveryViewer.this.connectorDescriptorKindVisibilityUpdated();
                        }
                    });
                    ++n2;
                }
            }
            GridLayoutFactory.fillDefaults().numColumns(filterContainer.getChildren().length).applyTo(filterContainer);
        }
        this.body = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.minimumHeight).applyTo((Control)this.body);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
        if (this.body != null) {
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, minimumHeight).applyTo((Control)this.body);
        }
    }

    public static int getMinimumHeight() {
        return 100;
    }

    private void createDiscoveryContents(Composite container) {
        Color background = container.getBackground();
        if (this.discovery == null || this.isEmpty(this.discovery)) {
            Label helpTextControl;
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(container);
            boolean atLeastOneKindFiltered = false;
            ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
            int n = connectorDescriptorKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
                if (!this.isVisible(kind)) {
                    atLeastOneKindFiltered = true;
                    break;
                }
                ++n2;
            }
            if (this.filterPattern != null) {
                Link link = new Link(container, 64);
                link.setFont(container.getFont());
                link.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_withFilterText);
                link.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        DiscoveryViewer.this.clearFilterText();
                        DiscoveryViewer.this.filterText.setFocus();
                    }
                });
                helpTextControl = link;
            } else {
                Label helpText = new Label(container, 64);
                helpText.setFont(container.getFont());
                if (atLeastOneKindFiltered) {
                    helpText.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_filteredType);
                } else {
                    helpText.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_noFilter);
                }
                helpTextControl = helpText;
            }
            this.configureLook((Control)helpTextControl, background);
            GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)helpTextControl);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(container);
            ArrayList categories = new ArrayList(this.discovery.getCategories());
            Collections.sort(categories, new DiscoveryCategoryComparator());
            Composite categoryChildrenContainer = null;
            for (DiscoveryCategory category : categories) {
                Image image;
                if (this.isEmpty(category)) continue;
                GradientCanvas categoryHeaderContainer = new GradientCanvas(container, 0);
                categoryHeaderContainer.setSeparatorVisible(true);
                categoryHeaderContainer.setSeparatorAlignment(128);
                categoryHeaderContainer.setBackgroundGradient(new Color[]{this.colorCategoryGradientStart, this.colorCategoryGradientEnd}, new int[]{100}, true);
                categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.colorCategoryGradientStart);
                categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.colorCategoryGradientEnd);
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)categoryHeaderContainer);
                GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).equalWidth(false).applyTo((Composite)categoryHeaderContainer);
                Label iconLabel = new Label((Composite)categoryHeaderContainer, 0);
                if (category.getIcon() != null && (image = this.computeIconImage(category.getSource(), category.getIcon(), 48, true)) != null) {
                    iconLabel.setImage(image);
                }
                iconLabel.setBackground(null);
                GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
                Label nameLabel = new Label((Composite)categoryHeaderContainer, 0);
                nameLabel.setFont(this.h1Font);
                nameLabel.setText(category.getName());
                nameLabel.setBackground(null);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameLabel);
                if (this.hasTooltip(category)) {
                    ToolBar toolBar = new ToolBar((Composite)categoryHeaderContainer, 0x800000);
                    toolBar.setBackground(null);
                    ToolItem infoButton = new ToolItem(toolBar, 8);
                    infoButton.setImage(this.infoImage);
                    infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
                    this.hookTooltip((Control)toolBar, (Widget)infoButton, (Control)categoryHeaderContainer, (Control)nameLabel, category.getSource(), category.getOverview(), null);
                    GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
                } else {
                    new Label((Composite)categoryHeaderContainer, 0).setText(" ");
                }
                Label description = new Label((Composite)categoryHeaderContainer, 64);
                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)description);
                description.setBackground(null);
                description.setText(category.getDescription());
                categoryChildrenContainer = new Composite(container, 0);
                this.configureLook((Control)categoryChildrenContainer, background);
                GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)categoryChildrenContainer);
                GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(categoryChildrenContainer);
                int numChildren = 0;
                ArrayList connectors = new ArrayList(category.getConnectors());
                Collections.sort(connectors, new DiscoveryConnectorComparator((ConnectorCategory)category));
                for (DiscoveryConnector connector : connectors) {
                    if (this.isFiltered((ConnectorDescriptor)connector)) continue;
                    if (++numChildren > 1) {
                        Composite border = new Composite(categoryChildrenContainer, 0);
                        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)border);
                        GridLayoutFactory.fillDefaults().applyTo(border);
                        border.addPaintListener((PaintListener)new ConnectorBorderPaintListener());
                    }
                    ConnectorDescriptorItemUi itemUi = new ConnectorDescriptorItemUi(connector, categoryChildrenContainer, background);
                    itemUi.updateAvailability();
                    this.allConnectors.add(connector);
                }
            }
            Composite border = new Composite(categoryChildrenContainer, 0);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)border);
            GridLayoutFactory.fillDefaults().applyTo(border);
            border.addPaintListener((PaintListener)new ConnectorBorderPaintListener());
        }
        container.layout(true);
        container.redraw();
    }

    private void createEnvironment() {
        this.environment = new Hashtable<Object, Object>(System.getProperties());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.tasks.core");
        String versionString = (String)bundle.getHeaders().get("Bundle-Version");
        if (versionString != null) {
            Version version = new Version(versionString);
            this.environment.put("org.eclipse.mylyn.version", version.toString());
            this.environment.put("org.eclipse.mylyn.version.major", version.getMajor());
            this.environment.put("org.eclipse.mylyn.version.minor", version.getMinor());
            this.environment.put("org.eclipse.mylyn.version.micro", version.getMicro());
        }
    }

    protected Pattern createPattern(String filterText) {
        if (filterText == null || filterText.length() == 0) {
            return null;
        }
        String regex = filterText;
        regex.replace("\\", "\\\\").replace("?", ".").replace("*", ".*?");
        return Pattern.compile(regex, 34);
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DiscoveryViewer.this.filterText.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = DiscoveryViewer.this.filterText.getText();
                text = text.trim();
                if (!DiscoveryViewer.this.previousFilterText.equals(text)) {
                    DiscoveryViewer.this.previousFilterText = text;
                    DiscoveryViewer.this.filterPattern = DiscoveryViewer.this.createPattern(DiscoveryViewer.this.previousFilterText);
                    if (DiscoveryViewer.this.clearFilterTextControl != null) {
                        DiscoveryViewer.this.clearFilterTextControl.setVisible(DiscoveryViewer.this.filterPattern != null);
                    }
                    DiscoveryViewer.this.createBodyContents();
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    private void discoveryUpdated(boolean wasCancelled) {
        this.createBodyContents();
        if (this.discovery != null && !wasCancelled) {
            int categoryWithConnectorCount = 0;
            for (DiscoveryCategory category : this.discovery.getCategories()) {
                categoryWithConnectorCount += category.getConnectors().size();
            }
            if (categoryWithConnectorCount == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound, (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound_description);
            }
        }
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private boolean filterMatches(String text) {
        return text != null && this.filterPattern.matcher(text).find();
    }

    private void filterTextChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    public Control getControl() {
        return this.control;
    }

    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    public ConnectorDiscovery getDiscovery() {
        return this.discovery;
    }

    public Dictionary<Object, Object> getEnvironment() {
        return this.environment;
    }

    private String getFilterLabel(ConnectorDescriptorKind kind) {
        switch (kind) {
            case DOCUMENT: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_documents;
            }
            case TASK: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_tasks;
            }
            case VCS: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_vcs;
            }
        }
        throw new IllegalStateException(kind.name());
    }

    public String getFilterText() {
        return this.filterText.getText();
    }

    public List<ConnectorDescriptor> getInstallableConnectors() {
        return this.installableConnectors;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.selectionProvider.getSelection();
    }

    private Shell getShell() {
        return this.shellProvider.getShell();
    }

    public boolean getVerifyUpdateSiteAvailability() {
        return this.verifyUpdateSiteAvailability;
    }

    private boolean hasTooltip(DiscoveryCategory category) {
        return category.getOverview() != null && category.getOverview().getSummary() != null && category.getOverview().getSummary().length() > 0;
    }

    private boolean hasTooltip(DiscoveryConnector connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    private void hookTooltip(Control parent, Widget tipActivator, final Control exitControl, final Control titleControl, AbstractDiscoverySource source, Overview overview, Image image) {
        final OverviewToolTip toolTip = new OverviewToolTip(parent, source, overview, image);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        toolTip.show(titleControl);
                        break;
                    }
                    case 12: 
                    case 37: {
                        toolTip.hide();
                    }
                }
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        if (image != null) {
            tipActivator.addListener(32, listener);
        }
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                toolTip.show(titleControl);
            }
        };
        tipActivator.addListener(13, selectionListener);
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        if (containerBounds.contains(Display.getCurrent().getCursorLocation())) break;
                        toolTip.hide();
                    }
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }

    private void initializeColors() {
        ColorRegistry colorRegistry;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        if (this.colorWhite == null) {
            colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_WHITE)) {
                colorRegistry.put(COLOR_WHITE, new RGB(255, 255, 255));
            }
            this.colorWhite = colorRegistry.get(COLOR_WHITE);
        }
        if (this.colorDisabled == null) {
            colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_DARK_GRAY)) {
                colorRegistry.put(COLOR_DARK_GRAY, new RGB(105, 105, 105));
            }
            this.colorDisabled = colorRegistry.get(COLOR_DARK_GRAY);
        }
        if (this.colorCategoryGradientStart == null) {
            this.colorCategoryGradientStart = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
            this.colorCategoryGradientEnd = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        }
    }

    private void initializeCursors() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)this.getShell().getDisplay(), 21);
            this.disposables.add((Resource)this.handCursor);
        }
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }

    private void initializeFonts() {
        if (this.h2Font == null) {
            this.h2Font = new Font((Device)Display.getCurrent(), this.createFontDescriptor(1, 1.25f).getFontData());
            this.disposables.add((Resource)this.h2Font);
        }
        if (this.h1Font == null) {
            this.h1Font = new Font((Device)Display.getCurrent(), this.createFontDescriptor(1, 1.35f).getFontData());
            this.disposables.add((Resource)this.h1Font);
        }
    }

    private void initializeImages() {
        if (this.infoImage == null) {
            this.infoImage = DiscoveryImages.MESSAGE_INFO.createImage();
            this.disposables.add((Resource)this.infoImage);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    private boolean isEmpty(ConnectorDiscovery discovery) {
        for (DiscoveryCategory category : discovery.getCategories()) {
            if (this.isEmpty(category)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmpty(DiscoveryCategory category) {
        if (category.getConnectors().isEmpty()) {
            return true;
        }
        for (ConnectorDescriptor descriptor : category.getConnectors()) {
            if (this.isFiltered(descriptor)) continue;
            return false;
        }
        return true;
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        this.filters.remove(filter);
    }

    private boolean isFiltered(ConnectorDescriptor descriptor) {
        boolean kindFiltered = true;
        for (ConnectorDescriptorKind kind : descriptor.getKind()) {
            if (!this.isVisible(kind)) continue;
            kindFiltered = false;
            break;
        }
        if (kindFiltered) {
            return true;
        }
        if (!this.showInstalled && descriptor.isInstalled()) {
            return true;
        }
        if (!(this.filterPattern == null || this.filterMatches(descriptor.getName()) || this.filterMatches(descriptor.getDescription()) || this.filterMatches(descriptor.getProvider()) || this.filterMatches(descriptor.getLicense()))) {
            return true;
        }
        for (ViewerFilter filter : this.filters) {
            if (filter.select(null, null, (Object)descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isShowConnectorDescriptorKindFilter() {
        return this.showConnectorDescriptorKindFilter;
    }

    public boolean isShowConnectorDescriptorTextFilter() {
        return this.showConnectorDescriptorTextFilter;
    }

    public boolean isShowInstalled() {
        return this.showInstalled;
    }

    public boolean isShowInstalledFilterEnabled() {
        return this.showInstalledFilterEnabled;
    }

    public boolean isVisible(ConnectorDescriptorKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        return this.connectorDescriptorKindToVisibility.get(kind);
    }

    private void modifySelection(DiscoveryConnector connector, boolean selected) {
        this.modifySelectionInternal(connector, selected);
        this.updateState();
    }

    private void modifySelectionInternal(DiscoveryConnector connector, boolean selected) {
        connector.setSelected(selected);
        if (selected) {
            this.installableConnectors.add((ConnectorDescriptor)connector);
        } else {
            this.installableConnectors.remove(connector);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    protected void setControl(Control control) {
        this.control = control;
    }

    public void setDirectoryUrl(String directoryUrl) {
        this.directoryUrl = directoryUrl;
    }

    public void setEnvironment(Dictionary<Object, Object> environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }

    public void setFilterText(String text) {
        Assert.isNotNull((Object)text);
        this.filterText.setText(text);
        this.filterTextChanged();
    }

    public void setSelection(IStructuredSelection selection) {
        HashSet<ConnectorDescriptor> selected = new HashSet<ConnectorDescriptor>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object descriptor = objectArray[n2];
            if (descriptor instanceof ConnectorDescriptor) {
                selected.add((ConnectorDescriptor)descriptor);
            }
            ++n2;
        }
        for (DiscoveryConnector connector : this.allConnectors) {
            this.modifySelectionInternal(connector, selected.contains(connector));
        }
        this.updateState();
    }

    public void setShowConnectorDescriptorKindFilter(boolean showConnectorDescriptorKindFilter) {
        this.showConnectorDescriptorKindFilter = showConnectorDescriptorKindFilter;
    }

    public void setShowConnectorDescriptorTextFilter(boolean showConnectorDescriptorTextFilter) {
        this.showConnectorDescriptorTextFilter = showConnectorDescriptorTextFilter;
    }

    public void setShowInstalled(boolean showInstalled) {
        this.showInstalled = showInstalled;
        this.connectorDescriptorKindVisibilityUpdated();
    }

    public void setShowInstalledFilterEnabled(boolean showInstalledFilter) {
        this.showInstalledFilterEnabled = showInstalledFilter;
    }

    public void setVerifyUpdateSiteAvailability(boolean verifyUpdateSiteAvailability) {
        this.verifyUpdateSiteAvailability = verifyUpdateSiteAvailability;
    }

    public void setVisibility(ConnectorDescriptorKind kind, boolean visible) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        this.connectorDescriptorKindToVisibility.put(kind, visible);
    }

    public void updateDiscovery() {
        IStatus status;
        final Dictionary<Object, Object> environment = this.getEnvironment();
        boolean wasCancelled = false;
        try {
            final IStatus[] result = new IStatus[1];
            this.context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (DiscoveryViewer.this.installedFeatures == null) {
                        DiscoveryViewer.this.installedFeatures = DiscoveryViewer.this.getInstalledFeatures(monitor);
                    }
                    ConnectorDiscovery connectorDiscovery = new ConnectorDiscovery();
                    connectorDiscovery.getDiscoveryStrategies().add(new BundleDiscoveryStrategy());
                    if (DiscoveryViewer.this.directoryUrl != null) {
                        RemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
                        remoteDiscoveryStrategy.setDirectoryUrl(DiscoveryViewer.this.directoryUrl);
                        connectorDiscovery.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
                    }
                    connectorDiscovery.setEnvironment(environment);
                    connectorDiscovery.setVerifyUpdateSiteAvailability(false);
                    try {
                        result[0] = connectorDiscovery.performDiscovery(monitor);
                    }
                    finally {
                        DiscoveryViewer.this.discovery = connectorDiscovery;
                        DiscoveryViewer.this.postDiscovery(connectorDiscovery);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            });
            if (result[0] != null && !result[0].isOK()) {
                StatusManager.getManager().handle(result[0], 7);
            }
        }
        catch (InvocationTargetException e) {
            status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
            StatusManager.getManager().handle(status, 7);
        }
        catch (InterruptedException interruptedException) {
            wasCancelled = true;
        }
        if (this.body.isDisposed()) {
            return;
        }
        if (this.discovery != null) {
            this.discoveryUpdated(wasCancelled);
            if (this.verifyUpdateSiteAvailability && !this.discovery.getConnectors().isEmpty()) {
                try {
                    this.context.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            DiscoveryViewer.this.discovery.verifySiteAvailability(monitor);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
                    StatusManager.getManager().handle(status, 7);
                }
                catch (InterruptedException interruptedException) {
                    wasCancelled = true;
                }
            }
            if (this.body.isDisposed()) {
                return;
            }
            this.createBodyContents();
        }
        this.body.setData("discoveryComplete", (Object)"true");
    }

    private void updateState() {
        this.setComplete(!this.installableConnectors.isEmpty());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.getInstallableConnectors()));
    }

    protected void postDiscovery(ConnectorDiscovery connectorDiscovery) {
        for (DiscoveryConnector connector : connectorDiscovery.getConnectors()) {
            connector.setInstalled(this.installedFeatures != null && this.installedFeatures.containsAll(connector.getInstallableUnits()));
        }
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) throws InterruptedException {
        return DiscoveryUi.createInstallJob().getInstalledFeatures(monitor);
    }

    public class ConnectorBorderPaintListener
    implements PaintListener {
        public void paintControl(PaintEvent e) {
            Composite composite = (Composite)e.widget;
            Rectangle bounds = composite.getBounds();
            GC gc = e.gc;
            gc.setLineStyle(3);
            gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        }
    }

    private class ConnectorDescriptorItemUi
    implements PropertyChangeListener,
    Runnable {
        private final DiscoveryConnector connector;
        private final Button checkbox;
        private final Label iconLabel;
        private final Label nameLabel;
        private ToolItem infoButton;
        private final Link providerLabel;
        private final Label description;
        private final Composite checkboxContainer;
        private final Composite connectorContainer;
        private final Display display;
        private Image iconImage;

        public ConnectorDescriptorItemUi(final DiscoveryConnector connector, Composite categoryChildrenContainer, Color background) {
            this.display = categoryChildrenContainer.getDisplay();
            this.connector = connector;
            connector.addPropertyChangeListener((PropertyChangeListener)this);
            this.connectorContainer = new Composite(categoryChildrenContainer, 0);
            DiscoveryViewer.this.configureLook((Control)this.connectorContainer, background);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.connectorContainer);
            GridLayout layout = new GridLayout(4, false);
            layout.marginLeft = 7;
            layout.marginTop = 2;
            layout.marginBottom = 2;
            this.connectorContainer.setLayout((Layout)layout);
            this.checkboxContainer = new Composite(this.connectorContainer, 0);
            DiscoveryViewer.this.configureLook((Control)this.checkboxContainer, background);
            GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)this.checkboxContainer);
            GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(2).applyTo(this.checkboxContainer);
            this.checkbox = new Button(this.checkboxContainer, 32);
            this.checkbox.setText(" ");
            this.checkbox.setData("connectorId", (Object)connector.getId());
            this.checkbox.setVisible(connector.isInstallable());
            DiscoveryViewer.this.configureLook((Control)this.checkbox, background);
            this.checkbox.setSelection(DiscoveryViewer.this.installableConnectors.contains(connector));
            this.checkbox.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    DiscoveryViewer.this.bodyScrolledComposite.showControl((Control)ConnectorDescriptorItemUi.this.connectorContainer);
                }
            });
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
            this.iconLabel = new Label(this.checkboxContainer, 0);
            DiscoveryViewer.this.configureLook((Control)this.iconLabel, background);
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.iconLabel);
            if (connector.getIcon() != null) {
                this.iconImage = DiscoveryViewer.this.computeIconImage(connector.getSource(), connector.getIcon(), 32, false);
                if (this.iconImage != null) {
                    this.iconLabel.setImage(this.iconImage);
                }
            }
            this.nameLabel = new Label(this.connectorContainer, 0);
            DiscoveryViewer.this.configureLook((Control)this.nameLabel, background);
            GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
            this.nameLabel.setFont(DiscoveryViewer.this.h2Font);
            if (connector.isInstalled()) {
                this.nameLabel.setText(NLS.bind((String)Messages.DiscoveryViewer_X_installed, (Object)connector.getName()));
            } else {
                this.nameLabel.setText(connector.getName());
            }
            this.providerLabel = new Link(this.connectorContainer, 131072);
            DiscoveryViewer.this.configureLook((Control)this.providerLabel, background);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.providerLabel);
            if (connector.getCertification() != null) {
                this.providerLabel.setText(NLS.bind((String)Messages.DiscoveryViewer_Certification_Label0, (Object[])new String[]{connector.getProvider(), connector.getLicense(), connector.getCertification().getName()}));
                if (connector.getCertification().getUrl() != null) {
                    this.providerLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            BrowserUtil.openUrl((String)connector.getCertification().getUrl(), (int)128);
                        }
                    });
                }
                Overview overview = new Overview();
                overview.setSummary(connector.getCertification().getDescription());
                overview.setUrl(connector.getCertification().getUrl());
                Image image = DiscoveryViewer.this.computeIconImage(connector.getSource(), connector.getCertification().getIcon(), 48, true);
                DiscoveryViewer.this.hookTooltip((Control)this.providerLabel, (Widget)this.providerLabel, (Control)this.connectorContainer, (Control)this.providerLabel, connector.getSource(), overview, image);
            } else {
                this.providerLabel.setText(NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_provider_and_license, (Object)connector.getProvider(), (Object)connector.getLicense()));
            }
            if (DiscoveryViewer.this.hasTooltip(connector)) {
                ToolBar toolBar = new ToolBar(this.connectorContainer, 0x800000);
                toolBar.setBackground(background);
                this.infoButton = new ToolItem(toolBar, 8);
                this.infoButton.setImage(DiscoveryViewer.this.infoImage);
                this.infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
                DiscoveryViewer.this.hookTooltip((Control)toolBar, (Widget)this.infoButton, (Control)this.connectorContainer, (Control)this.nameLabel, connector.getSource(), connector.getOverview(), null);
                GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
            } else {
                Label label = new Label(this.connectorContainer, 0);
                label.setText(" ");
                DiscoveryViewer.this.configureLook((Control)label, background);
            }
            this.description = new Label(this.connectorContainer, 64);
            DiscoveryViewer.this.configureLook((Control)this.description, background);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(100, -1).applyTo((Control)this.description);
            String descriptionText = connector.getDescription();
            int maxDescriptionLength = 162;
            if (descriptionText.length() > maxDescriptionLength) {
                descriptionText = descriptionText.substring(0, maxDescriptionLength);
            }
            this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " "));
            this.providerLabel.setForeground(DiscoveryViewer.this.colorDisabled);
            this.checkbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ConnectorDescriptorItemUi.this.checkbox.getSelection();
                    ConnectorDescriptorItemUi.this.maybeModifySelection(selected);
                }
            });
            MouseAdapter connectorItemMouseListener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    boolean selected;
                    boolean bl = selected = !ConnectorDescriptorItemUi.this.checkbox.getSelection();
                    if (ConnectorDescriptorItemUi.this.maybeModifySelection(selected)) {
                        ConnectorDescriptorItemUi.this.checkbox.setSelection(selected);
                    }
                }
            };
            this.checkboxContainer.addMouseListener((MouseListener)connectorItemMouseListener);
            this.connectorContainer.addMouseListener((MouseListener)connectorItemMouseListener);
            this.iconLabel.addMouseListener((MouseListener)connectorItemMouseListener);
            this.nameLabel.addMouseListener((MouseListener)connectorItemMouseListener);
            this.description.addMouseListener((MouseListener)connectorItemMouseListener);
        }

        protected boolean maybeModifySelection(boolean selected) {
            if (selected) {
                if (this.connector.isInstalled()) {
                    MessageDialog.openWarning((Shell)DiscoveryViewer.this.shellProvider.getShell(), (String)Messages.DiscoveryViewer_Install_Connector_Title, (String)NLS.bind((String)Messages.DiscoveryViewer_Already_installed_Error, (Object)this.connector.getName()));
                    return false;
                }
                if (!this.connector.isInstallable()) {
                    if (this.connector.getInstallMessage() != null) {
                        MessageDialog.openInformation((Shell)DiscoveryViewer.this.shellProvider.getShell(), (String)Messages.DiscoveryViewer_Install_Connector_Title, (String)this.connector.getInstallMessage());
                    }
                    return false;
                }
                if (this.connector.getAvailable() != null && !this.connector.getAvailable().booleanValue()) {
                    MessageDialog.openWarning((Shell)DiscoveryViewer.this.shellProvider.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_warningTitleConnectorUnavailable, (String)NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_warningMessageConnectorUnavailable, (Object)this.connector.getName()));
                    return false;
                }
            }
            DiscoveryViewer.this.modifySelection(this.connector, selected);
            return true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.display.asyncExec((Runnable)this);
        }

        @Override
        public void run() {
            if (!this.connectorContainer.isDisposed()) {
                this.updateAvailability();
            }
        }

        public void updateAvailability() {
            boolean enabled = !this.connector.isInstalled() && (this.connector.getAvailable() == null || this.connector.getAvailable() != false);
            this.checkbox.setEnabled(enabled);
            this.nameLabel.setEnabled(enabled);
            this.providerLabel.setEnabled(enabled);
            this.description.setEnabled(enabled);
            Color foreground = enabled ? this.connectorContainer.getForeground() : DiscoveryViewer.this.colorDisabled;
            this.nameLabel.setForeground(foreground);
            this.description.setForeground(foreground);
            if (this.iconImage != null) {
                this.iconLabel.setImage(this.iconImage);
            }
        }
    }
}

