/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.Messages;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteNotification;
import org.eclipse.osgi.util.NLS;

public class RemoteEmfConsumer<EParentObjectType extends EObject, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>
extends AbstractRemoteConsumer {
    private final AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> factory;
    private RemoteKeyType remoteKey;
    private RemoteType remoteObject;
    private final EParentObjectType parentObject;
    private EObjectType modelObject;
    private LocalKeyType localKey;
    private final Collection<RemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>> remoteEmfObservers;
    private boolean pulling;
    private boolean retrieving;
    boolean userJob;
    boolean systemJob;
    boolean asynchronous = true;
    private IStatus lastStatus = Status.OK_STATUS;

    RemoteEmfConsumer(AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> factory, EParentObjectType parent, EObjectType modelObject, LocalKeyType localKey, RemoteType remoteObject, RemoteKeyType remoteKey) {
        this.parentObject = parent;
        this.modelObject = modelObject;
        this.remoteObject = remoteObject;
        this.remoteKey = remoteKey;
        this.localKey = localKey;
        this.factory = factory;
        if (remoteKey == null && remoteObject != null) {
            this.remoteKey = factory.getRemoteKey(remoteObject);
        }
        if (localKey == null && modelObject != null) {
            this.localKey = factory.getLocalKey(null, modelObject);
        }
        this.remoteEmfObservers = new CopyOnWriteArrayList<RemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>>();
    }

    public void notifyObservers(final RemoteNotification notification) {
        this.getFactory().getService().modelExec(new Runnable(){

            @Override
            public void run() {
                for (RemoteEmfObserver listener : RemoteEmfConsumer.this.remoteEmfObservers) {
                    switch (notification.getType()) {
                        case 1: {
                            listener.updated(notification.isModification());
                            break;
                        }
                        case 2: {
                            listener.updating();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void pull(boolean force, IProgressMonitor monitor) throws CoreException {
        this.pulling = true;
        if (this.remoteObject != null && this.remoteKey == null) {
            this.remoteKey = this.factory.getRemoteKey(this.remoteObject);
        }
        if (this.remoteKey == null && this.localKey != null) {
            this.remoteKey = this.factory.getRemoteKeyForLocalKey(this.parentObject, this.localKey);
        }
        if ((this.factory.isPullNeeded(this.parentObject, this.modelObject, this.remoteObject) || force) && this.remoteKey != null) {
            this.notifyObservers(RemoteNotification.createUpdatingNotification());
            try {
                this.remoteObject = this.factory.pull(this.parentObject, this.remoteKey, monitor);
                if (this.localKey == null) {
                    this.localKey = this.factory.getLocalKeyForRemoteObject(this.remoteObject);
                }
                this.pulling = false;
            }
            catch (CoreException e) {
                this.lastStatus = e.getStatus();
                this.notifyObservers(RemoteNotification.createUpdateNotification(false));
                throw e;
            }
            this.lastStatus = Status.OK_STATUS;
        }
        this.pulling = false;
    }

    public boolean isPulling() {
        return this.pulling;
    }

    @Override
    public void applyModel(boolean force) {
        EReference reference = this.factory.getParentReference();
        boolean modified = false;
        if (this.remoteObject != null) {
            if (this.modelObject == null || this.factory.isCreateModelNeeded(this.parentObject, this.modelObject) || reference.isMany() && ((Collection)this.parentObject.eGet((EStructuralFeature)reference)).size() == 0) {
                modified = true;
                this.modelObject = this.factory.createModel(this.parentObject, this.remoteObject);
                if (reference.isMany()) {
                    if (this.modelObject instanceof Collection) {
                        ((EList)this.parentObject.eGet((EStructuralFeature)reference)).addAll((Collection)this.modelObject);
                    } else {
                        ((EList)this.parentObject.eGet((EStructuralFeature)reference)).add(this.modelObject);
                    }
                } else {
                    this.parentObject.eSet((EStructuralFeature)reference, this.modelObject);
                }
                if (this.modelObject instanceof EObject) {
                    ((EObject)this.modelObject).eSet((EStructuralFeature)this.factory.getLocalKeyAttribute(), this.factory.getLocalKeyForRemoteObject(this.remoteObject));
                }
            }
            if (this.factory.isUpdateModelNeeded(this.parentObject, this.modelObject, this.remoteObject) || force) {
                modified |= this.factory.updateModel(this.parentObject, this.modelObject, this.remoteObject);
            }
        }
        this.retrieving = false;
        this.notifyObservers(RemoteNotification.createUpdateNotification(modified));
    }

    public boolean isRetrieving() {
        return this.retrieving;
    }

    public void retrieve(boolean force) {
        if (this.retrieving) {
            return;
        }
        this.retrieving = true;
        this.getFactory().getService().retrieve(this, force || !this.lastStatus.isOK());
    }

    @Override
    public void notifyDone(IStatus status) {
        this.retrieving = false;
    }

    @Override
    public void dispose() {
        this.retrieving = false;
        this.remoteEmfObservers.clear();
        this.getFactory().removeConsumer(this);
        if (this.getModelObject() instanceof EObject) {
            this.getFactory().getFactoryProvider().close((EObject)this.getModelObject());
        }
        this.modelObject = null;
        this.remoteObject = null;
    }

    public void addObserver(RemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType> observer) {
        if (observer != null) {
            RemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType> remoteEmfObserver = observer;
            if (remoteEmfObserver.getConsumer() != null && remoteEmfObserver.getConsumer() != this) {
                remoteEmfObserver.getConsumer().removeObserver(remoteEmfObserver);
            }
            remoteEmfObserver.internalSetConsumer(this);
            this.remoteEmfObservers.add(observer);
        }
    }

    public void removeObserver(RemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType> observer) {
        if (observer != null) {
            RemoteEmfObserver remoteEmfObserver = observer;
            if (remoteEmfObserver.getConsumer() == this) {
                remoteEmfObserver.internalSetConsumer(null);
            }
            this.remoteEmfObservers.remove(observer);
        }
        this.release();
    }

    public void release() {
        if (this.remoteEmfObservers.size() == 0) {
            this.dispose();
        }
    }

    public void updateObservers() {
        this.notifyObservers(RemoteNotification.createUpdateNotification(false));
    }

    public AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getFactory() {
        return this.factory;
    }

    public void open() {
        this.getFactory().open(this.parentObject, this.localKey);
    }

    public void save() {
        if (this.getModelObject() instanceof EObject) {
            this.getFactory().getFactoryProvider().save();
            this.getFactory().getFactoryProvider().save((EObject)this.getModelObject());
        }
    }

    public EParentObjectType getParentObject() {
        return this.parentObject;
    }

    public EObjectType getModelObject() {
        return this.modelObject;
    }

    public LocalKeyType getLocalKey() {
        if (this.localKey != null) {
            return this.localKey;
        }
        if (this.remoteKey != null) {
            return this.getFactory().getLocalKeyForRemoteKey(this.remoteKey);
        }
        if (this.remoteObject != null) {
            return this.getFactory().getLocalKeyForRemoteObject(this.remoteObject);
        }
        return null;
    }

    public RemoteKeyType getRemoteKey() {
        return this.remoteKey;
    }

    public RemoteType getRemoteObject() {
        return this.remoteObject;
    }

    void setRemoteObject(RemoteType remoteObject) {
        if (!this.factory.getLocalKeyForRemoteObject(remoteObject).equals(this.getLocalKey())) {
            throw new RuntimeException("Internal Error. Tried to set a remote object that doesn't match existing local key or object.");
        }
        this.remoteObject = remoteObject;
    }

    void setRemoteKey(RemoteKeyType remoteKey) {
        if (!this.factory.getLocalKeyForRemoteKey(remoteKey).equals(this.getLocalKey())) {
            throw new RuntimeException("Internal Error. Tried to set a remote object that doesn't match existing local key or object.");
        }
        this.remoteKey = remoteKey;
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)Messages.RemoteEmfConsumer_Retrieving_X, (Object)this.factory.getModelDescription(this.getParentObject(), this.getModelObject(), this.getLocalKey()));
    }

    @Override
    public boolean isUserJob() {
        return this.userJob;
    }

    public void setUiJob(boolean userJob) {
        this.userJob = userJob;
    }

    @Override
    public boolean isSystemJob() {
        return this.systemJob;
    }

    public void setSystemJob(boolean systemJob) {
        this.systemJob = systemJob;
    }

    @Override
    public boolean isAsynchronous() {
        return this.getFactory().isAsynchronous() && this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public IStatus getStatus() {
        return this.lastStatus;
    }
}

