/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class MarkupToEclipseTocTest
extends TestCase {
    private MarkupToEclipseToc markupToEclipseToc;

    public void setUp() {
        this.markupToEclipseToc = new MarkupToEclipseToc();
        this.markupToEclipseToc.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
    }

    public void basic() throws Exception {
        this.markupToEclipseToc.setBookTitle("Test");
        this.markupToEclipseToc.setHtmlFile("Test.html");
        String toc = this.markupToEclipseToc.parse("h1. title1\n\nContent para 1\n\nh1. title2\n\nMore content\n\nh2. Nested title\n\nnested content");
        TestUtil.println("Eclipse TOC: " + toc);
        this.assertEqualsResource("basic.xml", toc);
    }

    public void testCopyrightNotice() {
        this.markupToEclipseToc.setCopyrightNotice("Copyright (c) 2012 David Green");
        String toc = this.markupToEclipseToc.parse("h1. title");
        TestUtil.println("TOC: " + toc);
        MarkupToEclipseTocTest.assertTrue((String)("content: " + toc), (boolean)toc.contains("<!-- Copyright (c) 2012 David Green -->"));
    }

    public void testEmitAnchorsDefaultFalse() {
        MarkupToEclipseTocTest.assertEquals((int)-1, (int)this.markupToEclipseToc.getAnchorLevel());
    }

    public void testEmitAnchorsLevel0() {
        this.markupToEclipseToc.setBookTitle("Test");
        this.markupToEclipseToc.setHtmlFile("Test.html");
        this.markupToEclipseToc.setAnchorLevel(0);
        String toc = this.markupToEclipseToc.parse("h1. Top");
        TestUtil.println("TOC: " + toc);
        this.assertEqualsResource("testEmitAnchorsLevel0.xml", toc);
    }

    public void testEmitAnchorsLevel1() {
        this.markupToEclipseToc.setBookTitle("Test");
        this.markupToEclipseToc.setHtmlFile("Test.html");
        this.markupToEclipseToc.setAnchorLevel(1);
        String toc = this.markupToEclipseToc.parse("h1. First\n\nh2. Second\n\nh1. Third");
        TestUtil.println("TOC: " + toc);
        this.assertEqualsResource("testEmitAnchorsLevel1.xml", toc);
    }

    private void assertEqualsResource(String resourceName, String actualValue) {
        String expectedValue = this.loadResource(resourceName);
        MarkupToEclipseTocTest.assertEquals((String)expectedValue, (String)actualValue);
    }

    private String loadResource(String resourceName) {
        String name = String.valueOf(MarkupToEclipseTocTest.class.getSimpleName()) + "." + resourceName;
        URL resource = MarkupToEclipseTocTest.class.getResource(name);
        Preconditions.checkState((resource != null ? 1 : 0) != 0, (String)"Cannot load resource %s", (Object[])new Object[]{name});
        try {
            return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

