/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.HeadingProjectionAnnotation;
import org.eclipse.mylyn.internal.wikitext.ui.editor.IFoldingStructure;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.swt.graphics.Point;

class FoldingStructure
implements IFoldingStructure {
    final ProjectionViewer viewer;
    final ITextOperationTarget textOperationTarget;

    public FoldingStructure(MarkupEditor editor) {
        this.viewer = (ProjectionViewer)editor.getViewer();
        this.textOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
    }

    @Override
    public void collapseAll(boolean collapseRegionContainingCaret) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (collapseRegionContainingCaret) {
            this.textOperationTarget.doOperation(21);
        } else {
            this.operateOnAnnotations(new AbstractItemsAnnotationOperation(new ArrayList()){

                @Override
                public boolean operateOnSelected(HeadingProjectionAnnotation annotation) {
                    return this.operateOnUnselected(annotation);
                }

                @Override
                public boolean operateOnUnselected(HeadingProjectionAnnotation annotation) {
                    if (!annotation.isCollapsed()) {
                        annotation.markCollapsed();
                        return true;
                    }
                    return false;
                }
            }, collapseRegionContainingCaret);
        }
    }

    @Override
    public void collapseElements(Collection<OutlineItem> items, boolean collapseRegionContainingCaret) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (items == null || items.isEmpty()) {
            return;
        }
        this.operateOnAnnotations(new AbstractItemsAnnotationOperation(items){

            @Override
            public boolean operateOnSelected(HeadingProjectionAnnotation annotation) {
                if (!annotation.isCollapsed()) {
                    annotation.markCollapsed();
                    return true;
                }
                return false;
            }
        }, collapseRegionContainingCaret);
    }

    @Override
    public void expandAll() {
        if (!this.isFoldingEnabled()) {
            return;
        }
        this.textOperationTarget.doOperation(20);
    }

    @Override
    public void expandElements(Collection<OutlineItem> items) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (items == null || items.isEmpty()) {
            return;
        }
        this.operateOnAnnotations(new AbstractItemsAnnotationOperation(items){

            @Override
            public boolean operateOnSelected(HeadingProjectionAnnotation annotation) {
                if (annotation.isCollapsed()) {
                    annotation.markExpanded();
                    return true;
                }
                return false;
            }
        }, true);
    }

    @Override
    public void expandElementsExclusive(Collection<OutlineItem> items, boolean collapseRegionContainingCaret) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (items == null || items.isEmpty()) {
            this.collapseAll(collapseRegionContainingCaret);
            return;
        }
        this.operateOnAnnotations(new AbstractItemsAnnotationOperation(items){

            @Override
            public boolean operateOnSelected(HeadingProjectionAnnotation annotation) {
                if (annotation.isCollapsed()) {
                    annotation.markExpanded();
                    return true;
                }
                return false;
            }

            @Override
            public boolean operateOnUnselected(HeadingProjectionAnnotation annotation) {
                if (!annotation.isCollapsed()) {
                    annotation.markCollapsed();
                    return true;
                }
                return false;
            }
        }, collapseRegionContainingCaret);
    }

    public void operateOnAnnotations(AnnotationOperation operation, boolean collapseRegionIncludingCaret) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        Point selectedRange = this.viewer.getSelectedRange();
        Position selectedPosition = selectedRange == null ? null : new Position(selectedRange.x, selectedRange.y);
        boolean updateSelectedRange = false;
        ProjectionAnnotationModel annotationModel = this.viewer.getProjectionAnnotationModel();
        ArrayList<HeadingProjectionAnnotation> modifications = null;
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            HeadingProjectionAnnotation projectionAnnotation;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof HeadingProjectionAnnotation) || !operation.operate(projectionAnnotation = (HeadingProjectionAnnotation)annotation)) continue;
            if (modifications == null) {
                modifications = new ArrayList<HeadingProjectionAnnotation>();
            }
            modifications.add(projectionAnnotation);
            Position position = annotationModel.getPosition((Annotation)projectionAnnotation);
            if (!collapseRegionIncludingCaret && projectionAnnotation.isCollapsed() && selectedPosition != null && selectedPosition.overlapsWith(position.getOffset(), position.getLength())) {
                projectionAnnotation.markExpanded();
            }
            if (selectedPosition == null || position == null || !projectionAnnotation.isCollapsed() || !selectedPosition.overlapsWith(position.offset, position.length)) continue;
            updateSelectedRange = true;
        }
        if (modifications != null) {
            if (updateSelectedRange) {
                int offset = 0;
                iterator = annotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    Position position;
                    HeadingProjectionAnnotation projectionAnnotation;
                    Annotation annotation = (Annotation)iterator.next();
                    if (!(annotation instanceof HeadingProjectionAnnotation) || (projectionAnnotation = (HeadingProjectionAnnotation)annotation).isCollapsed() || (position = annotationModel.getPosition((Annotation)projectionAnnotation)) == null) continue;
                    offset = position.offset;
                    break;
                }
                this.viewer.setSelectedRange(offset, 0);
            }
            annotationModel.modifyAnnotations(null, null, modifications.toArray(new Annotation[modifications.size()]));
        }
    }

    @Override
    public final boolean isFoldingEnabled() {
        return this.viewer.getProjectionAnnotationModel() != null;
    }

    private static abstract class AbstractItemsAnnotationOperation
    implements AnnotationOperation {
        final Set<String> ids;

        protected AbstractItemsAnnotationOperation(Collection<OutlineItem> items) {
            this.ids = this.idsOf(items);
        }

        Set<String> idsOf(Collection<OutlineItem> items) {
            if (items == null || items.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<String> ids = new HashSet<String>();
            for (OutlineItem item : items) {
                ids.add(item.getId());
            }
            return ids;
        }

        @Override
        public final boolean operate(HeadingProjectionAnnotation annotation) {
            if (this.ids.contains(annotation.getHeadingId())) {
                return this.operateOnSelected(annotation);
            }
            return this.operateOnUnselected(annotation);
        }

        public abstract boolean operateOnSelected(HeadingProjectionAnnotation var1);

        public boolean operateOnUnselected(HeadingProjectionAnnotation annotation) {
            return false;
        }
    }

    private static interface AnnotationOperation {
        public boolean operate(HeadingProjectionAnnotation var1);
    }
}

