/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.ui;

import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaConnectorUi;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaRepositorySettingsPage;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TasksUiTestUtil;
import org.eclipse.ui.PlatformUI;

public class BugzillaRepositorySettingsPageTest
extends TestCase {
    private TaskRepositoryManager manager;
    private TaskRepository repository;
    private EditRepositoryWizard wizard;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = TasksUiPlugin.getRepositoryManager();
        this.manager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
        this.repository = new TaskRepository("bugzilla", BugzillaFixture.current().getRepositoryUrl());
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(credentials.getUserName(), credentials.getPassword()), false);
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        TasksUiTestUtil.ensureTasksUiInitialization();
        BugzillaConnectorUi connectorUi = new BugzillaConnectorUi();
        this.wizard = new EditRepositoryWizard(this.repository, (AbstractRepositoryConnectorUi)connectorUi);
    }

    private BugzillaClient createClient(String hostUrl, String username, String password, String htAuthUser, String htAuthPass, String encoding) throws MalformedURLException {
        TaskRepository taskRepository = new TaskRepository("bugzilla", hostUrl);
        AuthenticationCredentials credentials = new AuthenticationCredentials(username, password);
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, credentials, false);
        AuthenticationCredentials webCredentials = new AuthenticationCredentials(htAuthUser, htAuthPass);
        taskRepository.setCredentials(AuthenticationType.HTTP, webCredentials, false);
        taskRepository.setCharacterEncoding(encoding);
        BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind());
        return BugzillaClientFactory.createClient((TaskRepository)taskRepository, (BugzillaRepositoryConnector)connector);
    }

    public void testValidationInvalidPassword() throws Exception {
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)this.wizard);
        dialog.create();
        BugzillaRepositorySettingsPage page = (BugzillaRepositorySettingsPage)this.wizard.getSettingsPage();
        page.setPassword("bogus");
        try {
            BugzillaClient client = this.createClient(page.getRepositoryUrl(), page.getUserName(), page.getPassword(), page.getHttpAuthUserId(), page.getHttpAuthPassword(), page.getCharacterEncoding());
            client.validate(null);
        }
        catch (CoreException coreException) {
            return;
        }
        BugzillaRepositorySettingsPageTest.fail((String)"LoginException didn't occur!");
    }

    public void testValidationInvalidUserid() throws Exception {
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)this.wizard);
        dialog.create();
        BugzillaRepositorySettingsPage page = (BugzillaRepositorySettingsPage)this.wizard.getSettingsPage();
        page.setUserId("bogus");
        try {
            BugzillaClient client = this.createClient(page.getRepositoryUrl(), page.getUserName(), page.getPassword(), page.getHttpAuthUserId(), page.getHttpAuthPassword(), page.getCharacterEncoding());
            client.validate(null);
        }
        catch (CoreException coreException) {
            return;
        }
        BugzillaRepositorySettingsPageTest.fail((String)"LoginException didn't occur!");
    }

    public void testValidationInvalidUrl() throws Exception {
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)this.wizard);
        dialog.create();
        BugzillaRepositorySettingsPage page = (BugzillaRepositorySettingsPage)this.wizard.getSettingsPage();
        page.setUrl("http://mylar.eclipse.org");
        try {
            BugzillaClient client = this.createClient(page.getRepositoryUrl(), page.getUserName(), page.getPassword(), page.getHttpAuthUserId(), page.getHttpAuthPassword(), page.getCharacterEncoding());
            client.validate(null);
            BugzillaRepositorySettingsPageTest.fail((String)"UnknownHostException didn't occur!");
        }
        catch (CoreException coreException) {}
    }

    public void testPersistChangeOfUrl() throws Exception {
        BugzillaRepositorySettingsPageTest.assertEquals((int)1, (int)this.manager.getAllRepositories().size());
        String tempUid = this.repository.getUserName();
        String tempPass = this.repository.getPassword();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)this.wizard);
        dialog.create();
        BugzillaRepositorySettingsPage page = (BugzillaRepositorySettingsPage)this.wizard.getSettingsPage();
        BugzillaClient client = this.createClient(page.getRepositoryUrl(), page.getUserName(), page.getPassword(), page.getHttpAuthUserId(), page.getHttpAuthPassword(), page.getCharacterEncoding());
        client.validate(null);
        page.setUrl(BugzillaFixture.current().getRepositoryUrl());
        this.wizard.performFinish();
        BugzillaRepositorySettingsPageTest.assertEquals((int)1, (int)this.manager.getAllRepositories().size());
        TaskRepository repositoryTest = this.manager.getRepository("bugzilla", BugzillaFixture.current().getRepositoryUrl());
        BugzillaRepositorySettingsPageTest.assertNotNull((Object)repositoryTest);
        BugzillaRepositorySettingsPageTest.assertEquals((String)tempUid, (String)repositoryTest.getUserName());
        BugzillaRepositorySettingsPageTest.assertEquals((String)tempPass, (String)repositoryTest.getPassword());
    }

    public void testValidateOnFinishInvalidUserId() throws Exception {
        BugzillaRepositorySettingsPageTest.assertEquals((int)1, (int)this.manager.getAllRepositories().size());
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)this.wizard);
        dialog.create();
        BugzillaRepositorySettingsPage page = (BugzillaRepositorySettingsPage)this.wizard.getSettingsPage();
        BugzillaClient client = this.createClient(page.getRepositoryUrl(), page.getUserName(), page.getPassword(), page.getHttpAuthUserId(), page.getHttpAuthPassword(), page.getCharacterEncoding());
        client.validate(null);
        String oldUserId = page.getUserName();
        page.setUserId("bogus");
        boolean finished = this.wizard.performFinish();
        BugzillaRepositorySettingsPageTest.assertFalse((boolean)finished);
        BugzillaRepositorySettingsPageTest.assertEquals((int)1, (int)this.manager.getAllRepositories().size());
        TaskRepository repositoryTest = this.manager.getRepository("bugzilla", BugzillaFixture.current().getRepositoryUrl());
        BugzillaRepositorySettingsPageTest.assertEquals((String)oldUserId, (String)repositoryTest.getCredentials(AuthenticationType.REPOSITORY).getUserName());
    }
}

