/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.epub;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.epub.EpubContentParser;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpubParser
extends AbstractParser {
    private static final long serialVersionUID = 215176772484050550L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"epub+zip"), MediaType.application((String)"x-ibooks+zip"))));
    private Parser meta = new DcXMLParser();
    private Parser content = new EpubContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedContentHandler childHandler = new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml));
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals("mimetype")) {
                String type = IOUtils.toString((InputStream)zip, (String)"UTF-8");
                metadata.set("Content-Type", type);
            } else if (entry.getName().equals("metadata.xml")) {
                this.meta.parse((InputStream)zip, (ContentHandler)new DefaultHandler(), metadata, context);
            } else if (entry.getName().endsWith(".opf")) {
                this.meta.parse((InputStream)zip, (ContentHandler)new DefaultHandler(), metadata, context);
            } else if (entry.getName().endsWith(".html") || entry.getName().endsWith(".xhtml")) {
                this.content.parse((InputStream)zip, (ContentHandler)childHandler, metadata, context);
            }
            entry = zip.getNextEntry();
        }
        xhtml.endDocument();
    }
}

