/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RepositorySettingsPageTest {
    @Test
    public void proxyPortTriggersValidation() throws Exception {
        TestRepositorySettingsPage page = new TestRepositorySettingsPage(this.createTaskRepository());
        IWizardContainer container = this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ((IWizardContainer)Mockito.verify((Object)container, (VerificationMode)Mockito.times((int)2))).updateButtons();
        page.proxyPortEditor.setStringValue("123");
        ((IWizardContainer)Mockito.verify((Object)container, (VerificationMode)Mockito.times((int)3))).updateButtons();
    }

    @Test
    public void validatesWithNoCredentials() throws Exception {
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(this.createTaskRepository());
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        page.validateSettings();
    }

    @Test
    public void labelAndUrlUpdatedWhenNoCredentials() throws Exception {
        TaskRepository repository = this.createTaskRepository();
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(repository);
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertEquals((Object)repository.getRepositoryUrl(), (Object)page.getRepositoryUrl());
        Assert.assertEquals((Object)repository.getRepositoryLabel(), (Object)page.getRepositoryLabel());
    }

    @Test
    public void labelAndUrlNotUpdatedWhenNoTaskRepository() throws Exception {
        RepositorySettingsPageWithNoCredentials page = new RepositorySettingsPageWithNoCredentials(null);
        this.applyWizardContainer(page);
        page.createControl((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Assert.assertEquals((Object)"", (Object)page.getRepositoryUrl());
        Assert.assertEquals((Object)"", (Object)page.getRepositoryLabel());
    }

    @Test
    public void applyToNewRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.removeProperty("org.eclipse.mylyn.brand.id");
        AbstractRepositorySettingsPage page = this.createPage(null);
        Assert.assertNull((Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
        page.applyTo(repository);
        Assert.assertNull((Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
        page.setBrand("org.mylyn");
        page.applyTo(repository);
        Assert.assertEquals((Object)"org.mylyn", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void applyToExistingRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "existing.brand");
        AbstractRepositorySettingsPage page = this.createPage(repository);
        page.setBrand("org.mylyn");
        page.applyTo(repository);
        Assert.assertEquals((Object)"org.mylyn", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void applyNullBrandToExistingRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "existing.brand");
        AbstractRepositorySettingsPage page = this.createPage(repository);
        page.setBrand(null);
        page.applyTo(repository);
        Assert.assertEquals((Object)"existing.brand", (Object)repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Test
    public void setsTitleFromBrand() {
        AbstractRepositorySettingsPage page = this.createPage(null);
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
        page.setBrand("org.mylyn");
        Assert.assertEquals((Object)"Label for org.mylyn", (Object)page.getTitle());
    }

    @Test
    public void setsTitleFromBrandedRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.setProperty("org.eclipse.mylyn.brand.id", "org.mylyn");
        AbstractRepositorySettingsPage page = this.createPage(repository);
        Assert.assertEquals((Object)"Label for org.mylyn", (Object)page.getTitle());
    }

    @Test
    public void setsTitleFromUnbrandedRepository() {
        TaskRepository repository = this.createTaskRepository();
        repository.removeProperty("org.eclipse.mylyn.brand.id");
        AbstractRepositorySettingsPage page = this.createPage(repository);
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
    }

    private AbstractRepositorySettingsPage createPage(TaskRepository repository) {
        AbstractRepositorySettingsPage page = (AbstractRepositorySettingsPage)Mockito.spy((Object)((Object)new RepositorySettingsPageWithNoCredentials(repository)));
        ((AbstractRepositorySettingsPage)Mockito.doReturn((Object)"label").when((Object)page)).getRepositoryLabel();
        Mockito.when((Object)page.needsProxy()).thenReturn((Object)false);
        return page;
    }

    private IWizardContainer applyWizardContainer(TestRepositorySettingsPage page) {
        IWizard wizard = (IWizard)Mockito.mock(IWizard.class);
        IWizardContainer container = (IWizardContainer)Mockito.mock(IWizardContainer.class);
        Mockito.when((Object)wizard.getContainer()).thenReturn((Object)container);
        page.setWizard(wizard);
        return container;
    }

    private TaskRepository createTaskRepository() {
        TaskRepository repository = new TaskRepository("mock", "url");
        repository.setRepositoryLabel("label");
        return repository;
    }

    public static class RepositorySettingsPageWithNoCredentials
    extends TestRepositorySettingsPage {
        public RepositorySettingsPageWithNoCredentials(TaskRepository taskRepository) {
            super(taskRepository);
            this.setNeedsRepositoryCredentials(false);
        }
    }

    public static class TestRepositorySettingsPage
    extends AbstractRepositorySettingsPage {
        public TestRepositorySettingsPage(TaskRepository taskRepository) {
            super("Title", "Description", taskRepository, (AbstractRepositoryConnector)MockRepositoryConnector.getDefault());
            this.setNeedsProxy(true);
        }

        protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
            AbstractRepositorySettingsPage.Validator validator = new AbstractRepositorySettingsPage.Validator(this){

                public void run(IProgressMonitor monitor) throws CoreException {
                }
            };
            validator.setStatus(Status.OK_STATUS);
            return validator;
        }

        public String getConnectorKind() {
            return "mock";
        }

        protected void createAdditionalControls(Composite parent) {
        }
    }
}

