/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.AdaptiveRefreshPolicy;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.provisional.commons.ui.EnhancedFilteredTree;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractFilteredTree
extends EnhancedFilteredTree {
    private static final int FILTER_WIDTH_MIN = 60;
    private static final int FILTER_WIDTH_MAX = 300;
    private static final float FILTER_WIDTH_RATIO = 0.35f;
    public static final String LABEL_FIND = Messages.AbstractFilteredTree_Find;
    private Job refreshJob;
    private AdaptiveRefreshPolicy refreshPolicy;
    private Composite progressComposite;
    private Composite searchComposite;
    private boolean showProgress = false;
    private Color textColor = null;
    private Font textFont = null;

    public AbstractFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        try {
            Field refreshField = FilteredTree.class.getDeclaredField("refreshJob");
            refreshField.setAccessible(true);
            this.refreshJob = (Job)refreshField.get((Object)this);
            this.refreshPolicy = new AdaptiveRefreshPolicy(this.refreshJob);
            this.filterText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                    if ("".equals(AbstractFilteredTree.this.filterText.getText())) {
                        AbstractFilteredTree.this.filterText.setText(LABEL_FIND);
                        AbstractFilteredTree.this.setGrayFilterText(true);
                    }
                }

                public void focusGained(FocusEvent focusEvent) {
                    if (LABEL_FIND.equals(AbstractFilteredTree.this.filterText.getText())) {
                        AbstractFilteredTree.this.filterText.setText("");
                        AbstractFilteredTree.this.setGrayFilterText(false);
                    }
                }
            });
            this.filterText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    AbstractFilteredTree.this.setGrayFilterText(false);
                }
            });
        }
        catch (Exception e) {
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Could not get refresh job", (Throwable)e));
        }
        this.setInitialText(LABEL_FIND);
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        GridLayout layout = (GridLayout)this.getLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.progressComposite = this.createProgressComposite(parent);
        this.searchComposite = this.createSearchComposite(parent);
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(false);
            ((GridData)this.searchComposite.getLayoutData()).exclude = true;
        }
        return super.createTreeControl(parent, style);
    }

    protected Composite createFilterControls(final Composite parent) {
        this.filterComposite = new Composite(parent.getParent(), 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 3;
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 3;
        gridLayout.verticalSpacing = 0;
        this.filterComposite.setLayout((Layout)gridLayout);
        super.createFilterControls(parent);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(60, -1).minSize(60, -1).applyTo((Control)parent);
        this.filterComposite.addControlListener((ControlListener)new ControlAdapter(){
            boolean handlingEvents;

            public void controlResized(ControlEvent e) {
                if (this.handlingEvents) {
                    return;
                }
                try {
                    this.handlingEvents = true;
                    Point size = parent.getParent().getSize();
                    int width = Math.max(60, (int)((float)size.x * 0.35f));
                    ((GridData)parent.getLayoutData()).widthHint = Math.min(width, 300);
                    parent.getParent().layout();
                }
                finally {
                    this.handlingEvents = false;
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractFilteredTree.this.setFilterText("");
                }
            }
        });
        ((GridData)this.filterText.getLayoutData()).verticalAlignment = 0x1000000;
        parent.setParent(this.filterComposite);
        Composite workingSetComposite = this.createActiveWorkingSetComposite(this.filterComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)workingSetComposite);
        Composite activeTaskComposite = this.createActiveTaskComposite(this.filterComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)activeTaskComposite);
        gridLayout.numColumns = this.filterComposite.getChildren().length;
        this.textColor = this.filterText.getForeground();
        this.textFont = this.filterText.getFont();
        this.setGrayFilterText(true);
        return parent;
    }

    private void setGrayFilterText(boolean gray) {
        if (gray) {
            this.filterText.setForeground(CommonColors.GRAY_MID);
        } else {
            this.filterText.setForeground(this.textColor);
            this.filterText.setFont(this.textFont);
        }
    }

    protected abstract Composite createProgressComposite(Composite var1);

    protected abstract Composite createActiveWorkingSetComposite(Composite var1);

    protected abstract Composite createActiveTaskComposite(Composite var1);

    protected Composite createSearchComposite(Composite container) {
        return null;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.refreshPolicy != null) {
            if (LABEL_FIND.equals(this.getFilterString())) {
                this.clearText();
                this.refreshPolicy.textChanged("");
            } else {
                this.refreshPolicy.textChanged(this.getFilterString());
            }
        }
        this.updateToolbar(true);
    }

    @Deprecated
    protected Job getRefreshJob() {
        return this.refreshJob;
    }

    public AdaptiveRefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        this.progressComposite.setVisible(showProgress);
        ((GridData)this.progressComposite.getLayoutData()).exclude = !showProgress;
        this.getParent().getParent().layout(true, true);
    }

    public void setShowSearch(boolean showSearch) {
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(showSearch);
            ((GridData)this.searchComposite.getLayoutData()).exclude = !showSearch;
            this.getParent().getParent().layout(true, true);
        }
    }
}

