/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.core.model.FeatureFilter;
import org.eclipse.mylyn.internal.discovery.core.model.Group;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.core.model.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDiscoveryExtensionReader {
    public static final String EXTENSION_POINT_ID = "org.eclipse.mylyn.discovery.core.connectorDiscovery";
    public static final String CONNECTOR_DESCRIPTOR = "connectorDescriptor";
    public static final String CONNECTOR_CATEGORY = "connectorCategory";
    public static final String ICON = "icon";
    public static final String OVERVIEW = "overview";
    public static final String FEATURE_FILTER = "featureFilter";
    public static final String GROUP = "group";

    public ConnectorDescriptor readConnectorDescriptor(IConfigurationElement element) throws ValidationException {
        return this.readConnectorDescriptor(element, ConnectorDescriptor.class);
    }

    public <T extends ConnectorDescriptor> T readConnectorDescriptor(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        ConnectorDescriptor connectorDescriptor;
        try {
            connectorDescriptor = (ConnectorDescriptor)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            String kinds = element.getAttribute("kind");
            if (kinds != null) {
                String[] akinds;
                String[] stringArray = akinds = kinds.split("\\s*,\\s*");
                int n = akinds.length;
                int n2 = 0;
                while (n2 < n) {
                    String kind = stringArray[n2];
                    connectorDescriptor.getKind().add(ConnectorDescriptorKind.fromValue(kind));
                    ++n2;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_value_kind);
        }
        connectorDescriptor.setName(element.getAttribute("name"));
        connectorDescriptor.setProvider(element.getAttribute("provider"));
        connectorDescriptor.setLicense(element.getAttribute("license"));
        connectorDescriptor.setDescription(element.getAttribute("description"));
        connectorDescriptor.setSiteUrl(element.getAttribute("siteUrl"));
        connectorDescriptor.setId(element.getAttribute("id"));
        connectorDescriptor.setCategoryId(element.getAttribute("categoryId"));
        connectorDescriptor.setPlatformFilter(element.getAttribute("platformFilter"));
        connectorDescriptor.setGroupId(element.getAttribute("groupId"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(FEATURE_FILTER);
        int n = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n) {
            child = iConfigurationElementArray[n3];
            FeatureFilter featureFilterItem = this.readFeatureFilter(child);
            featureFilterItem.setConnectorDescriptor(connectorDescriptor);
            connectorDescriptor.getFeatureFilter().add(featureFilterItem);
            ++n3;
        }
        iConfigurationElementArray = element.getChildren(ICON);
        n = iConfigurationElementArray.length;
        n3 = 0;
        while (n3 < n) {
            child = iConfigurationElementArray[n3];
            Icon iconItem = this.readIcon(child);
            iconItem.setConnectorDescriptor(connectorDescriptor);
            if (connectorDescriptor.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorDescriptor.setIcon(iconItem);
            ++n3;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n3 = 0;
        while (n3 < n) {
            child = iConfigurationElementArray[n3];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setConnectorDescriptor(connectorDescriptor);
            if (connectorDescriptor.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorDescriptor.setOverview(overviewItem);
            ++n3;
        }
        connectorDescriptor.validate();
        return (T)connectorDescriptor;
    }

    public ConnectorCategory readConnectorCategory(IConfigurationElement element) throws ValidationException {
        return this.readConnectorCategory(element, ConnectorCategory.class);
    }

    public <T extends ConnectorCategory> T readConnectorCategory(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        ConnectorCategory connectorCategory;
        try {
            connectorCategory = (ConnectorCategory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        connectorCategory.setId(element.getAttribute("id"));
        connectorCategory.setName(element.getAttribute("name"));
        connectorCategory.setDescription(element.getAttribute("description"));
        connectorCategory.setRelevance(element.getAttribute("relevance"));
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ICON);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Icon iconItem = this.readIcon(child);
            iconItem.setConnectorCategory(connectorCategory);
            if (connectorCategory.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorCategory.setIcon(iconItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(OVERVIEW);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setConnectorCategory(connectorCategory);
            if (connectorCategory.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorCategory.setOverview(overviewItem);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(GROUP);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iConfigurationElementArray[n2];
            Group groupItem = this.readGroup(child);
            groupItem.setConnectorCategory(connectorCategory);
            connectorCategory.getGroup().add(groupItem);
            ++n2;
        }
        connectorCategory.validate();
        return (T)connectorCategory;
    }

    public Icon readIcon(IConfigurationElement element) throws ValidationException {
        Icon icon = new Icon();
        icon.setImage16(element.getAttribute("image16"));
        icon.setImage32(element.getAttribute("image32"));
        icon.setImage48(element.getAttribute("image48"));
        icon.setImage64(element.getAttribute("image64"));
        icon.setImage128(element.getAttribute("image128"));
        icon.validate();
        return icon;
    }

    public Overview readOverview(IConfigurationElement element) throws ValidationException {
        Overview overview = new Overview();
        overview.setSummary(element.getAttribute("summary"));
        overview.setUrl(element.getAttribute("url"));
        overview.setScreenshot(element.getAttribute("screenshot"));
        overview.validate();
        return overview;
    }

    public FeatureFilter readFeatureFilter(IConfigurationElement element) throws ValidationException {
        FeatureFilter featureFilter = new FeatureFilter();
        featureFilter.setFeatureId(element.getAttribute("featureId"));
        featureFilter.setVersion(element.getAttribute("version"));
        featureFilter.validate();
        return featureFilter;
    }

    public Group readGroup(IConfigurationElement element) throws ValidationException {
        Group group = new Group();
        group.setId(element.getAttribute("id"));
        group.validate();
        return group;
    }
}

