/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.wikitext.core.parser.IdGenerator;
import org.eclipse.mylyn.wikitext.core.parser.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentState
implements Locator {
    private final Map<String, String> footnoteIdToHtmlId = new HashMap<String, String>();
    private final Map<String, String> glossaryItems = new HashMap<String, String>();
    private String markupContent;
    private final IdGenerator idGenerator = new IdGenerator();
    private int lineNumber = -1;
    private int lineOffset = -1;
    private int lineCharacterOffset = 0;
    private int lineLength = 0;
    private int lineSegmentEndOffset;
    private int shift;

    public String getMarkupContent() {
        return this.markupContent;
    }

    protected void setMarkupContent(String markupContent) {
        this.markupContent = markupContent;
    }

    public String getFootnoteId(String footnote) {
        String id = this.footnoteIdToHtmlId.get(footnote);
        if (id == null) {
            id = "___fn" + footnote;
            this.footnoteIdToHtmlId.put(footnote, id);
        }
        return id;
    }

    public void addGlossaryTerm(String term, String definition) {
        String previousDef = this.glossaryItems.put(term, definition);
        if (previousDef != null && previousDef.length() > definition.length()) {
            this.glossaryItems.put(term, previousDef);
        }
    }

    public Map<String, String> getGlossaryTerms() {
        return this.glossaryItems;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    protected void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    protected void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    @Override
    public int getLineDocumentOffset() {
        return this.lineOffset;
    }

    @Override
    public int getLineCharacterOffset() {
        return this.lineCharacterOffset;
    }

    public void setLineCharacterOffset(int lineCharacterOffset) {
        this.lineCharacterOffset = lineCharacterOffset;
    }

    @Override
    public int getDocumentOffset() {
        return this.lineOffset + this.lineCharacterOffset;
    }

    @Override
    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public void setLineSegmentEndOffset(int lineSegmentEndOffset) {
        this.lineSegmentEndOffset = lineSegmentEndOffset;
    }

    @Override
    public int getLineSegmentEndOffset() {
        return this.lineSegmentEndOffset;
    }

    void setShift(int shift) {
        this.shift = shift;
    }

    int getShift() {
        return this.shift;
    }
}

