/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.core;

import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.MediaWikiIdGenerationStrategy;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.HyperlinkExternalReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.HyperlinkInternalReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.ImageReplacementToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.LineBreakToken;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.TemplateReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlCommentPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.LimitedHtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.LimitedHtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLiteralReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiLanguage
extends AbstractMarkupLanguage {
    private static final String CATEGORY_PREFIX = ":";
    private static final Pattern STANDARD_EXTERNAL_LINK_FORMAT = Pattern.compile(".*?/([^/]+)/(\\{\\d+\\})");
    private static final Pattern QUALIFIED_INTERNAL_LINK = Pattern.compile("([^/]+)/(.+)");

    public MediaWikiLanguage() {
        this.setName("MediaWiki");
        this.setInternalLinkPattern("/wiki/{0}");
    }

    public String toInternalHref(String pageName) {
        Matcher matcher;
        String pageId = pageName.replace(' ', '_');
        if (pageId.startsWith(CATEGORY_PREFIX) && pageId.length() > CATEGORY_PREFIX.length()) {
            return pageId.substring(CATEGORY_PREFIX.length());
        }
        if (pageId.startsWith("#")) {
            return pageId;
        }
        if (QUALIFIED_INTERNAL_LINK.matcher(pageId).matches() && (matcher = STANDARD_EXTERNAL_LINK_FORMAT.matcher(this.internalLinkPattern)).matches()) {
            return String.valueOf(this.internalLinkPattern.substring(0, matcher.start(1))) + pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return new MediaWikiIdGenerationStrategy();
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(new HeadingBlock());
        blocks.add(new ListBlock());
        if (this.hasPreformattedBlock()) {
            blocks.add(new PreformattedBlock());
        }
        blocks.add(new TableBlock());
        for (Block block : blocks) {
            if (block instanceof ParagraphBlock) continue;
            paragraphBreakingBlocks.add(block);
        }
    }

    private boolean hasPreformattedBlock() {
        return this.configuration == null ? true : !this.configuration.isOptimizeForRepositoryUsage();
    }

    protected void addStandardPhraseModifiers(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        boolean escapingHtml;
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        boolean bl = escapingHtml = this.configuration == null ? false : this.configuration.isEscapingHtmlAndXml();
        if (!escapingHtml) {
            String[] allowedHtmlTags = new String[]{"b", "big", "blockquote", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "rb", "rp", "rt", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"};
            phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlEndTagPhraseModifier(allowedHtmlTags));
            phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlStartTagPhraseModifier(allowedHtmlTags));
            phraseModifierSyntax.add((PatternBasedElement)new HtmlCommentPhraseModifier());
        }
    }

    protected void addStandardTokens(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new ImageReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkInternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkExternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new PatternLiteralReplacementToken("(?:(?<=\\w\\s)(----)(?=\\s\\w))", "<hr/>"));
        tokenSyntax.add((PatternBasedElement)new TemplateReplacementToken());
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.internal.wikitext.mediawiki.core.token.EntityReferenceReplacementToken());
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock(this.hasPreformattedBlock());
        if (this.configuration != null && this.configuration.isNewlinesMustCauseLineBreak()) {
            paragraphBlock.setNewlinesCauseLineBreak(true);
        }
        return paragraphBlock;
    }
}

