/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.io.IOException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.AbstractDocumentTest;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class FastMarkupPartitionerTest
extends AbstractDocumentTest {
    public void testConnectLargeDocument() throws IOException {
        IDocument document = this.createDocument("resources/large.textile");
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        long millis = System.currentTimeMillis();
        long nanos = System.nanoTime();
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        long nanosEnd = System.nanoTime();
        long millisEnd = System.currentTimeMillis();
        System.out.println("Elapsed Time in Nanos: " + (nanosEnd - nanos));
        System.out.println("Elapsed Time in Millis: " + (millisEnd - millis));
    }

    public void testTextileCausesExceptionIssue36() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        document.set("a\n# a\na\n# a\na\n# a\n\nh2. a");
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void testTextileNestedPhraseModifiersException() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        document.set("a _sample *bold*_");
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void testConfluenceTipException_bug273100() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new ConfluenceLanguage());
        document.set("{tip}\ntext1\n\ntext2\n\ntext3\n{tip}\ntext4\n");
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void testConfluenceColor() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new ConfluenceLanguage());
        document.set("{color:red}\ntext1\n\ntext2{color}\ntext3\n");
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[1] = 12;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{12, 7};
        nArrayArray[2] = new int[]{19, 13};
        nArrayArray[3] = new int[]{32, 6};
        int[][] expected = nArrayArray;
        ITypedRegion[] partitioning = partitioner.computePartitioning(0, document.getLength(), false);
        this.assertPartitioningAsExpected(expected, partitioning);
    }

    public void testConfluenceColor2() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new ConfluenceLanguage());
        document.set("{color:blue}\n{tip}\ntip\n{tip}\ntext\n{note}\nnote\n{note}\n");
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[2];
        nArray[1] = 13;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{13, 6};
        nArrayArray[2] = new int[]{19, 10};
        nArrayArray[3] = new int[]{29, 5};
        nArrayArray[4] = new int[]{34, 7};
        nArrayArray[5] = new int[]{41, 12};
        int[][] expected = nArrayArray;
        ITypedRegion[] partitioning = partitioner.computePartitioning(0, document.getLength(), false);
        this.assertPartitioningAsExpected(expected, partitioning);
    }

    private void assertPartitioningAsExpected(int[][] expected, ITypedRegion[] partitioning) {
        FastMarkupPartitionerTest.assertEquals((int)expected.length, (int)partitioning.length);
        int x = 0;
        while (x < expected.length) {
            ITypedRegion region = partitioning[x];
            FastMarkupPartitionerTest.assertEquals((String)String.format("partition %s offset expected %s but got %s", x, expected[x][0], region.getOffset()), (int)expected[x][0], (int)region.getOffset());
            FastMarkupPartitionerTest.assertEquals((String)String.format("partition %s length expected %s but got %s", x, expected[x][1], region.getLength()), (int)expected[x][1], (int)region.getLength());
            ++x;
        }
    }
}

