/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.util.anttask.AbstractTestAntTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupToHtmlTask;

public class MarkupToHtmlTaskTest
extends AbstractTestAntTask {
    protected MarkupToHtmlTask task;

    protected void setUp() throws Exception {
        super.setUp();
        this.task = this.createTask();
        this.task.setFormatOutput(true);
        this.task.setMarkupLanguage(this.languageName);
    }

    protected MarkupToHtmlTask createTask() {
        return new MarkupToHtmlTask();
    }

    public void testSimpleOutput() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.execute();
        this.listFiles();
        File htmlFile = new File(markup.getParentFile(), "markup.html");
        MarkupToHtmlTaskTest.assertTrue((htmlFile.exists() && htmlFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(htmlFile);
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<html"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</html>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<title>markup</title>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</body>"));
    }

    public void testSimpleOutputAlternateTitle() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.setTitle("Alternate Title");
        this.task.execute();
        this.listFiles();
        File htmlFile = new File(markup.getParentFile(), "markup.html");
        MarkupToHtmlTaskTest.assertTrue((htmlFile.exists() && htmlFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(htmlFile);
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<html"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</html>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<title>Alternate Title</title>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</body>"));
    }

    public void testMultipleFiles() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.setMultipleOutputFiles(true);
        this.task.execute();
        this.listFiles();
        File htmlFile = new File(markup.getParentFile(), "markup.html");
        MarkupToHtmlTaskTest.assertTrue((htmlFile.exists() && htmlFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(htmlFile);
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<html"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</html>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<title>markup</title>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("</body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content.contains("<a href=\"Second-Heading.html\" title=\"Second Heading\">Next</a>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)Pattern.compile("<td[^>]*>Second Heading</td>").matcher(content).find());
        File htmlFile2 = new File(markup.getParentFile(), "Second-Heading.html");
        MarkupToHtmlTaskTest.assertTrue((boolean)htmlFile2.exists());
        String content2 = this.getContent(htmlFile2);
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("<html"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("</html>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("<title>markup - Second Heading</title>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("<body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("</body>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)content2.contains("<a href=\"markup.html\" title=\"First Heading\">Previous</a>"));
        MarkupToHtmlTaskTest.assertTrue((boolean)Pattern.compile("<td[^>]*>First Heading</td>").matcher(content2).find());
    }

    protected File createSimpleTextileMarkup() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    public void testTaskdef() {
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(MarkupToHtmlTask.class.getPackage().getName()) + ".tasks");
        MarkupToHtmlTaskTest.assertEquals((String)MarkupToHtmlTask.class.getName(), (String)bundle.getString("wikitext-to-html"));
    }
}

