/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;

public abstract class AbstractDocumentCommand {
    protected String problemText;

    public void execute(IUndoManager undoManager, IDocument document) throws CoreException {
        if (!this.isEnabled()) {
            throw new IllegalStateException();
        }
        try {
            undoManager.beginCompoundChange();
            try {
                this.doCommand(document);
            }
            finally {
                undoManager.endCompoundChange();
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(WikiTextUiPlugin.getDefault().createStatus(4, e));
        }
    }

    public boolean isEnabled() {
        return this.getProblemText() == null;
    }

    public String getProblemText() {
        return this.problemText;
    }

    protected void setProblemText(String problemText) {
        this.problemText = problemText;
    }

    protected abstract void doCommand(IDocument var1) throws BadLocationException;
}

