/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.jira.core.ITaskAttributeMapper2;
import org.eclipse.mylyn.internal.jira.core.JiraAttribute;
import org.eclipse.mylyn.internal.jira.core.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssHandler;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraAttributeMapper
extends TaskAttributeMapper
implements ITaskAttributeMapper2 {
    private final JiraClient client;

    public JiraAttributeMapper(TaskRepository taskRepository, JiraClient client) {
        super(taskRepository);
        this.client = client;
    }

    public Date getDateValue(TaskAttribute attribute) {
        if (JiraUtil.isCustomDateTimeAttribute(attribute)) {
            try {
                return JiraRssHandler.getDateTimeFormat().parse(attribute.getValue());
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return super.getDateValue(attribute);
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (JiraUtil.isCustomDateTimeAttribute(attribute)) {
            attribute.setValue(JiraRssHandler.getDateTimeFormat().format(date));
        } else {
            super.setDateValue(attribute, date);
        }
    }

    public String getValueLabel(TaskAttribute taskAttribute) {
        if (JiraTaskDataHandler.isTimeSpanAttribute(taskAttribute)) {
            return JiraUtil.getTimeFormat(this.getTaskRepository()).format(this.getLongValue(taskAttribute));
        }
        return super.getValueLabel(taskAttribute);
    }

    public List<String> getValueLabels(TaskAttribute taskAttribute) {
        if (JiraTaskDataHandler.isTimeSpanAttribute(taskAttribute)) {
            return Collections.singletonList(JiraUtil.getTimeFormat(this.getTaskRepository()).format(this.getLongValue(taskAttribute)));
        }
        return super.getValueLabels(taskAttribute);
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        if ("task.common.component".equals(key)) {
            return JiraAttribute.COMPONENTS.id();
        }
        if ("task.common.kind".equals(key)) {
            return JiraAttribute.TYPE.id();
        }
        if ("task.common.date.due".equals(key)) {
            return JiraAttribute.DUE_DATE.id();
        }
        if ("task.common.version".equals(key)) {
            return JiraAttribute.AFFECTSVERSIONS.id();
        }
        return super.mapToRepositoryKey(parent, key);
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        Map options = this.getRepositoryOptions(attribute);
        return options != null ? options : super.getOptions(attribute);
    }

    @Override
    public Map<String, String> getRepositoryOptions(TaskAttribute attribute) {
        if (this.client.getCache().hasDetails()) {
            Project project;
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            if (JiraAttribute.PROJECT.id().equals(attribute.getId())) {
                Project[] jiraProjects;
                Project[] projectArray = jiraProjects = this.client.getCache().getProjects();
                int n = jiraProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Project jiraProject = projectArray[n2];
                    options.put(jiraProject.getId(), jiraProject.getName());
                    ++n2;
                }
                return options;
            }
            if (JiraAttribute.RESOLUTION.id().equals(attribute.getId())) {
                Resolution[] jiraResolutions;
                Resolution[] resolutionArray = jiraResolutions = this.client.getCache().getResolutions();
                int n = jiraResolutions.length;
                int n3 = 0;
                while (n3 < n) {
                    Resolution resolution = resolutionArray[n3];
                    options.put(resolution.getId(), resolution.getName());
                    ++n3;
                }
                return options;
            }
            if (JiraAttribute.PRIORITY.id().equals(attribute.getId())) {
                Priority[] jiraPriorities;
                Priority[] priorityArray = jiraPriorities = this.client.getCache().getPriorities();
                int n = jiraPriorities.length;
                int n4 = 0;
                while (n4 < n) {
                    Priority priority = priorityArray[n4];
                    options.put(priority.getId(), priority.getName());
                    ++n4;
                }
                return options;
            }
            TaskAttribute projectAttribute = attribute.getTaskData().getRoot().getMappedAttribute(JiraAttribute.PROJECT.id());
            if (projectAttribute != null && (project = this.client.getCache().getProjectById(projectAttribute.getValue())) != null) {
                if (JiraAttribute.COMPONENTS.id().equals(attribute.getId())) {
                    Component[] componentArray = project.getComponents();
                    int n = componentArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        Component component = componentArray[n5];
                        options.put(component.getId(), component.getName());
                        ++n5;
                    }
                    return options;
                }
                if (JiraAttribute.AFFECTSVERSIONS.id().equals(attribute.getId())) {
                    Version[] versionArray = project.getVersions();
                    int n = versionArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        Version version = versionArray[n6];
                        options.put(version.getId(), version.getName());
                        ++n6;
                    }
                    return options;
                }
                if (JiraAttribute.FIXVERSIONS.id().equals(attribute.getId())) {
                    Version[] versionArray = project.getVersions();
                    int n = versionArray.length;
                    int n7 = 0;
                    while (n7 < n) {
                        Version version = versionArray[n7];
                        options.put(version.getId(), version.getName());
                        ++n7;
                    }
                    return options;
                }
                if (JiraAttribute.TYPE.id().equals(attribute.getId())) {
                    boolean isSubTask = JiraTaskDataHandler.hasSubTaskType(attribute);
                    IssueType[] jiraIssueTypes = project.getIssueTypes();
                    if (jiraIssueTypes == null) {
                        jiraIssueTypes = this.client.getCache().getIssueTypes();
                    }
                    IssueType[] issueTypeArray = jiraIssueTypes;
                    int n = jiraIssueTypes.length;
                    int n8 = 0;
                    while (n8 < n) {
                        IssueType issueType = issueTypeArray[n8];
                        if (!isSubTask || issueType.isSubTaskType()) {
                            options.put(issueType.getId(), issueType.getName());
                        }
                        ++n8;
                    }
                    return options;
                }
            }
        }
        return null;
    }
}

