/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.Messages;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentPartSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class JiraTaskAttachmentHandler
extends AbstractTaskAttachmentHandler {
    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    private void downloadAttachment(TaskRepository repository, ITask task, String attachmentId, OutputStream out, IProgressMonitor monitor) throws CoreException {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
        try {
            JiraIssue issue = client.getIssueByKey(task.getTaskKey(), monitor);
            Attachment jiraAttachment = issue.getAttachmentById(attachmentId);
            if (jiraAttachment == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.internal.jira.core", "Attachment with id \"" + attachmentId + "\" for JIRA issue \"" + task.getTaskKey() + "\" not found"));
            }
            client.getAttachment(issue, jiraAttachment, out, monitor);
        }
        catch (JiraException e) {
            throw new CoreException(JiraCorePlugin.toStatus(repository, e));
        }
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.JiraTaskAttachmentHandler_Getting_attachment, -1);
            TaskAttachmentMapper attachment = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.downloadAttachment(repository, task, attachment.getAttachmentId(), out, monitor);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            monitor.done();
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.JiraTaskAttachmentHandler_Sending_attachment, -1);
            String contentType = source.getContentType();
            String filename = source.getName();
            if (attachmentAttribute != null) {
                TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
                if (mapper.getContentType() != null) {
                    contentType = mapper.getContentType();
                }
                if (mapper.getFileName() != null) {
                    filename = mapper.getFileName();
                }
            }
            JiraClient server = JiraClientFactory.getDefault().getJiraClient(repository);
            try {
                JiraIssue issue = server.getIssueByKey(task.getTaskKey(), monitor);
                server.addAttachment(issue, comment, (PartSource)new TaskAttachmentPartSource(source, filename), contentType, monitor);
            }
            catch (JiraException e) {
                throw new CoreException(JiraCorePlugin.toStatus(repository, e));
            }
        }
        finally {
            monitor.done();
        }
    }
}

