/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model.filter;

import java.io.Serializable;

public class Order
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Field field;
    private final boolean ascending;

    public Order(Field field, boolean ascending) {
        this.field = field;
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public Field getField() {
        return this.field;
    }

    public String toString() {
        return "order by " + this.field.toString() + " " + (this.ascending ? "asc" : "desc");
    }

    public static final class Field {
        private final String fieldName;
        public static final Field ISSUE_TYPE = new Field("type");
        public static final Field ISSUE_KEY = new Field("key");
        public static final Field SUMMARY = new Field("summary");
        public static final Field ASSIGNEE = new Field("assignee");
        public static final Field REPORTER = new Field("reporter");
        public static final Field PRIORITY = new Field("priority");
        public static final Field STATUS = new Field("status");
        public static final Field RESOLUTION = new Field("resolution");
        public static final Field CREATED = new Field("created");
        public static final Field UPDATED = new Field("updated");
        public static final Field DUE_DATE = new Field("due");

        private Field(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

