/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class JiraConfiguration {
    public static final String DEFAULT_DATE_PATTERN = "dd/MMM/yy";
    public static final String DEFAULT_DATE_TIME_PATTERN = "dd/MMM/yy hh:mm a";
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private String datePattern;
    private String dateTimePattern;
    private boolean compressionEnabled;
    private Locale locale;
    private String characterEncoding;
    private boolean followRedirects;
    private int workDaysPerWeek;
    private int workHoursPerDay;
    public static final int DEFAULT_WORK_DAYS_PER_WEEK = 7;
    public static final int DEFAULT_WORK_HOURS_PER_DAY = 24;

    public JiraConfiguration() {
        this.setDatePattern(DEFAULT_DATE_PATTERN);
        this.setDateTimePattern(DEFAULT_DATE_TIME_PATTERN);
        this.setLocale(DEFAULT_LOCALE);
        this.setCompressionEnabled(false);
        this.setWorkDaysPerWeek(7);
        this.setWorkHoursPerDay(24);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public void setDatePattern(String dateFormat) {
        this.datePattern = dateFormat;
    }

    public void setDateTimePattern(String dateTimeFormat) {
        this.dateTimePattern = dateTimeFormat;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat(this.getDatePattern(), this.getLocale());
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat(this.getDateTimePattern(), this.getLocale());
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public int getWorkDaysPerWeek() {
        return this.workDaysPerWeek;
    }

    public void setWorkDaysPerWeek(int workDaysPerWeek) {
        this.workDaysPerWeek = workDaysPerWeek;
    }

    public int getWorkHoursPerDay() {
        return this.workHoursPerDay;
    }

    public void setWorkHoursPerDay(int workHoursPerDay) {
        this.workHoursPerDay = workHoursPerDay;
    }
}

