/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class JiraTimeFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final int workDaysPerWeek;
    private final int workHoursPerDay;

    public JiraTimeFormat() {
        this(7, 24);
    }

    public JiraTimeFormat(int workDaysPerWeek, int workHoursPerDay) {
        Assert.isTrue((1 <= workDaysPerWeek && workDaysPerWeek <= 7 ? 1 : 0) != 0);
        Assert.isTrue((1 <= workHoursPerDay && workHoursPerDay <= 24 ? 1 : 0) != 0);
        this.workDaysPerWeek = workDaysPerWeek;
        this.workHoursPerDay = workHoursPerDay;
    }

    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        if (obj instanceof Long) {
            this.format(sb, (Long)obj);
        } else if (obj instanceof Integer) {
            this.format(sb, ((Integer)obj).intValue());
        }
        return sb;
    }

    private void format(StringBuffer sb, long seconds) {
        long minutes;
        long hours;
        long days;
        long weeks = seconds / (long)(this.workDaysPerWeek * this.workHoursPerDay * 60 * 60);
        if (weeks > 0L) {
            sb.append(Long.toString(weeks)).append('w');
        }
        if ((days = seconds % (long)(this.workDaysPerWeek * this.workHoursPerDay * 60 * 60) / (long)(this.workHoursPerDay * 60 * 60)) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(days)).append('d');
        }
        if ((hours = seconds % (long)(this.workHoursPerDay * 60 * 60) / 3600L) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(hours)).append('h');
        }
        if ((minutes = seconds % 3600L / 60L) > 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toString(minutes)).append('m');
        } else if (sb.length() == 0) {
            sb.append("0m");
        }
    }

    public long parse(String source) {
        Assert.isNotNull((Object)source);
        return (Long)this.parseObject(source, new ParsePosition(0));
    }

    public Object parseObject(String source, ParsePosition pos) {
        Pattern pattern = Pattern.compile("(\\d+w)?\\s?(\\d+d)?\\s?(\\d+h)?\\s?(\\d+m)?");
        Matcher matcher = pattern.matcher(source);
        long value = 0L;
        if (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                String group = matcher.group(i);
                if (group != null) {
                    if (group.endsWith("m")) {
                        value += Long.parseLong(group.substring(0, group.length() - 1)) * 60L;
                    } else if (group.endsWith("h")) {
                        value += Long.parseLong(group.substring(0, group.length() - 1)) * 60L * 60L;
                    } else if (group.endsWith("d")) {
                        value += Long.parseLong(group.substring(0, group.length() - 1)) * 60L * 60L * (long)this.workHoursPerDay;
                    } else if (group.endsWith("w")) {
                        value += Long.parseLong(group.substring(0, group.length() - 1)) * 60L * 60L * (long)this.workHoursPerDay * (long)this.workDaysPerWeek;
                    }
                }
                ++i;
            }
        }
        pos.setIndex(source.length() + 1);
        return value;
    }
}

