/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRedirectException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteMessageException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssReader;

public abstract class JiraRssSessionCallback
extends JiraWebSessionCallback {
    private final boolean useCompression;
    private final IssueCollector collector;

    public JiraRssSessionCallback(boolean useCompression, IssueCollector collector) {
        this.useCompression = useCompression;
        this.collector = collector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void run(JiraClient client, String baseUrl, IProgressMonitor monitor) throws JiraException, IOException {
        String rssUrl = this.getRssUrl(baseUrl);
        GetMethod rssRequest = new GetMethod(rssUrl);
        rssRequest.setFollowRedirects(false);
        if (this.useCompression) {
            rssRequest.setRequestHeader("Accept-Encoding", "gzip");
        }
        try {
            int code = this.execute((HttpMethod)rssRequest);
            if (code == 302) {
                Header locationHeader = rssRequest.getResponseHeader("location");
                if (locationHeader == null) {
                    throw new JiraRedirectException();
                }
                String url = locationHeader.getValue();
                if (!url.startsWith(String.valueOf(baseUrl) + "/browse/")) {
                    throw new JiraRedirectException(url);
                }
                rssRequest.releaseConnection();
                rssUrl = String.valueOf(url) + "?decorator=none&view=rss";
            } else if (code != 200) {
                StringBuilder sb = new StringBuilder("Unexpected result code ");
                sb.append(code);
                sb.append(" while running query: ");
                sb.append(rssUrl);
                throw new JiraRemoteMessageException(sb.toString(), rssRequest.getResponseBodyAsString());
            }
            if (!this.isXMLOrRSS((HttpMethod)rssRequest)) {
                return;
            }
            this.parseResult(client, baseUrl, rssRequest);
            return;
        }
        finally {
            rssRequest.releaseConnection();
        }
    }

    private void parseResult(JiraClient client, String baseUrl, GetMethod rssRequest) throws IOException, JiraException {
        InputStream in = rssRequest.getResponseBodyAsStream();
        try {
            if (this.isResponseGZipped((HttpMethod)rssRequest)) {
                in = new GZIPInputStream(rssRequest.getResponseBodyAsStream());
            }
            new JiraRssReader(client, this.collector).readRssFeed(in, baseUrl);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    protected abstract String getRssUrl(String var1) throws JiraException;

    private boolean isResponseGZipped(HttpMethod method) {
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        return contentEncoding != null && "gzip".equals(contentEncoding.getValue());
    }

    private boolean isXMLOrRSS(HttpMethod method) throws HttpException {
        HeaderElement[] values;
        Header contentType = method.getResponseHeader("Content-Type");
        if (contentType == null) {
            return false;
        }
        HeaderElement[] headerElementArray = values = contentType.getElements();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderElement element = headerElementArray[n2];
            if (element.getName().startsWith("text/xml")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

