/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.jira.core.WorkLogConverter;
import org.eclipse.mylyn.internal.jira.core.model.JiraWorkLog;
import org.eclipse.mylyn.internal.jira.core.service.JiraTimeFormat;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.JiraConnectorUi;
import org.eclipse.mylyn.internal.jira.ui.editor.Messages;
import org.eclipse.mylyn.internal.jira.ui.editor.WorkLogTableLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkLogPart
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.jira.ui.editor.menu.worklog";
    private final String[] columns = new String[]{Messages.WorkLogPart_Creator, Messages.WorkLogPart_Date, Messages.WorkLogPart_Worked, Messages.WorkLogPart_Description};
    private final int[] columnWidths = new int[]{130, 70, 100, 150};
    private List<TaskAttribute> logEntries;
    private boolean hasIncoming;
    private MenuManager menuManager;
    private Composite composite;
    private long newWorkDoneAmount = 0L;
    private Calendar newWorkDoneDate = new GregorianCalendar();
    private String newWorkDoneDescription = "";
    private boolean newWorkDoneAutoAdjust = true;
    private DateTime dateWidget;
    private DateTime timeWidget;
    private Text timeSpentText;
    private boolean includeWorklog;
    private JiraWorkLog newWorkLog;

    public WorkLogPart() {
        this.setPartName(Messages.WorkLogPart_Work_Log);
    }

    private void createTable(FormToolkit toolkit, Composite composite) {
        Table table = toolkit.createTable(composite, 65538);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)table);
        int i = 0;
        while (i < this.columns.length) {
            TableColumn column = new TableColumn(table, 16384, i);
            column.setText(this.columns[i]);
            column.setWidth(this.columnWidths[i]);
            ++i;
        }
        table.getColumn(2).setAlignment(131072);
        TableViewer attachmentsViewer = new TableViewer(table);
        attachmentsViewer.setUseHashlookup(true);
        attachmentsViewer.setColumnProperties(this.columns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)attachmentsViewer, (int)2);
        attachmentsViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                JiraWorkLog item1 = (JiraWorkLog)e1;
                JiraWorkLog item2 = (JiraWorkLog)e2;
                Date created1 = item1.getCreated();
                Date created2 = item2.getCreated();
                if (created1 != null && created2 != null) {
                    return created1.compareTo(created2);
                }
                if (created1 == null && created2 != null) {
                    return -1;
                }
                if (created1 != null && created2 == null) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<JiraWorkLog> workLogList = new ArrayList<JiraWorkLog>(this.logEntries.size());
        for (TaskAttribute attribute : this.logEntries) {
            JiraWorkLog log = (JiraWorkLog)new WorkLogConverter().createFrom(attribute);
            workLogList.add(log);
        }
        attachmentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        attachmentsViewer.setLabelProvider((IBaseLabelProvider)new WorkLogTableLabelProvider(new JiraTimeFormat(JiraUtil.getWorkDaysPerWeek((TaskRepository)this.getTaskEditorPage().getTaskRepository()), JiraUtil.getWorkHoursPerDay((TaskRepository)this.getTaskEditorPage().getTaskRepository()))));
        attachmentsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TasksUiUtil.openUrl((String)JiraConnectorUi.getTaskWorkLogUrl(WorkLogPart.this.getModel().getTaskRepository(), WorkLogPart.this.getModel().getTask()));
            }
        });
        attachmentsViewer.addSelectionChangedListener((ISelectionChangedListener)this.getTaskEditorPage());
        attachmentsViewer.setInput(workLogList);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)attachmentsViewer, false);
        Menu menu = this.menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        final Section section = this.createSection(parent, toolkit, this.hasIncoming);
        section.setText(String.valueOf(this.getPartName()) + " (" + this.logEntries.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (WorkLogPart.this.composite == null) {
                        WorkLogPart.this.expandSection(toolkit, section);
                        WorkLogPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.composite = toolkit.createComposite((Composite)section);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setLayoutData((Object)new GridData(1808));
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.logEntries.size() > 0) {
            this.createTable(toolkit, this.composite);
        } else {
            Label label = toolkit.createLabel(this.composite, Messages.WorkLogPart_No_work_logged);
            this.getTaskEditorPage().registerDefaultDropListener((Control)label);
        }
        Section newWorkLogSection = this.createNewWorkLogSection(toolkit, this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)newWorkLogSection);
        section.setClient((Control)this.composite);
        toolkit.paintBordersFor(this.composite);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.dispose();
    }

    private void initialize() {
        this.logEntries = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "jira.worklog");
        for (TaskAttribute attachmentAttribute : this.logEntries) {
            if (!this.getModel().hasIncomingChanges(attachmentAttribute)) continue;
            this.hasIncoming = true;
            break;
        }
        TaskAttribute newWorkLogAttribute = this.getTaskData().getRoot().getAttribute("attribute.jira.worklog.new");
        JiraWorkLog log = null;
        if (newWorkLogAttribute != null) {
            log = (JiraWorkLog)new WorkLogConverter().createFrom(newWorkLogAttribute);
        }
        if (newWorkLogAttribute != null && log != null) {
            this.newWorkDoneAmount = log.getTimeSpent();
            this.newWorkDoneDate = new GregorianCalendar();
            if (log.getStartDate() != null) {
                this.newWorkDoneDate.setTime(log.getStartDate());
            }
            this.newWorkDoneDescription = log.getComment();
            this.newWorkDoneAutoAdjust = log.isAutoAdjustEstimate();
            TaskAttribute newWorkLogSubmitAttribute = newWorkLogAttribute.getAttribute("attribute.jira.worklog.new.submit.flag");
            if (newWorkLogSubmitAttribute != null && newWorkLogSubmitAttribute.getValue().equals(String.valueOf(true))) {
                this.includeWorklog = true;
            }
        }
    }

    private JiraTimeFormat getJiraTimeFormat() {
        return new JiraTimeFormat(JiraUtil.getWorkDaysPerWeek((TaskRepository)this.getTaskEditorPage().getTaskRepository()), JiraUtil.getWorkHoursPerDay((TaskRepository)this.getTaskEditorPage().getTaskRepository()));
    }

    private Section createNewWorkLogSection(FormToolkit toolkit, Composite parent) {
        final Section newWorkLogSection = toolkit.createSection(parent, 8210);
        newWorkLogSection.setText("");
        final Button createNewWorkLog = toolkit.createButton((Composite)newWorkLogSection, Messages.WorkLogPart_Log_Work_Done, 32);
        GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).applyTo((Control)createNewWorkLog);
        createNewWorkLog.setSelection(this.includeWorklog);
        newWorkLogSection.setExpanded(this.includeWorklog);
        createNewWorkLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(createNewWorkLog)) {
                    newWorkLogSection.setExpanded(createNewWorkLog.getSelection());
                    WorkLogPart.this.addWorkLogToModel();
                    WorkLogPart.this.includeWorklog = createNewWorkLog.getSelection();
                    WorkLogPart.this.setSubmitWorklog();
                }
            }
        });
        newWorkLogSection.setTextClient((Control)createNewWorkLog);
        Composite newWorkLogComposite = toolkit.createComposite((Composite)newWorkLogSection, 0);
        newWorkLogSection.setClient((Control)newWorkLogComposite);
        newWorkLogComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(10, 5).numColumns(3).create());
        toolkit.createLabel(newWorkLogComposite, Messages.WorkLogPart_Time_Spent);
        this.timeSpentText = toolkit.createText(newWorkLogComposite, this.getJiraTimeFormat().format((Object)new Long(this.newWorkDoneAmount)));
        this.timeSpentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkLogPart.this.newWorkDoneAmount = WorkLogPart.this.getJiraTimeFormat().parse(WorkLogPart.this.timeSpentText.getText());
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        this.timeSpentText.setToolTipText(NLS.bind((String)Messages.WorkLogPart_Time_Spent_Explanation_Tooltip, (Object)JiraUtil.getWorkDaysPerWeek((TaskRepository)this.getTaskEditorPage().getTaskRepository()), (Object)JiraUtil.getWorkHoursPerDay((TaskRepository)this.getTaskEditorPage().getTaskRepository())));
        GridDataFactory.fillDefaults().span(2, 1).hint(135, -1).align(1, 4).applyTo((Control)this.timeSpentText);
        toolkit.createLabel(newWorkLogComposite, Messages.WorkLogPart_Start_Date);
        this.dateWidget = new DateTime(newWorkLogComposite, 32);
        this.dateWidget.setYear(this.newWorkDoneDate.get(1));
        this.dateWidget.setMonth(this.newWorkDoneDate.get(2));
        this.dateWidget.setDay(this.newWorkDoneDate.get(5));
        this.dateWidget.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Control)this.dateWidget, true, true);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)this.dateWidget);
        this.dateWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkLogPart.this.collectDate();
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        this.timeWidget = new DateTime(newWorkLogComposite, 128);
        this.timeWidget.setHours(this.newWorkDoneDate.get(11));
        this.timeWidget.setMinutes(this.newWorkDoneDate.get(12));
        this.timeWidget.setSeconds(this.newWorkDoneDate.get(13));
        this.timeWidget.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Control)this.timeWidget, true, true);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)this.timeWidget);
        this.timeWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkLogPart.this.collectDate();
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        toolkit.createLabel(newWorkLogComposite, Messages.WorkLogPart_Adjust_Estimate);
        Composite adjustComposite = toolkit.createComposite(newWorkLogComposite);
        adjustComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)adjustComposite);
        final Button autoAdjustButton = toolkit.createButton(adjustComposite, Messages.WorkLogPart_Auto_Adjust, 16);
        autoAdjustButton.setSelection(this.newWorkDoneAutoAdjust);
        autoAdjustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkLogPart.this.newWorkDoneAutoAdjust = autoAdjustButton.getSelection();
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        autoAdjustButton.setToolTipText(Messages.WorkLogPart_Auto_Adjust_Explanation_Tooltip);
        Button leaveAdjustButton = toolkit.createButton(adjustComposite, Messages.WorkLogPart_Leave_Existing_Estimate, 16);
        leaveAdjustButton.setSelection(!this.newWorkDoneAutoAdjust);
        leaveAdjustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkLogPart.this.newWorkDoneAutoAdjust = autoAdjustButton.getSelection();
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        leaveAdjustButton.setToolTipText(Messages.WorkLogPart_Leave_Existing_Explanation_Tooltip);
        toolkit.createLabel(newWorkLogComposite, Messages.WorkLogPart_Work_Description);
        final Text descriptionText = toolkit.createText(newWorkLogComposite, this.newWorkDoneDescription, 578);
        descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkLogPart.this.newWorkDoneDescription = descriptionText.getText();
                WorkLogPart.this.addWorkLogToModel();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(150, 100).span(2, 1).applyTo((Control)descriptionText);
        toolkit.paintBordersFor(newWorkLogComposite);
        return newWorkLogSection;
    }

    protected void collectDate() {
        if (this.newWorkDoneDate == null) {
            this.newWorkDoneDate = new GregorianCalendar();
        }
        this.newWorkDoneDate.set(this.dateWidget.getYear(), this.dateWidget.getMonth(), this.dateWidget.getDay(), this.timeWidget.getHours(), this.timeWidget.getMinutes(), this.timeWidget.getSeconds());
    }

    private boolean updateNewWorkLog() {
        JiraWorkLog tempworkLog = new JiraWorkLog();
        tempworkLog.setAuthor(this.getTaskEditorPage().getTaskRepository().getUserName());
        tempworkLog.setComment(this.newWorkDoneDescription);
        tempworkLog.setStartDate(this.newWorkDoneDate.getTime());
        tempworkLog.setTimeSpent(this.newWorkDoneAmount);
        tempworkLog.setAutoAdjustEstimate(this.newWorkDoneAutoAdjust);
        if (tempworkLog.equals((Object)this.newWorkLog)) {
            return false;
        }
        this.newWorkLog = tempworkLog;
        return true;
    }

    private void addWorkLogToModel() {
        if (this.updateNewWorkLog()) {
            TaskAttribute attribute = this.getTaskData().getRoot().getAttribute("attribute.jira.worklog.new");
            if (attribute == null) {
                attribute = this.getTaskData().getRoot().createAttribute("attribute.jira.worklog.new");
            }
            new WorkLogConverter().applyTo((Object)this.newWorkLog, attribute);
            this.getModel().attributeChanged(attribute);
        }
    }

    private void setSubmitWorklog() {
        TaskAttribute attribute = this.getTaskData().getRoot().getAttribute("attribute.jira.worklog.new");
        if (attribute != null) {
            attribute.createAttribute("attribute.jira.worklog.new.submit.flag").setValue(String.valueOf(this.includeWorklog));
            this.getModel().attributeChanged(attribute);
        }
    }
}

