/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraConfiguration;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class JiraRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private Button compressionButton;
    private boolean characterEncodingValidated;
    private Button autoRefreshConfigurationButton;
    private Button useResolutionButton;
    private Spinner workDaysPerWeekSpinner;
    private Spinner workHoursPerDaySpinner;
    private Spinner maxSearchResultsSpinner;
    private Button linkedTasksAsSubtasksButton;
    private FormToolkit toolkit;
    private JiraConfiguration configuration;
    private Text dateTimePatternText;
    private Text datePatternText;
    private Combo localeCombo;
    private Locale[] locales;
    private Button limitSearchResultsButton;
    private Button followRedirectsButton;

    public JiraRepositorySettingsPage(TaskRepository taskRepository) {
        super(Messages.JiraRepositorySettingsPage_JIRA_Repository_Settings, Messages.JiraRepositorySettingsPage_EXAMPLE_HTTP_DEVELOPER_ALTASSIAN_COM_JIRA, taskRepository);
        this.setNeedsProxy(true);
        this.setNeedsHttpAuth(true);
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.getContainer().updateButtons();
    }

    protected void createAdditionalControls(Composite parent) {
        this.configuration = this.repository != null ? JiraUtil.getConfiguration((TaskRepository)this.repository) : new JiraConfiguration();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.addRepositoryTemplatesToServerUrlCombo();
        if (this.repository != null) {
            this.characterEncodingValidated = JiraUtil.getCharacterEncodingValidated((TaskRepository)this.repository);
        }
        Label compressionLabel = new Label(parent, 0);
        compressionLabel.setText(Messages.JiraRepositorySettingsPage_Compression);
        this.compressionButton = new Button(parent, 16416);
        this.compressionButton.setText(Messages.JiraRepositorySettingsPage_Enabled);
        if (this.repository != null) {
            this.compressionButton.setSelection(JiraUtil.getCompression((TaskRepository)this.repository));
        }
        Label label = new Label(parent, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Refresh_configuration);
        this.autoRefreshConfigurationButton = new Button(parent, 16416);
        this.autoRefreshConfigurationButton.setText(Messages.JiraRepositorySettingsPage_Automatically);
        this.autoRefreshConfigurationButton.setToolTipText(Messages.JiraRepositorySettingsPage_If_checked_the_repository_configuration_will_be_periodically_updated);
        if (this.repository != null) {
            this.autoRefreshConfigurationButton.setSelection(JiraUtil.getAutoRefreshConfiguration((TaskRepository)this.repository));
        }
        label = new Label(parent, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Completed_tasks);
        this.useResolutionButton = new Button(parent, 16416);
        this.useResolutionButton.setText(Messages.JiraRepositorySettingsPage_Based_on_resolution);
        this.useResolutionButton.setToolTipText(Messages.JiraRepositorySettingsPage_If_checked_an_issue_is_considered_completed_if_it_has_a_resolution);
        if (this.repository != null) {
            this.useResolutionButton.setSelection(JiraUtil.getCompletedBasedOnResolution((TaskRepository)this.repository));
        }
        label = new Label(parent, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Subtasks);
        this.linkedTasksAsSubtasksButton = new Button(parent, 16416);
        this.linkedTasksAsSubtasksButton.setText(Messages.JiraRepositorySettingsPage_Show_linked_tasks);
        this.linkedTasksAsSubtasksButton.setToolTipText(Messages.JiraRepositorySettingsPage_If_checked_linked_tasks_show_as_subtasks_in_the_task_list);
        if (this.repository != null) {
            this.linkedTasksAsSubtasksButton.setSelection(JiraUtil.getLinkedTasksAsSubtasks((TaskRepository)this.repository));
        }
        Label followRedirectsLabel = new Label(parent, 0);
        followRedirectsLabel.setText(Messages.JiraRepositorySettingsPage_Follow_redirects);
        this.followRedirectsButton = new Button(parent, 16416);
        this.followRedirectsButton.setText(Messages.JiraRepositorySettingsPage_Enabled);
        if (this.configuration != null) {
            this.followRedirectsButton.setSelection(this.configuration.getFollowRedirects());
        }
        label = new Label(parent, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Time_tracking);
        Composite timeTrackingComposite = new Composite(parent, 0);
        timeTrackingComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.workDaysPerWeekSpinner = new Spinner(timeTrackingComposite, 133120);
        this.workDaysPerWeekSpinner.setValues(7, 1, 7, 0, 1, 1);
        if (this.repository != null) {
            this.workDaysPerWeekSpinner.setSelection(JiraUtil.getWorkDaysPerWeek((TaskRepository)this.repository));
        }
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.workDaysPerWeekSpinner);
        label = new Label(timeTrackingComposite, 0);
        label.setText(Messages.JiraRepositorySettingsPage_working_days_per_week);
        this.workHoursPerDaySpinner = new Spinner(timeTrackingComposite, 2048);
        this.workHoursPerDaySpinner.setValues(24, 1, 24, 0, 1, 1);
        if (this.repository != null) {
            this.workHoursPerDaySpinner.setSelection(JiraUtil.getWorkHoursPerDay((TaskRepository)this.repository));
        }
        label = new Label(timeTrackingComposite, 0);
        label.setText(Messages.JiraRepositorySettingsPage_working_hours_per_day);
        label = new Label(parent, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Search_results);
        Composite maxSearchResultsComposite = new Composite(parent, 0);
        maxSearchResultsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.limitSearchResultsButton = new Button(maxSearchResultsComposite, 16416);
        this.limitSearchResultsButton.setText(Messages.JiraRepositorySettingsPage_Limit);
        this.maxSearchResultsSpinner = new Spinner(maxSearchResultsComposite, 2048);
        this.maxSearchResultsSpinner.setValues(5000, 1, 99999, 0, 1, 1000);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.maxSearchResultsSpinner);
        if (this.repository != null) {
            int maxSearchResults = JiraUtil.getMaxSearchResults((TaskRepository)this.repository);
            if (maxSearchResults != -1) {
                this.maxSearchResultsSpinner.setSelection(maxSearchResults);
                this.limitSearchResultsButton.setSelection(true);
            } else {
                this.maxSearchResultsSpinner.setSelection(5000);
                this.limitSearchResultsButton.setSelection(false);
                this.maxSearchResultsSpinner.setEnabled(false);
            }
        } else {
            this.maxSearchResultsSpinner.setSelection(5000);
            this.limitSearchResultsButton.setSelection(true);
        }
        this.limitSearchResultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraRepositorySettingsPage.this.maxSearchResultsSpinner.setEnabled(JiraRepositorySettingsPage.this.limitSearchResultsButton.getSelection());
            }
        });
        this.createAdvancedComposite(parent);
    }

    private void createAdvancedComposite(Composite parent) {
        ExpandableComposite expandableComposite = this.toolkit.createExpandableComposite(parent, 290);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = -5;
        expandableComposite.setLayoutData((Object)gd);
        expandableComposite.setFont(parent.getFont());
        expandableComposite.setBackground(parent.getBackground());
        expandableComposite.setText(Messages.JiraRepositorySettingsPage_Advanced_Configuration);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                JiraRepositorySettingsPage.this.getControl().getShell().pack();
            }
        });
        this.toolkit.paintBordersFor((Composite)expandableComposite);
        Composite composite = this.toolkit.createComposite((Composite)expandableComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        expandableComposite.setClient((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Date_Picker_Format);
        this.datePatternText = new Text(composite, 0);
        this.datePatternText.setText(this.configuration.getDatePattern());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.datePatternText);
        label = new Label(composite, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Date_Time_Picker_Format);
        this.dateTimePatternText = new Text(composite, 0);
        this.dateTimePatternText.setText(this.configuration.getDateTimePattern());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.dateTimePatternText);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.datePatternText);
        label = new Label(composite, 0);
        label.setText(Messages.JiraRepositorySettingsPage_Locale);
        this.localeCombo = new Combo(composite, 12);
        this.locales = Locale.getAvailableLocales();
        Arrays.sort(this.locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        Locale[] localeArray = this.locales;
        int n = this.locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            this.localeCombo.add(locale.getDisplayName());
            ++n2;
        }
        this.localeCombo.setText(this.configuration.getLocale().getDisplayName());
        Hyperlink hyperlink = this.toolkit.createHyperlink(composite, Messages.JiraRepositorySettingsPage_Reset_to_defaults, 0);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JiraRepositorySettingsPage.this.datePatternText.setText("dd/MMM/yy");
                JiraRepositorySettingsPage.this.dateTimePatternText.setText("dd/MMM/yy hh:mm a");
                JiraRepositorySettingsPage.this.localeCombo.setText(JiraConfiguration.DEFAULT_LOCALE.getDisplayName());
            }
        });
        this.toolkit.paintBordersFor(composite);
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new JiraValidator(repository);
    }

    public void applyTo(TaskRepository repository) {
        super.applyTo(repository);
        this.configuration.setDatePattern(this.datePatternText.getText());
        this.configuration.setDateTimePattern(this.dateTimePatternText.getText());
        if (this.localeCombo.getSelectionIndex() != -1) {
            this.configuration.setLocale(this.locales[this.localeCombo.getSelectionIndex()]);
        }
        this.configuration.setFollowRedirects(this.followRedirectsButton.getSelection());
        JiraUtil.setConfiguration((TaskRepository)repository, (JiraConfiguration)this.configuration);
        JiraUtil.setCompression((TaskRepository)repository, (boolean)this.compressionButton.getSelection());
        JiraUtil.setAutoRefreshConfiguration((TaskRepository)repository, (boolean)this.autoRefreshConfigurationButton.getSelection());
        JiraUtil.setCompletedBasedOnResolution((TaskRepository)repository, (boolean)this.useResolutionButton.getSelection());
        JiraUtil.setLinkedTasksAsSubtasks((TaskRepository)repository, (boolean)this.linkedTasksAsSubtasksButton.getSelection());
        JiraUtil.setWorkDaysPerWeek((TaskRepository)repository, (int)this.workDaysPerWeekSpinner.getSelection());
        JiraUtil.setWorkHoursPerDay((TaskRepository)repository, (int)this.workHoursPerDaySpinner.getSelection());
        if (this.limitSearchResultsButton.getSelection()) {
            JiraUtil.setMaxSearchResults((TaskRepository)repository, (int)this.maxSearchResultsSpinner.getSelection());
        } else {
            JiraUtil.setMaxSearchResults((TaskRepository)repository, (int)-1);
        }
        if (this.characterEncodingValidated) {
            JiraUtil.setCharacterEncodingValidated((TaskRepository)repository, (boolean)true);
        }
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        JiraValidator jiraValidator = (JiraValidator)validator;
        ServerInfo serverInfo = jiraValidator.getServerInfo();
        if (serverInfo != null) {
            String url = jiraValidator.getRepositoryUrl();
            if (serverInfo.getBaseUrl() != null && !url.equals(serverInfo.getBaseUrl())) {
                LinkedHashSet<String> urls = new LinkedHashSet<String>();
                urls.add(url);
                urls.add(serverInfo.getBaseUrl());
                if (serverInfo.getWebBaseUrl() != null) {
                    urls.add(serverInfo.getWebBaseUrl());
                }
                UrlSelectionDialog dialog = new UrlSelectionDialog(this.getShell(), urls.toArray(new String[0]));
                dialog.setSelectedUrl(serverInfo.getBaseUrl());
                int result = dialog.open();
                if (result == 0) {
                    this.setUrl(dialog.getSelectedUrl());
                }
            }
            if (serverInfo.getCharacterEncoding() != null) {
                this.setEncoding(serverInfo.getCharacterEncoding());
            } else {
                this.setEncoding("UTF-8");
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, Messages.JiraRepositorySettingsPage_Authentication_credentials_are_valid_character_encodeing, null));
            }
            if (serverInfo.isInsecureRedirect()) {
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, Messages.JiraRepositorySettingsPage_Authentication_credentials_are_valid_server_redirected, null));
            }
            this.characterEncodingValidated = true;
        }
        super.applyValidatorResult(validator);
    }

    public String getConnectorKind() {
        return "jira";
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    static /* synthetic */ String access$0() {
        return AbstractRepositorySettingsPage.INVALID_REPOSITORY_URL;
    }

    static /* synthetic */ String access$1() {
        return AbstractRepositorySettingsPage.INVALID_LOGIN;
    }

    private class JiraValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;
        private ServerInfo serverInfo;

        public JiraValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)JiraRepositorySettingsPage.this);
            this.repository = repository;
        }

        public ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        public String getRepositoryUrl() {
            return this.repository.getRepositoryUrl();
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                new URL(this.repository.getRepositoryUrl());
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", 0, JiraRepositorySettingsPage.access$0(), null));
            }
            AbstractWebLocation location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
            try {
                this.serverInfo = JiraClientFactory.getDefault().validateConnection(location, monitor);
            }
            catch (JiraAuthenticationException jiraAuthenticationException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repository.getRepositoryUrl(), (int)4, (String)"org.eclipse.mylyn.jira.ui", (String)JiraRepositorySettingsPage.access$1()));
            }
            catch (Exception e) {
                throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)this.repository, (Throwable)e));
            }
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.jira.ui", 0, NLS.bind((String)"Validation results for {0}", (Object)this.repository.getRepositoryLabel()), null);
            status.addAll((IStatus)this.serverInfo.getStatistics().getStatus());
            status.add((IStatus)new Status(1, "org.eclipse.mylyn.jira.ui", NLS.bind((String)"Web base: {0}", (Object)this.serverInfo.getWebBaseUrl())));
            status.add((IStatus)new Status(1, "org.eclipse.mylyn.jira.ui", NLS.bind((String)"Character encoding: {0}", (Object)this.serverInfo.getCharacterEncoding())));
            status.add((IStatus)new Status(1, "org.eclipse.mylyn.jira.ui", NLS.bind((String)"Version: {0}", (Object)this.serverInfo.toString())));
            StatusHandler.log((IStatus)status);
        }
    }

    private static class UrlSelectionDialog
    extends Dialog {
        private final String[] locations;
        private String selectedUrl;

        protected UrlSelectionDialog(Shell parentShell, String[] locations) {
            super(parentShell);
            if (locations == null || locations.length < 2) {
                throw new IllegalArgumentException();
            }
            this.locations = locations;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.JiraRepositorySettingsPage_Select_repository_location);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            UrlSelectionDialog.applyDialogFont((Control)composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.JiraRepositorySettingsPage_The_repository_location_reported_by_the_server_does_not_match_the_provided_location);
            ArrayList<Button> buttons = new ArrayList<Button>(this.locations.length);
            if (this.getSelectedUrl() == null) {
                this.setSelectedUrl(this.locations[0]);
            }
            int i = 1;
            while (i < this.locations.length) {
                Button button = new Button(composite, 16);
                button.setText(String.valueOf(Messages.JiraRepositorySettingsPage_Use_server_location_) + this.locations[i]);
                button.setData((Object)this.locations[i]);
                button.setSelection(this.getSelectedUrl().equals(this.locations[i]));
                buttons.add(button);
                ++i;
            }
            Button keepLocationButton = new Button(composite, 16);
            keepLocationButton.setText(String.valueOf(Messages.JiraRepositorySettingsPage_Keep_current_location_) + this.locations[0]);
            keepLocationButton.setData((Object)this.locations[0]);
            keepLocationButton.setSelection(this.getSelectedUrl().equals(this.locations[0]));
            buttons.add(keepLocationButton);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof Button && ((Button)source).getSelection()) {
                        UrlSelectionDialog.this.setSelectedUrl((String)((Button)source).getData());
                    }
                }
            };
            for (Button button : buttons) {
                button.addSelectionListener(listener);
            }
            return composite;
        }

        public void setSelectedUrl(String selectedUrl) {
            this.selectedUrl = selectedUrl;
        }

        public String getSelectedUrl() {
            return this.selectedUrl;
        }
    }
}

